// Description and history of csm_lctr_mp.h at the end of the file.
#ifndef CSM_LCTR_MP_HEADER
// File name for preprozessor commands
#define CSM_LCTR_MP_HEADER

// includes only in exceptional cases allowed
// --none--

//******************************************************************************
//* defines and macros
//******************************************************************************
// --none--

//******************************************************************************
//* typedefs
//******************************************************************************
// --none--

//******************************************************************************
//* variable definitions
//******************************************************************************
#if (CSM_S_CSM_LOCAL_CTRL == CSM_C_F_ON)
#ifdef CSM_LCTR_SELF
// map the following definitions into our modules to create instance variables
CSM_STATIC const tCSM_CSM_CFG csm_arCsmCfg[CSM_LCTR_C_MAX_USER] =
{
  /**< configuration for protocol type local crtl */
  {
    // this allows the SPM to access the MCAN
    CSM_C_CAN_BUS_MCAN,                             // BYTE bBus
    CSM_C_PTYPE_PSGEN_CAN_LOCAL_CTRL,                  // tU32 dwProtocolType
    CSM_C_APPL_ID_MCAN_LOCAL_CTRL_SPM,           // wApplId
    NULL,
    NULL,
  },
  {
    // this allows the SPM to access the VCAN
    CSM_C_CAN_BUS_VCAN,                             // BYTE bBus
    CSM_C_PTYPE_PSGEN_CAN_LOCAL_CTRL,                  // tU32 dwProtocolType
    CSM_C_APPL_ID_VCAN_LOCAL_CTRL_SPM,           // wApplId
    NULL,
    NULL,
  },
  {
    // this allows the SPM to access the VCAN
    CSM_C_CAN_BUS_VCAN,                             // BYTE bBus
    CSM_C_PTYPE_PSGEN_CAN_LOCAL_CTRL,                  // tU32 dwProtocolType
    CSM_C_APPL_ID_VCAN_LOCAL_CTRL_IGNITION,      // wApplId
    NULL,
    NULL,
  },
  {
    // this allows the SPM to access the VCAN
    CSM_C_CAN_BUS_MCAN,                             // BYTE bBus
    CSM_C_PTYPE_PSGEN_CAN_LOCAL_CTRL,                  // tU32 dwProtocolType
    CSM_C_APPL_ID_MCAN_LOCAL_CTRL_LCM,           // wApplId
    NULL,
    NULL,
  },
  {
    // this allows the SPM to access the VCAN
    CSM_C_CAN_BUS_VCAN,                             // BYTE bBus
    CSM_C_PTYPE_PSGEN_CAN_LOCAL_CTRL,                  // tU32 dwProtocolType
    CSM_C_APPL_ID_VCAN_LOCAL_CTRL_SPM,           // wApplId
    NULL,
    NULL,
  },
};
#endif // CSM_LCTR_SELF
#endif // CSM_S_CSM_LOCAL_CTRL == CSM_C_F_ON

//******************************************************************************
//* function prototypes (scope: cnp_itp module local)
//******************************************************************************
// --none--

#else
  #error CSM_LCTR_MP.H included several times
#endif

/*******************************************************************************
 * \doxydocu
 * \file          csm_lctr_mp.h
 * \brief         Project specific part of the module internal header(s) of
 *                CSM_LCTR
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       main latest
 * \path          /di_can/modules_swa/csm/src/
 *
 * \ingroup       CSM
 * \ingroup       CSM_LCTR
 *
 * \authors       Borck
 *
 * COPYRIGHT      (c) 2015 CM-AI
 *
 * \history_begin
 * 06.03.15  \main\1  Borck
 * - Initial revision.
 *
 * 06.03.15  \main\rn_aivi  Borck
 * - added configuration array csm_arCsmCfg which is mapped into .c file (previously located in csm_stack_mp.h)
 *
 * 28.07.15  \main\rn_aivi\2  M.Prhl
 * - CSM_C_APPL_ID_RN_VCAN_LOCAL_CTRL_IGNITION added to csm_arCsmCfg.
 *
 * 30.03.16  \main\rn_aivi\3  M.Prhl
 * - CSM_C_APPL_ID_RN_MCAN_LOCAL_CTRL_LCM added to csm_arCsmCfg.
 * - CSM_C_APPL_ID_RN_VCAN_LOCAL_CTRL_LCM added to csm_arCsmCfg.
 *
 * 24.11.17  main\g3inf4cv_csm_proxy_in\1  Jayashree
 * - Modified protocoltypes as per INF4CV
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
