/* Description and history of csm_lctr_i.h at the end of the file   */

#if !defined(CSM_LCTR_I_HEADER)
#define CSM_LCTR_I_HEADER

/************************************************************************
 *   Preprocessor directives: Constants and makros                      *
 ***********************************************************************/
/* --none-- */
#define tCSM_LCTR_APPL_CALLBACK tCSM_LOCAL_CTRL_APPL_CALLBACK

/************************************************************************
 * defines and macros (scope: CAN stack and application)                *
 ***********************************************************************/
/* --none-- */

/************************************************************************
 *     Global variables                                                 *
 ***********************************************************************/
/* --none-- */

/************************************************************************
 *     Function declarations (prototypes )                              *
 ***********************************************************************/

BYTE  CSM_LCTR_bGetUserAssignedBus(BYTE bUserNumber);
BYTE  CSM_LCTR_bGetUserNumber(BYTE bBus, DWORD dwProtocolType, const void * pvAddressField, WORD wApplId);

LONG  CSM_LCTR_lInit( BYTE bInitMode);
LONG  CSM_LCTR_lExit( BYTE bExitMode);

#if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
  LONG  CSM_LCTR_lApplCallbackInit(void* pvHandle, BYTE bBus, DWORD dwProtocolType, const void* pvAddressField, tCSM_LCTR_APPL_CALLBACK* prCallBackFkt);
#else
  LONG  CSM_LCTR_lApplCallbackInit(BYTE bBus, DWORD dwProtocolType, const void* pvAddressField, tCSM_LCTR_APPL_CALLBACK* prCallBackFkt);
#endif
                                 
LONG  CSM_LCTR_lCommunicationReq( BYTE bBus, DWORD dwProtocolType, const void* pvAddressField, BYTE bAction, WORD wApplID);

#if (CSM_S_REMOTE_STACK == CSM_C_F_ON)
  void CSM_LCTR_vPROXYCommunicationCon(BYTE bBus, DWORD dwProtokollType, BYTE bState, WORD wApplID);
  void CSM_LCTR_vPROXYCommunicationInd(BYTE bBus, DWORD u32ProtokollType, BYTE bAction, WORD wApplID);
#endif

LONG  CSM_LCTR_lDataReq(DWORD dwProtocolType, const void* pvAddressField, const BYTE* pbData, WORD wDataLength);
LONG  CSM_LCTR_lDataRead(DWORD dwProtocolType, const void* pvAddressField, BYTE* pbData, WORD  wDataLength);
LONG  CSM_LCTR_lGetCommunicationState(BYTE bBus, DWORD dwProtocolType, const void* pvAddressField, BYTE* pbConnectState, WORD wApplId);

#if (CSM_S_VIRTUAL_NETWORK == CSM_C_F_ON)
  void  CSM_LCTR_vCSMBusStateInd(BYTE bBus, BYTE bCsmActState, BYTE bVN);
#else
  void  CSM_LCTR_vCSMBusStateInd(BYTE bBus, BYTE bCsmActState);
#endif
  
BOOL  CSM_LCTR_fCheckCommunicationReq(BYTE bBus);

void  CSM_LCTR_vProcessCommunicationReq(void);
void  CSM_LCTR_vProcessCommunicationCon(void);
void  CSM_LCTR_vProcessCommunicationInd(void);
void  CSM_LCTR_vSendAllIndicationsAgain(void);

#else  // CSM_LCTR_I_HEADER
  #error csm_lctr_i.h included several times
#endif

/*******************************************************************************
 * \doxydocu
 * \file          csm_lctr_i.h
 * \brief         Header file for CSM_LCTR external used function and defines.
 *
 *                Header file for CSM_LCTR external used function and defines.
 *
 * \see           CAN-SW Architektur, written by CM-DI/VTeam
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/modules_swa/csm/src/
 *
 * \ingroup       CSM_LCTR
 *
 * \authors       V-Team
 *
 * COPYRIGHT:      (c) 2009 Blaupunkt GmbH
 *
 * \history_begin
 * 09.02.09  main\1 Prhl
 * - Initial revision.
 *
 * 06.04.09  main\2 Prhl
 * - function prototypes for CSM_LCTR_vCSMBusStateInd() and CSM_LCTR_fCheckCommunicationReq() added.
 *
 * 17.07.09  main\3 Prhl
 * - CSM_vLocalCtrlProcessCommunicationCon(), CSM_vLocalCtrlProcessCommunicationInd() and CSM_vLocalCtrlProcessCommunicationReq() added.
 *
 * 17.08.09  main\4 VTeam-Franke
 * - new: CSM_LCTR_lCommunicationReq(CSM_C_DISCONNECT_ALL)
 *
 * 22.09.09  main\5 VTeam-Franke
 * - CSM_LCTR_vEndCommunicationRequests removed
 *
 * 22.10.13  main\6 Prhl
 * - Prototype CSM_LCTR_vSendAllIncicationsAgain() added.
 *
 * 24.10.13  main\7 Pistoor
 * - Renamed CSM_LCTR_vSendAllIncicationsAgain() to CSM_LCTR_vSendAllIndicationsAgain().
 *
 * 22.02.14  \main\8  Pistoor
 * - usage of pvHandle only in case (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
 *
 * 21.04.15  \main\9  Borck
 * - added prototype for CSM_LCTR_bGetUserAssignedBus() to fix an access issue in csm_proxy.c
 *
 * 23.07.15  \main\10  Borck
 * - some more prototypes added for export
 * - slightly cleaned up
 *
 * \history_end
 * *** END OF FILE ******************************************************* */
