/* Description and history of csm_itp_m.h at the end of the file.             */
#ifndef CSM_ITP_M_HEADER
/** File name for preprozessor commands */
#define CSM_ITP_M_HEADER

#include "csm_itp_mp.h"                         // include project specific part
/* No further includes allowed */

/*******************************************************************************
 * defines and macros (scope: can stack manager module local)
 ******************************************************************************/

#if (CSM_S_ITP_ASDT_EXTENSIONS == CSM_C_F_ON)
#if (CSM_S_ITP_ASDT_EXTENSION_RENAULT == CSM_C_F_ON)
/* Temperory, Timer value TL_B is needed here in CSM, not CNP. Fix later */

#define CSM_TIMER_ITP_HLRETRY_STARTUP_DELAY_MS     100
#define CSM_TIMER_ITP_HLRETRY_CYCLE_TIME           100
#define CSM_ITP_C_T_TRIAL_MAX                      0x13


static const WORD csm_tmr_HLTimers[CSM_C_ISO_TP_MAX_CONNECTIONS]=
{
  0,                          /* Diag Channel, Full duplex */
  CSM_TIMER_ITP_HLRETRY,      /* Radio->Screen */
  0,                          /* Screen->Radio */
  CSM_TIMER_HL_CBOX,          /* Radio->Cbox */
  0,                          /* Cbox->Radio */
  CSM_TIMER_HL_AMP,           /* Radio->Amp */
  0                           /* Amp->Radio */
};
#endif
#endif /* CSM_S_ITP_ASDT_EXTENSIONS enabled */


/*******************************************************************************
 * typedefs (scope: can stack manager module local)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * variable definition (scope: can stack manager module local)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * function prototypes (scope: file local = static)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * function prototypes (scope: can stack manager module local)
 ******************************************************************************/
LONG CSM_ITP_lExit( BYTE bExitMode);
LONG CSM_ITP_lInit( BYTE bInitMode);

#ifdef CSM_C_PTYPE_USED_STD_USDT_ISO
BYTE csm_bGetItpNATelIndex(const void* pvAddressField);
#endif

BYTE csm_bGetItpExtTelIndex(const void* pvAddressField);
BYTE csm_bGetItpExtMuxTelIndex(const void* pvAddressField);
LONG csm_lCheckItpDataReqErrors(BYTE bIsoTpChannel, const BYTE * pbData, WORD wDataLength);

#if (CSM_S_CALLBACK_INIT_BY_APPLICATION == CSM_C_F_ON)
#if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
  LONG CSM_ITP_lApplCallbackInit(void* pvHandle, BYTE bBus, DWORD dwProtocolType, const void * pvAddressField, tCSM_ISO_TP_USDT_APPL_CALLBACK * prCallBackFkt);
#else
  LONG CSM_ITP_lApplCallbackInit(BYTE bBus, DWORD dwProtocolType, const void * pvAddressField, tCSM_ISO_TP_USDT_APPL_CALLBACK * prCallBackFkt);
#endif // CSM_S_USE_CALLBACK_WITH_HANDLE
#endif // CSM_S_CALLBACK_INIT_BY_APPLICATION

LONG CSM_ITP_lGetCommunicationState(BYTE  bBus, DWORD dwProtocolType, const void * pvAddressField, BYTE * pbConnectState, WORD wApplId);
LONG CSM_ITP_lCommunicationReq(BYTE bBus, DWORD dwProtocolType, const void * pvAddressField, BYTE bAction, WORD wApplID);
LONG CSM_ITP_lDataReq(DWORD dwProtocolType, const void * pvAddressField, const BYTE * pbData, WORD wDataLength);

#if (CSM_S_J1939 == CSM_C_F_ON)
LONG CSM_J1939_lGetCommunicationState(BYTE bBus, DWORD dwProtocolType,
                                      const void* pvAddressField,
                                      BYTE* pbConnectState, WORD wApplId);
#endif

#if (CSM_S_VIRTUAL_NETWORK == CSM_C_F_ON)
  void CSM_ITP_vCSMBusStateInd(BYTE bBus, BYTE bCsmActState, BYTE bVN);
#else
  void CSM_ITP_vCSMBusStateInd(BYTE bBus, BYTE bCsmActState);
#endif // CSM_S_VIRTUAL_NETWORK

BOOL CSM_ITP_fCheckCommunicationReq(BYTE bBus);

void CSM_ITP_vProcessCommunicationCon(void);
void CSM_ITP_vProcessCommunicationInd(void);
void CSM_ITP_vProcessCommunicationReq(void);

void CSM_ITP_vResetIndicationFlags(void);
void CSM_ITP_vSendAllIndicationsAgain(void);

#else // CSM_ITP_M_HEADER already defined
  #error CSM_ITP_M.H included several times
#endif

/*******************************************************************************
 * \doxydocu
 * \file          csm_itp_m.h
 * \brief         CAN stack manager module internal header for ISO-TP.
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESU3
 *
 * \sw_component  CAN stack
 * \project       pool
 * \path          /di_can/modules_swa/csm/src/
 *
 * \ingroup       CSM
 * \ingroup       CSM_ITP
 *
 * \authors       CM-DI/ESA3-K"ohler, -Zurm"uhl
 *
 * COPYRIGHT      (c) 2004 Blaupunkt GmbH
 *
 * \history_begin
 *
 * 31.08.04  main\1 CM-DI/ESA3-K"ohler
 * - Initial revision.
 *
 * 28.01.05  main\2  CM-DI/ESA3-K"ohler
 * - csm_vGetItpAdrParameter() not any longer static.
 *
 * 24.02.05  main\3  CM-DI/ESA3-Prhl
 * - function prototypes added
 *
 * 08.04.05  main\4  CM-DI/ESA3-K"ohler
 * - Prototype CSM_ITP_lApplCallbackInit() encapsulated with feature switch
 *   CSM_S_CALLBACK_INIT_BY_APPLICATION.
 *
 * 27.05.05  main\5 CM-DI/ESA3-Prhl
 * - Function CSM_ITP_lInit() added
 *
 * 19.09.05  \main\6 CM-DI/ESA3-Prhl
 * - add handle to all ...CallbackInit() funktions
 *
 * 04.04.06  \main\7 CM-DI/ESA3-Prhl
 * - add const
 *
 * 14.06.06  \main\8  CM-DI/ESA3-Prhl
 * - virtual network support added
 *
 * 14.07.06  \main\9  CM-DI/ESA3-Prhl
 * - modify CSM_ITP_lApplCallbackInit()
 *   add bBus
 *
 * 21.08.06  \main\10  CM-DI/ESA3-Khler
 * - Prototype csm_bGetItpNATelIndex() featured with
 *   CSM_C_PTYPE_USED_STD_USDT_ISO
 *
 * 10.10.06  \main\11  CM-DI/ESA3-Zurmhl
 * - PVOID replaced by void* (because of const PVOID confusion!)
 *
 * 07.11.06  \main\12  CM-DI/ESA3-Khler
 * - CSM_ADDR_OPEL_USDT_ISO replaced by tCSM_ADDR_ISO_TP.
 *
 * 16.01.07  \main\13  CM-DI/ESA3-Looby
 * - Added defines for Renault ASDT High level retry.
 *
 * 15.05.07  \main\14  CM-DI/VTeam-Prhl
 * - spaces after # deleted
 *
 * 05.07.07  \main\15  CM-DI/ESA3-Looby
 * - Added defines for Renault ASDT High level retry again.
 *
 * 31.07.07  \main\16  VTeam-Prhl
 * - lint warnings removed or commented out.
 *
 * 08.10.07  \main\17  VTeam-Zurmhl
 * - uword replaced by WORD
 * 12.06.08  \main\18  VTeam-Brunotte
 * - CSM_ITP_lExit decalration added
 *
 * 17.08.09  \main\19  VTeam-Franke
 * - new: CSM_ITP_vEndCommunicationRequests
 *
 * 23.09.09  \main\20  VTeam-Franke
 * - CSM_ITP_vEndCommunicationRequests removed
 *
 * 31.10.10  \main\21  Prhl
 * - CSM_ITP_lGetCommunicationState() added
 *
 * 10.11.10  \main\22  Prhl
 * - CSM_ITP_vResetIndicationFlags() added
 *   use along csm.c        \main\273
 *             csm_itp.c    \main\62
 *             csm_itp_m.h  \main\22
 *             cnp_itp.c    \main\72
 *             cnp_itp_i.h  \main\27
 *
 * 22.10.13  \main\23  Prhl
 * - Prototype CSM_ITP_vSendAllIncicationsAgain() added.
 *
 * 24.10.13  \main\24  Pistoor
 * - Renamed CSM_ITP_vSendAllIncicationsAgain() to CSM_ITP_vSendAllIndicationsAgain().
 *
 * 22.02.14  \main\83  Pistoor
 * - usage of pvHandle only in case (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
 *
 * 10.03.15  \main\84  Borck
 * - enabled project specific module header (csm_itp_mp.h)
 *   -> to reduce size and complexity of csm_stack_mp.h
 *
 * 12.05.17  \main\85  Borck
 * - new prototype for processing DataCon, just for the case that this will be used by csm_stack some day
 * - some cleanups regarding readability
 *
 * 31.05.17  \main\86  Borck
 * - removed prototype again due to LINT warning
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
