/* Description and history of csm_ip.h at the end of the file.               */
#ifndef CSM_IP_HEADER
/** File name for preprozessor commands */
#define CSM_IP_HEADER

/* includes only in exceptional cases allowed
 * (e.g. to include port definitions) */
#ifndef CSM_CAN_STACK
  #if ( CSM_S_VW_BAP_TP == CSM_C_F_ON )
    #include "csm_bap_i.h"
  #endif
#endif

/*******************************************************************************
 * defines and macros (scope: CSM (CAN stack))
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * typedefs  (scope: CSM (CAN stack))
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * variable definitions (scope: CSM (CAN stack))
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * function prototypes (scope: CSM)
 ******************************************************************************/
CSM_API LONG CSM_lInit( BYTE bInitMode);
CSM_API LONG CSM_lExit( BYTE bExitMode);

#if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
  CSM_API LONG CSM_lApplCallbackInit(void * pvHandle, BYTE bBus, DWORD dwProtocolType, const void * pvAddressField, const void * pvCallBackFkt);
#else
  CSM_API LONG CSM_lApplCallbackInit(BYTE bBus, DWORD dwProtocolType, const void * pvAddressField, const void * pvCallBackFkt);
#endif

#if ((CSM_S_iMX_SIGNAL_ABSTRACTION == CSM_C_F_ON) || (CSM_S_v850_SIGNAL_ABSTRACTION == CSM_C_F_ON))
  #if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
  CSM_API LONG CSM_lSignalCallbackInit(void * pvHandle, DWORD dwSignalId, tCSM_PFN_CBR_SIGNAL_IND vPFNCBRSignalInd);
  CSM_API LONG CSM_lSignalCallbackInit_main(void * pvHandle, DWORD dwSignalId, tCSM_PFN_CBR_SIGNAL_IND vPFNCBRSignalInd);
  #else
  CSM_API LONG CSM_lSignalCallbackInit(DWORD dwSignalId, tCSM_PFN_CBR_SIGNAL_IND vPFNCBRSignalInd);
  CSM_API LONG CSM_lSignalCallbackInit_main(DWORD dwSignalId, tCSM_PFN_CBR_SIGNAL_IND vPFNCBRSignalInd);
  #endif
#else
  #if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
  CSM_API LONG CSM_lSignalCallbackInit(void * pvHandle, DWORD dwSignalId, tCSM_PFN_CBR_SIGNAL_IND vPFNCBRSignalInd);
  #else
  CSM_API LONG CSM_lSignalCallbackInit(DWORD dwSignalId, tCSM_PFN_CBR_SIGNAL_IND vPFNCBRSignalInd);
  #endif
#endif

#if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
  CSM_API LONG CSM_lBusErrorIndCallbackInit(void * pvHandle, tCSM_PFN_BUS_ERROR_IND vPFNBusErrorInd);
#else
  CSM_API LONG CSM_lBusErrorIndCallbackInit(tCSM_PFN_BUS_ERROR_IND vPFNBusErrorInd);
#endif

CSM_API LONG CSM_lCommunicationReq(BYTE bBus, DWORD dwProtocolType, const void * pvAddressField, BYTE bAction, WORD wApplID);

CSM_API LONG CSM_lGetCommunicationState(BYTE bBus, DWORD dwProtocolType, const void * pvAddressField, BYTE * pbConnectState, WORD wApplId);

CSM_API LONG CSM_lDataReq(DWORD dwProtocolType, const void * pvAddressField, const BYTE * pbData, WORD wDataLength);

CSM_API LONG CSM_lDataIndProcessed(DWORD dwProtocolType, const void * pvAddressField);

CSM_API LONG CSM_lSignalWrite(DWORD dwSignalId, const void * pvNewSignalData, BYTE bDataBufferLength, BYTE bTxType);

#if (CSM_S_CBR_GATEWAY == CSM_C_F_ON)
  CSM_API LONG CSM_lFullFrameSignalWrite(DWORD dwSignalId, const void * pvNewSignalData, BYTE bDataBufferLength, BYTE bTxType);
#endif

CSM_API LONG CSM_lMultipleSignalWrite(const tCSM_MultipleSignalWrite * prSignalList, const BYTE bNumberOfSignals);

CSM_API LONG CSM_lSignalRead(DWORD dwSignalId, void * pvActSignalData, BYTE bDataBufferLength, DWORD* pdwSignalStatus);
CSM_API LONG CSM_lMultipleSignalRead(tCSM_MultipleSignalRead * prSignalList, const BYTE  bNumberOfSignals);

CSM_API LONG CSM_lGetAllStateIndicationsAgain(VOID);

CSM_API LONG CSM_lConTest(DWORD dwProtocolType, void * pvAdressField, BYTE bAction);

CSM_API LONG CSM_lDataRead(DWORD dwProtocolType, const void * pvAddressField, BYTE * pbData, WORD wDataLength);

#else /* CSM_IP_HEADER already defined */
  #error CSM_IP.H included several times
#endif
/*******************************************************************************
 * \doxydocu
 * \file          csm_ip.h
 * \brief         Project specific part of the interface header(s) of CSM
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       MAIN
 * \path          /di_can/modules_swa/csm/src/
 *
 * \ingroup       CSM
 *
 * \authors       CM-DI/ESA3-Prhl
 *
 * COPYRIGHT      (c) 2004 Blaupunkt GmbH
 *
 * \history_begin
 *
 * 24.02.05  main\1  CM-DI/ESA3-Prhl
 * - Initial revision.
 *
 * 24.02.05  main\2  CM-DI/ESA3-Prhl
 * - function prototype
 *
 * 21.03.05  main\3  CM-DI/ESA3-Zurmhl
 * - function prototypes for CSM_lGetCommunicationState and
 *   CSM_lBusErrorIndCallBackInit added
 *
 * 28.04.05  main\4  CM-DI/ESA3-Zurmhl
 * - function CSM_lGetAllStateIndicationsAgain added
 *
 * 14.07.05  main\5  CM-DI/ESA3-Zurmhl
 * - "CSM_lSignalCallBackInit" changed to "CSM_lSignalCallbackInit"
 * - "CSM_lBusErrorIndCallBackInit" changed to "CSM_lBusErrorIndCallbackInit"
 *
 * 19.08.05  main\6  CM-DI/ESA3-Zurmhl
 * - CSM_lConTest() added
 *
 * 19.09.05  main\8  CM-DI/ESA3-Prhl
 * - add handle to all ...CallbackInit() funktions
 *
 * 02.12.05  \main\9  CM-DI/ESA3-Khler
 * - Type of parameter pvAddressField in CSM_lGetCommunicationState() changed to
 *   const void*.
 *
 * 27.02.06  main\10  CM-DI/ESA3-K"ohler
 * - Parameter pvAddressField in CSM_lApplCallbackInit() is now a pointer to const.
 *
 * 04.04.06  \main\11 CM-DI/ESA3-Prhl
 * - add const
 *
 * 24.05.06  \main\12 CM-DI/ESA3-Prhl
 * - add const
 *
 * 14.07.06  \main\13 CM-DI/ESA3-Prhl
 * - add bBus to CSM_lApplCallbackInit()
 *
 * 02.08.06  \main\14 CM-DI/ESA3-Zurmhl
 * - some protocol types added (removed from csm_stack_ip.h)
 * - some comments changed
 *
 * 03.08.06  \main\14 CM-DI/ESA3-Zurmhl
 * - protocol type definitions moved to csm_stack_ip.h again (since needed in cnp_itp.c!)
 *
 * 13.09.06  \main\16 CM-DI/ESA3Prhl
 * - change some void* to PVOID
 *
 * 10.10.06  \main\17  CM-DI/ESA3-Zurmhl
 * - PVOID replaced by void* (because of const PVOID confusion!)
 *
 * 08.11.06  \main\18  CM-DI/ESA3-Prhl
 * - const removed from pvActSignalData of CSM_lSignalRead()
 *
 * 16.03.07  \main\19  VTeam-Prhl
 * - CSM_lDataRead() added
 *
 * 15.06.07  \main\20  VTeam-Prhl
 * - BAP include added
 *
 * 18.06.07  \main\21  VTeam-Prhl
 * - BAP include removed
 *
 * 29.06.07  \main\22  VTeam-Prhl
 * - BAP include added
 *
 * 10.04.08  \main\23  VTeam-Prhl
 * - Function CSM_lMultipleSignalRead() added.
 *
 * 25.04.08  \main\24  VTeam-Prhl
 * - Function CSM_lMultipleSignalWrite() added.
 *
 * 25.04.08  \main\25  VTeam-Prhl
 * - Function CSM_lMultipleSignalRead() modified.
 *
 * 22.09.08  /main/26  VTeam-Pistoor
 * - Made LINT corrections
 *
 * 22.02.14  /main/27  VTeam-Pistoor
 * - usage of pvHandle only in case (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
 *
 * 24.09.15  /main/28  A.Borck
 * - first attempt to integrate the SLOT based CBR Signal abstraction.
 *   -- only SignalRead, Write and SignalCallbackInit are handled.
 *   -- MultipleRead and Write are still unhandled !!
 *
 * 23.06.16  /main/29  A.Borck
 * - API prototypes extended for proxy full frame signal writing (for gateway proxy mask)
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
