/* Description and history of csm_apl.h at the end of the file.              */
#ifndef CSM_APL_HEADER
/** File name for preprozessor commands */
#define CSM_APL_HEADER

/*******************************************************************************
 * includes (scope: API #1, CAN stack manager and csm_apl.c)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * defines and macros (scope: CAN stack)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * typedefs (scope: CAN stack)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * variable definition (scope: CAN stack)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * function prototypes (scope: CSM and applications)
 ******************************************************************************/
#if (defined CSM_SELF) || (defined CSM_APL_SELF)
  /* If the functions are empty, macros can be used
   * #define CSM_lInitApl( BYTE bInitMode)
   * #define CSM_lExitApl( BYTE bExitMode)
   */
  CSM_API LONG CSM_lInitApl( BYTE bInitMode);
  CSM_API LONG CSM_lExitApl( BYTE bExitMode);
  CSM_API LONG CSM_APL_lKernelTester( INT ac, BYTE *av[]);
  #if (CSM_S_VARIANTS_MANAGEMENT == CSM_C_F_ON)
  #if (CSM_S_SLOT_BASED_CONFIG == CSM_C_F_ON)
  //#ToDo: BKA2HI:
  BYTE CSM_APL_bGetConfigurationSlotNr(void);
  #endif
  #endif
#else
  extern LONG CSM_APL_lKernelTester( INT ac, BYTE *av[]);

  #if (CSM_S_VARIANTS_MANAGEMENT == CSM_C_F_ON)
  #if (CSM_S_SLOT_BASED_CONFIG == CSM_C_F_ON)
  // required prototype, if slot value is to be read from KDS (late CSM variant)
  extern BYTE CSM_APL_bGetConfigurationSlotNr(void);
  // new prototype, if slot value is to be read from NOR flash (early CSM variant)
  extern BYTE CSM_Proc_vGetDatapoolEarlyNorItem(BYTE* pTarget, BYTE bItem);
  #endif
  #endif
#endif // CSM_SELF || CSM_APL_SELF

#else // CSM_APL_HEADER already defined
  #error CSM_APL.H included several times
#endif

/*******************************************************************************
 * \doxydocu
 * \file          csm_apl.h
 * \brief         CAN stack and application adaptions.
 *                Functions which can neither be assigned clearly to the
 *                CAN stack manager nor to an application.
 *
 * \see           CAN-SW Architecure, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       MAIN
 * \path          /di_can/modules_swa/csm/src/
 *
 * \ingroup       CSM
 * \ingroup       CSM_APPL
 *
 * \authors       V-Team
 *
 * COPYRIGHT      (c) 2005 Blaupunkt GmbH
 *
 * \history_begin
 *
 * 25.05.05  main/2  CM-DI/ESA3-K"ohler
 * - Initial template revision.
 *
 * 03.04.07  \gm_ge09_vr55\8  CM-DI/VTeam-Brunotte
 * - CSM_APL_lMain function exported
 *
 * 10.04.07  \gm_ge09_vr55\8  CM-DI/VTeam-Brunotte
 * - CSM_APL_lMain function renamed to CSM_APL_lKernelTester
 *
 * 24.01.08  main\5 VTeam-Zurmhl
 * - module history comment block enhanced (doxygen \ingroup tag etc.)
 *
 * 09.07.15  main\6 Borck
 * - prototype for ConfigurationSlot moved here
 *
 * 09.06.17  main\rn_aivi_early_csm\1 Borck
 * - prototype added: read Slot Nr. from NOR flash instead from KDS (allows a more early startup)
 *
 * \history_end
 *//**** END OF FILE **********************************************************/

