// Description and history of cnp_lctr.c at the end of the file.
// File name for preprozessor commands
#define CNP_LCTR_SELF
// cnp_lctr.c is a file according V-team CAN-SW architecture implementation rules
#define CSM_CAN_STACK

//******************************************************************************
//* includes
//******************************************************************************
#include "csm_stack_i.h"
#include "csm_stack_m.h"
#include "csm_apl.h"

#include "cnp_lctr_i.h"                // LCTRL interface
#include "csm_proxy_i.h"               // Proxy Interface

//******************************************************************************
//* defines and macros (scope: file local)
//******************************************************************************
// none

//******************************************************************************
//* typedefs (scope: file local)
//******************************************************************************
// none

//******************************************************************************
//* variable definition (scope: file local)
//******************************************************************************
// none

//******************************************************************************
//* variable definition (scope: CAN stack)
//******************************************************************************
// none   or in cnp_lcrt_i(p).h

// we need to call a function from the ProcCsm.cpp module here
extern tVoid CSM_Proc_vInitDatapoolPDD(tVoid);

/*************** ETG Tracing ******/
#if (CSM_S_TRACE == CSM_C_F_ON)
  #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
  #define ETRACE_S_IMPORT_INTERFACE_GENERIC
  #include "etrace_if.h"

  #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
    #include "csm_etg_trace.h"
    #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FD_CSM
    // #define ETG_INLINE
    #include "trcGenProj/Header/cnp_lctr.c.trc.h"
  #endif
  #endif
#endif // CSM_S_TRACE

#ifdef CNP_LCTR_SELF
  // this makes lint happy
#endif

//******************************************************************************
//* function prototypes (scope: file local)
//******************************************************************************
// none

// Feature switch is used only to control doxygen documentation
#if (CSM_S_DOXYGEN_HIDE_NON_API_FCT == CSM_C_F_OFF)
//******************************************************************************
//* function implementation (scope: file local = static)
//******************************************************************************

/*******************************************************************************
 * function    CNP_LCTR_lInit
 * \doxydocu
 * \brief      Initialisation of the CNP_LCTR module.
 *
 * \param[in]  bInitMode
 *              CSM_C_INIT_COLD, CSM_C_INIT_WARM, CSM_C_INIT_START
 *              (correct mode will be checked in CSM_lInit())
 *
 * \return     Error value
 *
 * \access     CAN-task
 * \reentrant  no
 *
 * \lastreview 21.03.11 Borck
 *
 * \history_begin
 * 20.10.09 Prhl
 * Initial Revision.
 * \history_end
 ******************************************************************************/
LONG CNP_LCTR_lInit(BYTE bInitMode)
{
  LONG  lReturnValue = CSM_C_NO_ERROR;

  if (bInitMode == CSM_C_INIT_COLD)
  {
    // nothing to do yet while cold initialization
  }
  else if (bInitMode == CSM_C_INIT_WARM)
  {
    // nothing
  }
  else if (bInitMode == CSM_C_INIT_START)
  {
    // nothing
  }
  else
  {
    // invalid param
    lReturnValue = CSM_M_MAKE_ERROR(CSM_C_ERR_ERROR, CSM_C_ERR_LOC_CNP_LCTR, CSM_E_GENERAL_ERROR);
  }

  return lReturnValue;
}

/*******************************************************************************
 * function    CNP_LCTR_lExit
 * \doxydocu
 * \brief      Clean up CNP_LCTR code to switch off.
 *
 * \param[in]  bExitMode
 *               CSM_C_EXIT_STOP, CSM_C_EXIT_OFF
 *               (correct mode will be checked in CSM_lExit())
 *
 * \return     Error value
 *
 * \access     CAN-task
 * \reentrant  no
 *
 * \lastreview 21.03.11 Borck
 *
 * \history_begin
 * 20.10.09 Prhl
 * Initial Revision.
 * \history_end
 ******************************************************************************/
LONG CNP_LCTR_lExit(BYTE bExitMode)
{
  LONG  lRet = CSM_C_NO_ERROR;

  if (bExitMode == CSM_C_EXIT_STOP)
  {
    // nothing
  }
  else if (bExitMode == CSM_C_EXIT_OFF)
  {
    // nothing
  }
  else
  {
    // invalid param
    lRet = CSM_M_MAKE_ERROR(CSM_C_ERR_ERROR, CSM_C_ERR_LOC_CNP_LCTR, CSM_E_GENERAL_ERROR);
  }

  return lRet;
}

/*******************************************************************************
 * function    CNP_LCTR_vProcessDataReq
 * \doxydocu
 * \brief      Handle data request.
 *
 *             Handle data request.
 *             This function is called in downtream-task after trigger
 *             with CSM_C_DOWN_REASON_CNP_LCTR_DATA_REQ.
 *
 * \return     VOID
 *
 * \access     Downstream-Task
 * \reentrant  no, but only call by Downstream-Task
 *
 * \lastreview 21.03.11 Borck
 *
 * \history_begin
 * 05.11.08 Prhl
 * Initial Revision.
 * \history_end
 ******************************************************************************/
void CNP_LCTR_vProcessDataReq(void)
{
  return;
}

/*******************************************************************************
 * function    CNP_LCTR_lDataReq
 * \doxydocu
 * \brief      Trigger data request.
 *
 *             Trigger data request.
 *             This function is called from CSM_LCTR_lDataReq() to store data and
 *             trigger with CSM_C_DOWN_REASON_LCTR_DATA_REQ.
 *
 * \param[in]
 *
 *
 * \param[in]
 *
 *
 * \param[in]  pbData
 *               pointer to data
 *
 * \param[in]  wDataLength
 *               data length
 *
 * \return     LONG
 *
 * \access     any-Task
 * \reentrant  no, but only call by one Task per channel
 *
 * \lastreview 21.03.11 Borck
 *
 * \history_begin
 * 25.09.09 Jablonski
 * Initial Revision.
 * \history_end
 *****************************************************************************/
LONG CNP_LCTR_lDataReq(DWORD dwProtocolType, const void * pvAddressField, const BYTE * pbData, WORD wDataLength)
{
  LONG  lRet = CSM_C_NO_ERROR;
  BYTE  bCmd;

  #if (CSM_S_TRACE == CSM_C_F_ON)
  ETG_TRACE_USR1(("CNP_LCTR_lDataReq called"));
  #endif

  // get the 1. addressfield (2. is currently not used and should be 0xFF)
  bCmd = *((((BYTE *)pvAddressField)+0));

  // check for local or remote commands
  if ((bCmd & CSM_C_APPL_ID_VCAN_LOCAL_CTRL_LCM) == CSM_C_APPL_ID_VCAN_LOCAL_CTRL_LCM)
  {
    // remote commands -> v850
    #if (CSM_S_TRACE == CSM_C_F_ON)
    ETG_TRACE_FATAL(("CNP_LCTR_lDataReq - Processing Remote Command:0x%x -> Transfer it to v850 now", bCmd));
    #endif
    // now transform the request into a INC message and send it to CCS
    // this will be done by the CCC (Proxy) Function for DataReq (after it has been extended for this new feature)
    lRet = CSM_PROXY_lDataReq(dwProtocolType, pvAddressField, pbData, wDataLength);
  }
  else
  {
    // local commands -> process directly
    if (bCmd == CSM_C_APPL_ID_VCAN_LOCAL_CTRL_LCM)
    {
      #if (CSM_S_TRACE == CSM_C_F_ON)
      ETG_TRACE_FATAL(("CNP_LCTR_lDataReq - Processing a Local Command -> ReInitDatapool"));
      #endif
      // trigger a Datapool update to avoid 2 reboots if KDS has changed
      CSM_Proc_vInitDatapoolPDD();
    }
    else
    {
      // unsupported command
      #if (CSM_S_TRACE == CSM_C_F_ON)
      ETG_TRACE_FATAL(("CNP_LCTR_lDataReq - Invalid Local Command -> no action"));
      #endif
      lRet = CSM_M_MAKE_ERROR(CSM_C_ERR_ERROR, CSM_C_ERR_LOC_CNP_LCTR, CSM_E_INVALID_ADDRESS);
    }
  }
  // und tschuess
  return lRet;
}
#endif // CSM_S_DOXYGEN_HIDE_NON_API_FCT

#undef CNP_LCTR_SELF
#undef CSM_CAN_STACK

/*******************************************************************************
 * \doxydocu
 * \file          cnp_lctr.c
 * \brief         LCTR Transfer Layer
 *
 *                This module handles data from a non-CSM component
 *                sent to CSM for dedicated purposes.
 * *
 * \see           CAN-SW Architektur, written by CM-AI/VTeam
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/modules_swa/cnp/src/
 *
 * \ingroup       CNP
 * \ingroup       CNP_LCTR
 *
 * \authors       V-Team
 *
 * COPYRIGHT      (c) 2009 Robert Bosch GmbH CM
 *
 ************************************************************************
 * \history_begin
 *
 * 07.01.16  main\rn_aivi_proxy\1  A. Borck
 * - takeover from v850 site
 *
 * 07.01.16  main\rn_aivi_proxy\2  A. Borck
 * - adaptions of DataReq function (for datapool update after KDS changes)
 *
 * 07.11.16  main\rn_aivi_proxy\3  A. Borck
 * - extended by LCTRL DataReq routing to v850
 *
 * 24.11.17  main\g3inf4cv_csm_proxy_in\1  Jayashree
 * - Modified Appl IDs as per INF4CV
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
