/* Description and history of cnp_itp_i.h at the end of the file              */
#if !defined(CNP_ITP_I_HEADER)
/** File name for preprozessor commands */
#define CNP_ITP_I_HEADER


#include "cnp_itp_ip.h"   /* include project specific part */
/* no further includes allowed */

/*******************************************************************************
 * defines and macros (scope: CAN stack)
 ******************************************************************************/

#if(CSM_S_ITP_CHANGEFCPARAMETER == CSM_C_F_ON)
  #define CNP_ITP_C_BS       0x01
  #define CNP_ITP_C_STMIN    0x00
#endif

/* ITP Error codes */
#define CNP_ITP_C_ERR_WRONG_SN         0x03   /**< Wrong SN           (RX)       */
#define CNP_ITP_C_ERR_TIMEOUT_CR       0x04   /**< CF timeout         (RX)       */
#define CNP_ITP_C_ERR_APPL_BUF         0x05   /**< Appl. buffer full  (RX)       */
#define CNP_ITP_C_ERR_UNEXP_PDU        0x06   /**< Unexpected PDU     (RX/TX)    */
#define CNP_ITP_C_ERR_TIMEOUT_BS       0x07   /**< FC timeout            (TX)    */
#define CNP_ITP_C_ERR_WFT_OVRN         0x08   /**< Too many WAIT frames  (TX)    */
#define CNP_ITP_C_ERR_RX_MSG_TOO_LONG  0x09   /**< RX message to long for assembly buffer (RX) */
#define CNP_ITP_C_ERR_TX_MSG_TOO_LONG  0x0A   /**< TX message to long for Tx-buffer (TX) */

#if (CSM_S_ITP_ASDT_EXTENSIONS == CSM_C_F_ON)
  #if (CSM_S_ITP_ASDT_EXTENSION_RENAULT == CSM_C_F_ON)
/*------ ASDT Channel Nummber ------------------------------------------------*/
#define CNP_ITP_C_DIAG                    0  /* Channel No.          */
#define CNP_ITP_C_RADIO_SCREEN            1  /* Channel No.          */
#define CNP_ITP_C_SCREEN_RADIO            2  /* Channel no.          */
#define CNP_ITP_C_RADIO_CBOX              3  /* Channel No.          */
#define CNP_ITP_C_CBOX_RADIO              4  /* Channel no.          */
#define CNP_ITP_C_RADIO_AMP               5  /* Channel No.          */
#define CNP_ITP_C_AMP_RADIO               6  /* Channel no.          */


#define CNP_ITP_C_ASDT_TX_CHANNELS        CNP_ITP_C_RADIO_SCREEN || CNP_ITP_C_RADIO_CBOX || CNP_ITP_C_RADIO_AMP
#define CNP_ITP_C_ASDT_RX_CHANNELS        CNP_ITP_C_SCREEN_RADIO || CNP_ITP_C_CBOX_RADIO || CNP_ITP_C_AMP_RADIO


  #endif /* (CSM_S_ITP_ASDT_EXTENSION_RENAULT == CSM_C_F_ON) */
#endif /* (CSM_S_ITP_ASDT_EXTENSIONS == CSM_C_F_ON) */

/*******************************************************************************
 * typedefs (scope: CAN stack)
 ******************************************************************************/
/** Message receive  buffer   */
/* Defined in the interface file because it is used in the TSI environment, too. */
typedef struct tagCNP_ITP_MSG
{
  BYTE   bAddrMode;                 /**< Addressing mode                */
  BYTE   bSender;                   /**< Sender address                 *//* VK: ersetzen durch Addressfield ? */
  BYTE   bReceiver;                 /**< Receiver address               */
  WORD   wDataLength;               /**< Length of applic. data (byte)  */
  BYTE   *pbData;                   /**< pointer to appl. data          */
} CNP_ITP_MSG;

#ifdef TSI
  /** Application message receive buffer (ring buffer CNP_rItpRxBuf, not used at present) */
  typedef struct tagCNP_ITP_RXBUF
  {
    SHORT     nFree;                     /**< Number of free entries         */
    SHORT     nWr;                       /**< Write index                    */
    SHORT     nRd;                       /**< Read index                     */
    CNP_ITP_MSG    rMsg[CNP_ITP_C_MAXMSG]; /**< Appl. Messages                 */
  } CNP_ITP_RXBUF;

  /** Type definition for channel name info. */
  typedef struct tagCNP_ITP_CHANNEL_INFO
  {
    TCHAR szLocalComp[9];     /**< Local  component */
    TCHAR szRemoteComp[9];    /**< Remote component */
    /* Further param..? */
  } CNP_ITP_CHANNEL_INFO;
#endif /* TSI */


/** Linear receive buffer for re-assembling of message */
typedef struct tagCNP_ITP_ASS_RXBUF
{
  SHORT       nFree;          /**< Number of free entries [0|1]       */
  SHORT       nWr;            /**< Write index for data array         */
  CNP_ITP_MSG rMsg;           /**< Buffer for one message             */

} CNP_ITP_ASS_RXBUF;


/** Buffer for transmit messages. */
typedef struct tagCNP_ITP_TXBUF
{
  SHORT     nFree;              /**< Number of free entries [0|1]       */
  SHORT     nRd;                /**< Read index for data array          */
  CNP_ITP_MSG    rMsg;

} CNP_ITP_TXBUF;

/*******************************************************************************
 * variable definition (scope: CAN stack)
 ******************************************************************************/

#if defined CNP_ITP_SELF
 #define STORAGE_CL        /**<  -> Variable definitions         */
#else
 #define STORAGE_CL extern /**<  -> Variable declarations        */
#endif

/* TX buffer for appl. messages, 1 buffer per connection and service  */
STORAGE_CL CNP_ITP_TXBUF     CNP_rItpTxBuf[CSM_C_ISO_TP_MAX_CONNECTIONS];
/*--- Linear receive buffer for re-assembly   ---*/
STORAGE_CL CNP_ITP_ASS_RXBUF CNP_rItpAssRxBuf[CSM_C_ISO_TP_MAX_CONNECTIONS];
/* */
STORAGE_CL BYTE CNP_RN_ASDT_bState[CSM_C_ISO_TP_MAX_CONNECTIONS];

#ifdef TSI
  /** Application message receive ring buffer (not used at present) */
  /* U.Z.: If used (again) to be shifted to other header? (csm_stack_ip.h ?)  */
  STORAGE_CL CNP_ITP_RXBUF CNP_rItpRxBuf;
#endif /* TSI */

#undef  STORAGE_CL

/*******************************************************************************
 * function prototypes (scope: CAN stack and operating system)
 ******************************************************************************/
void CNP_ITP_vTxTimerCh00Expired(void);
void CNP_ITP_vRxTimerCh00Expired(void);
#if (1 < CSM_C_ISO_TP_MAX_CONNECTIONS)
void CNP_ITP_vTxTimerCh01Expired(void);
void CNP_ITP_vRxTimerCh01Expired(void);
#endif
#if (2 < CSM_C_ISO_TP_MAX_CONNECTIONS)
void CNP_ITP_vTxTimerCh02Expired(void);
void CNP_ITP_vRxTimerCh02Expired(void);
#endif
#if (3 < CSM_C_ISO_TP_MAX_CONNECTIONS)
void CNP_ITP_vTxTimerCh03Expired(void);
void CNP_ITP_vRxTimerCh03Expired(void);
#endif
#if (4 < CSM_C_ISO_TP_MAX_CONNECTIONS)
void CNP_ITP_vTxTimerCh04Expired(void);
void CNP_ITP_vRxTimerCh04Expired(void);
#endif
#if (5 < CSM_C_ISO_TP_MAX_CONNECTIONS)
void CNP_ITP_vTxTimerCh05Expired(void);
void CNP_ITP_vRxTimerCh05Expired(void);
#endif
#if (6 < CSM_C_ISO_TP_MAX_CONNECTIONS)
void CNP_ITP_vTxTimerCh06Expired(void);
void CNP_ITP_vRxTimerCh06Expired(void);
#endif


LONG CNP_ITP_lInit (BYTE bInitMode);
LONG CNP_ITP_lExit (BYTE bExitMode);
LONG CNP_ITP_lDataReq (BYTE bIsoTpChannel, const BYTE* pbData, WORD wDataLength);
void CNP_ITP_vCDAReceiveInd( const CSM_CAN_RX_DATA *prData);
LONG CNP_ITP_lReceiveTpdu (const CSM_CAN_RX_DATA *prCanTel);
LONG CNP_ITP_lDataIndProcessed(BYTE bIsoTpChannel);
void CNP_ITP_vProcessDataCon( void);
void CNP_ITP_vProcessDataInd( void);
void CNP_ITP_vProcessDataReq( void);
void CNP_ITP_vProcessDataIndProcessed( void);
void CNP_ITP_vProcessTimeout( void);

#if (CSM_S_ITP_FF_INDICATION_AVAILABLE == CSM_C_F_ON)
  void CNP_ITP_vProcessDataIndFF(void);
#endif

#if (CSM_S_ITP_ERROR_INDICATION_AVAILABLE == CSM_C_F_ON)
  void CNP_ITP_vProcessErrorInd(void);
#endif

#if(CSM_S_ITP_CHANGEFCPARAMETER == CSM_C_F_ON)
  LONG CNP_ITP_lChangeFCParameter(BYTE bIsoTpChannel, BYTE CanTpParameter, WORD wCanTpParameterValue);
#endif

#else // CNP_ITP_I_HEADER
 #error CNP_ITP_I.H included several times
#endif

/*******************************************************************************
 * \doxydocu
 * \file          cnp_itp_i.h
 * \brief         External interface header of ISO-TP module.
 *
 * \see           CAN-SW Architecture, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/modules_swa/cda/src/
 *
 * \ingroup       CNP
 * \ingroup       CNP_ITP
 *
 * \authors       CM-DI/ESA3-Zurmuehl
 *
 * COPYRIGHT      (c) 2004 Blaupunkt GmbH
 *
 *                  - All rights reserved -                             *
 *                                                                      *
 * This code is provided "as is" without warranty of any kind, either   *
 * expressed or implied, including but not limited to the liability     *
 * concerning the freedom from material defects, the fitness for parti- *
 * cular purposes or the freedom of proprietary rights of third parties.*
 *
 * \history_begin
 *
 *** PVCS
 * 00.10    05.02.02  Zu        Adopted from pp_prot.c
 * 00.10    xx.02.02  Zu        Changes for CAN-SWA conformance
 * 01.0     06.03.02  VK        Initial CAN-SWA revision.
 * 01.1     12.03.02  VK        WORD wCon exchanged by BYTE bCon.
 * 01.1     13.03.02  VK        Parameter connection changed from WORD to BYTE.
 *                              Assembly- and Tx buffer with variable length.
 * 01.2     13.09.02 Zu,VK      Extended addressing added.
 * 01.3     11.06.03  VK    Prototype CNP_lDataIndProcessed() added and
 *                          cnp_vItpFreeAssBuffer() moved to cnp_itp_m.h
 * 01.4     18.06.03  VK   - CNP_lDataIndProcessed() renamed
 *                           CNP_lIsoTp_DataIndProcessed().
 * 1.5      01.12.03  VK   - CNP_ITP_CON_OK/FAULT and CNP_ITP_IND_OK/FAULT and
 *                           CSM_C_GLOBAL/IMPORT removed.
 * 1.6      08.12.03  VK   - Adaptation to new naming convention
 *                           (CNP_ITP_xName for functions).
 *                         - Not used error defines removed.
 * 1.7      12.12.03  VK   - CNP_ITP_MAX_CHANNELS removed,
 *                           CSM_C_ISO_TP_MAX_CONNECTIONS used instead of.
 *** ClearCase
 *
 * 28.10.04  \main\3  CM-DI/ESA3-K"ohler
 * - New Struct for Rx telegrams in CNP_ITP_lReceiveTpdu().
 *
 * 16.02.05  \main\4  CM-DI/ESA3-K"ohler
 * - First parameter bBus for CNP_ITP_lDataReq() removed.
 *
 * 14.06.05  \main\5  CM-DI/ESA3-K"ohler
 * - Parameter of CNP_ITP_lReceiveTpdu changed to const.
 *
 * 14.06.05  \main\6  CM-DI/ESA3-K"ohler
 * - Timer Prototypes added.
 *
 * 18.07.06  \main\7  CM-DI/ESA3-K"ohler
 * - Doxygen comments added.
 * - Not used code removed.
 *
 * 28.07.06  \main\8  CM-DI/ESA3-Zurmhl
 * - Comments changed/added.
 * - Unused code removed.
 *
 * 01.08.06  \main\9  CM-DI/ESA3-Zurmhl
 * - Some constant names changed: CNP_ITP_XYZ -> CNP_IPT_C_XYZ
 *
 * 02.08.06  \main\10  CM-DI/ESA3-Zurmhl
 * - Additional constant names changed: CNP_ITP_XYZ -> CNP_IPT_C_XYZ
 *
 * 11.010.06  \main\11  CM-DI/ESA3-Looby
 * - CNP_ITP_lRNAsdtReceiveTpdu Prototype added.
 *
 * 30.10.06  \main\12  CM-DI/ESA3-Looby
 * - Prototypes added and defines for ASDT channel numbers.
 *
 * 31.10.06  \main\13  CM-DI/ESA3-Looby
 * - Changed operator for using timers ch03 back to orginal operator.
 *
 * 02.11.06  \main\14  CM-DI/ESA3-Prhl
 * - add CNP_ITP_vProcessDataCon() and CNP_ITP_vProcessDataInd()
 *
 * 10.02.07  \main\15  CM-DI/ESA3-Looby
 * - Renault CNP_ITP_vRnASDTStopASDTtimers(VOID) Prototype added.
 *
 * 15.02.07  \main\16  CM-DI/ESA3-Looby
 * - Added function for N_As/N_Ar timers.
 *
 * 13.04.07  \main\17  CM-DI/ESA3-Looby
 * - Timer Prototypes added.
 *
 * 23.04.07  \main\18  CM-DI/ESA3-Looby
 * - Added defines for ASDT channels.
 *
 * 22.05.07  \main\19  CM-DI/ESA3-Looby
 * - Added defines for AMP ASDT channel.
 *
 * 14.06.07  \main\20  VTeam-Prhl
 * - some lint warnings removed
 *
 * 11.07.07  \main\21  CM-DI/ESA3-Looby
 * - Added define for DIAG channel.
 *
 * 05.10.07  \main\22  VTeam-Prhl
 * - prototype for function CNP_ITP_vProcessDataReq(), CNP_ITP_vProcessDataIndProcessed() and CNP_ITP_vProcessTimeout();
 *
 * 13.11.07  \main\23  VTeam-Prhl
 * - Renault dirt removed.
 *
 * 24.01.08  \main\24  VTeam-Zurmhl
 * - Doxygen comment block (defgroup etc.) removed, since already implemented in csm_stack_p.h
 *
 * 03.02.08  \main\25  VTeam-Franke
 * - declaration: CNP_ITP_vProcessDataIndFF, CNP_ITP_vProcessErrorInd
 *
 * 07.10.10  \main\26  VTeam-Franke
 * - declaration: CNP_ITP_vResetIndicationFlags
 *
 * 10.11.10  \main\27  Prhl
 * - remove declaration: CNP_ITP_vResetIndicationFlags
 *   use along csm.c        \main\273
 *             csm_itp.c    \main\62
 *             csm_itp_m.h  \main\22
 *             cnp_itp.c    \main\72
 *             cnp_itp_i.h  \main\27
 *
 * 31.01.17  \main\28  Borck
 * - added 2 defines (Parameter IDs) to allow changeing BS and STMin at runtime
 * - added a prototype to change BS or STMin (both under feature switch)
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
