//******************************************************************************
//* defines and macros (scope: modul-local)
//******************************************************************************
#define CNM_OSEKI_ANZAHL_BUSSE    2     // Anzahl CAN Busse mit OSEKI NM

// map CAN bus IDs from csm_stack_ip.h to CNM internal, generic defines
// CNM_OSEKI_arBusConfig_XXX has to be adapted, if the bus index changes
#define CNM_C_CAN_BUS_0           CSM_C_CAN_BUS_VCAN  // == 0
#define CNM_C_CAN_BUS_1           CSM_C_CAN_BUS_MCAN  // == 1

// Timerbase handles (indexes)
#define CNM_OSEKI_RX_TYPE         0     // Timerbase handle for RX monitoring
#define CNM_OSEKI_TX_TYPE         1     // Timerbase handle for TX monitoring
#define CNM_OSEKI_FSM_TYPE        2     // Timerbase handle for NM FSM

// ------------------------------------------------------------------------------------------
#define CNM_OSEKI_C_TIME_BUS_STATE_CHECK_LISTEN   2500   // timeout for state LISTEN [ms]
#define CNM_OSEKI_C_TIME_BUS_STATE_CHECK_SHUTDOWN 2500   // timeout for state SHUTDOWN [ms]

// BusOff ReinitTimer for MCAN and VCAN
#define CNM_OSEKI_C_TIME_BUSOFF_REINIT_MCAN         10   // BusOff reinit time  [ms]
#define CNM_OSEKI_C_TIME_BUSOFF_REINIT_VCAN        100   // BusOff reinit time  [ms] changed from 500 due to spec. change

// map timer IDs from csm_stack_mp.h to CNM generic defines
#define CSM_TIMER_CNM_OSEKI_RX_NODE_TIMERBASE_BUS_0  CSM_TIMER_CNM_OSEKI_RX_NODE_JT1_VCAN_0     // Bus 0 is VCAN
#define CSM_TIMER_CNM_OSEKI_RX_NODE_TIMERBASE_BUS_1  CSM_TIMER_CNM_OSEKI_RX_NODE_JT1_MCAN_0     // Bus 1 is MCAN

#define CSM_TIMER_CNM_OSEKI_FSM_TIMERBASE_BUS_0      CSM_TIMER_CNM_OSEKI_FSM_0                  // Bus 0 is VCAN
#define CSM_TIMER_CNM_OSEKI_FSM_TIMERBASE_BUS_1      CSM_TIMER_CNM_OSEKI_FSM_1                  // Bus 1 is MCAN

#define CSM_TIMER_CNM_OSEKI_TX_MUTE_TIMERBASE_BUS_0  CSM_TIMER_CNM_OSEKI_TX_MUTE_JT1_VCAN_0     // Bus 0 is VCAN
#define CSM_TIMER_CNM_OSEKI_TX_MUTE_TIMERBASE_BUS_1  CSM_TIMER_CNM_OSEKI_TX_MUTE_JT1_MCAN_0     // Bus 1 is MCAN

#define CSM_TIMER_CNM_OSEKI_BUS_OFF_TIMERBASE        CSM_TIMER_CNM_OSEKI_BUS_OFF_JT1_0

#define CSM_OSEKI_FSM_NUMBER_OF_TRANSITIONS_MCAN     11
#define CSM_OSEKI_FSM_NUMBER_OF_TRANSITIONS_VCAN     10

/*******************************************************************************
 * typedefs (scope: modul-local)
 ******************************************************************************/
 /* enumeration for state IDs                                                 */
typedef enum
{
  NM_OFF           = 0x00,
  NM_ON            = 0x01,
  NM_NORMAL        = 0x02,
  NM_LIMPHOME      = 0x03,
  NM_Max,
  NM_Invalid       = 0xFFFF
} tenCNMFsmStates_ETG;

#define  eState_NM_OFF              NM_OFF
#define  eState_NM_ON               NM_ON
#define  eState_NM_NORMAL           NM_NORMAL
#define  eState_NM_LIMPHOME         NM_LIMPHOME
#define  eState_NM_Max              NM_Max
#define  eState_NM_Invalid          NM_Invalid

/* enumeration for trigger IDs                                                */
typedef enum
{
  NM_Timeout                  = 0x00000001,

  SET_NM_OFF                  = 0x00000010,
  SET_NM_SLEEP                = 0x00000020,

  SET_NM_NORMAL               = 0x00001000,
  SET_NM_LIMPHOME             = 0x00002000,
  SET_NM_ON                   = 0x00004000

} tenCNMFsmTrigger_ETG;

#define  eTrigger_NM_Timeout         NM_Timeout

#define  eTrigger_SET_NM_OFF         SET_NM_OFF
#define  eTrigger_SET_NM_SLEEP       SET_NM_NORMAL

#define  eTrigger_SET_NM_NORMAL      SET_NM_NORMAL
#define  eTrigger_SET_NM_LIMPHOME    SET_NM_LIMPHOME
#define  eTrigger_SET_NM_ON          SET_NM_ON


/*******************************************************************************
 * function prototype (scope: modul-local)
 ******************************************************************************/
extern tVoid vEntry_Off_0();
extern tVoid vEntry_Off_1();
extern tVoid vEntry_On_0();
extern tVoid vEntry_On_1();
extern tVoid vEntry_Normal_0();
extern tVoid vEntry_Normal_1();
extern tVoid vEntry_LimpHome_0();
extern tVoid vEntry_LimpHome_1();

/*******************************************************************************
 * variable declaration (scope: modul-local)
 ******************************************************************************/
/* ensure that instances of variables are only available in our .c module     */

/* some declarations first                                                    */
/* Counters and states for RX/TX monitoring Bus 0 -> MCAN                     */
extern CNM_OSEKI_RxMonitorState     CNM_OSEKI_arRxStatesBus_MCAN[];
extern CNM_OSEKI_TxMonitorState     CNM_OSEKI_arTxStatesBus_MCAN[];
extern CNM_OSEKI_BusOffMonitorState CNM_OSEKI_BusOffStates_MCAN;

/* Counters and states for RX/TX monitoring Bus 1 -> VCAN                     */
extern CNM_OSEKI_RxMonitorState     CNM_OSEKI_arRxStatesBus_VCAN[];
extern CNM_OSEKI_TxMonitorState     CNM_OSEKI_arTxStatesBus_VCAN[];
extern CNM_OSEKI_BusOffMonitorState CNM_OSEKI_BusOffStates_VCAN;

/* NM FSM                                                                     */
extern const TFsmStateConf aFsmStateTable_MCAN[];
extern const TFsmStateConf aFsmStateTable_VCAN[];

extern const TStateTransitions aFsmStateTransitionTable_MCAN[];
extern const TStateTransitions aFsmStateTransitionTable_VCAN[];

/* now the definitions                                                        */
/* default states for all configured busses                                   */
#ifdef CNM_OSEKI_SELF
const BYTE cnm_oseki_arDefaultBusStates[CNM_OSEKI_ANZAHL_BUSSE] =
{
  /* The VCAN should stay alive from start of ACC until end of ACC incl.      */
  /* during the Nachlauf time intervall                                       */
  /* 03.05.2011: Nissan wants to have VCAN TX enabled by following the IGN    */
  /* state, so default is LISTEN now, waiting for communication request by SPM*/
  CSM_C_STATE_BUS_LISTEN,            /* default state for Bus 0               */

  /* The MCAN should stay DOWN until a communication request is given         */
  /* by application. This ensures that it goes back DOWN if channels are      */
  /* closed due to vanishing ACC signal. Nachlauf doesnt matter then          */
  CSM_C_STATE_BUS_LISTEN             /* default state for Bus 1               */
};
#endif

/* Configuration data for the TX node monitoring VCAN                         */
#ifdef CNM_OSEKI_SELF
const CNM_OSEKI_tTxMutePatchData  CNM_OSEKI_arTxMutePatchData_VCAN[CSM_APL_MAX_CONFIG_SLOTS][CBR_TX_ABSOLUT_MAX_NUMBER] =
{
  // SLOT 0
  {
    {  3,  110,  20, 0x03C7},  // index  0
/*    {  3,  110,  20, 0x0550},  // index  1
    {  3,  999,   4, 0x0000},  // index  2, is a dummy entry to match array size
    {  3,  999,   4, 0x0000},  // index  3, is a dummy entry to match array size
    {  3,  999,   4, 0x0000},  // index  4, is a dummy entry to match array size*/
    },
  };

#endif

/* Configuration data for the RX node monitoring VCAN                         */
#ifdef CNM_OSEKI_SELF
// SLOT0
const CNM_OSEKI_tRxNodeData CNM_OSEKI_arRxNodeData_VCAN_SLOT0[CNM_OSEKI_NR_OF_RX_NODE_MONITORS_VCAN] =
{
  /* N (JT1/CycleTime), CycleTime, M (JT2/CycleTime), CAN ID                  */
  /* attention: the cycle times used here may not match the required ones     */
  /* from the database, but task scheduling time and timer resolution require */
  /* a tolerance here, otherwise the mechanism will not work properly         */
  {   0, 100,   0, 0x000},  // AVM    unused
};
// SLOT1
const CNM_OSEKI_tRxNodeData CNM_OSEKI_arRxNodeData_VCAN_SLOT1[CNM_OSEKI_NR_OF_RX_NODE_MONITORS_VCAN] =
{
  /* N (JT1/CycleTime), CycleTime, M (JT2/CycleTime), CAN ID                  */
  /* attention: the cycle times used here may not match the required ones     */
  /* from the database, but task scheduling time and timer resolution require */
  /* a tolerance here, otherwise the mechanism will not work properly         */
  {   0, 100,   0, 0x000},  // AVM    unused

};
// SLOT3
const CNM_OSEKI_tRxNodeData CNM_OSEKI_arRxNodeData_VCAN_SLOT3[CNM_OSEKI_NR_OF_RX_NODE_MONITORS_VCAN] =
{
  /* N (JT1/CycleTime), CycleTime, M (JT2/CycleTime), CAN ID                  */
  /* attention: the cycle times used here may not match the required ones     */
  /* from the database, but task scheduling time and timer resolution require */
  /* a tolerance here, otherwise the mechanism will not work properly         */
  {   0, 100,   0, 0x000},  // AVM    unused
};
// SLOT5
const CNM_OSEKI_tRxNodeData CNM_OSEKI_arRxNodeData_VCAN_SLOT5[CNM_OSEKI_NR_OF_RX_NODE_MONITORS_VCAN] =
{
  /* N (JT1/CycleTime), CycleTime, M (JT2/CycleTime), CAN ID                  */
  /* attention: the cycle times used here may not match the required ones     */
  /* from the database, but task scheduling time and timer resolution require */
  /* a tolerance here, otherwise the mechanism will not work properly         */
  {   3, 550,   4, 0x5C2},  // AVM
};
// SLOT6
const CNM_OSEKI_tRxNodeData CNM_OSEKI_arRxNodeData_VCAN_SLOT6[CNM_OSEKI_NR_OF_RX_NODE_MONITORS_VCAN] =
{
  /* N (JT1/CycleTime), CycleTime, M (JT2/CycleTime), CAN ID                  */
  /* attention: the cycle times used here may not match the required ones     */
  /* from the database, but task scheduling time and timer resolution require */
  /* a tolerance here, otherwise the mechanism will not work properly         */
  {   3, 550,   4, 0x5C2},  // AVM

};
// SLOT7
const CNM_OSEKI_tRxNodeData CNM_OSEKI_arRxNodeData_VCAN_SLOT7[CNM_OSEKI_NR_OF_RX_NODE_MONITORS_VCAN] =
{
  /* N (JT1/CycleTime), CycleTime, M (JT2/CycleTime), CAN ID                  */
  /* attention: the cycle times used here may not match the required ones     */
  /* from the database, but task scheduling time and timer resolution require */
  /* a tolerance here, otherwise the mechanism will not work properly         */
  {   0, 100,   0, 0x000},  // AVM    unused

};
// Dummy for unconfigured SLOTS
const CNM_OSEKI_tRxNodeData CNM_OSEKI_arRxNodeData_VCAN[CNM_OSEKI_NR_OF_RX_NODE_MONITORS_VCAN] =
{
  /* N (JT1/CycleTime), CycleTime, M (JT2/CycleTime), CAN ID                  */
  /* attention: the cycle times used here may not match the required ones     */
  /* from the database, but task scheduling time and timer resolution require */
  /* a tolerance here, otherwise the mechanism will not work properly         */
  { 3, 550, 4, 0x0000},  // AVM

};
#endif

/* Configuration data for the TX node monitoring VCAN                         */
#ifdef CNM_OSEKI_SELF
// this config is in RAM !!!
CNM_OSEKI_tTxMuteData CNM_OSEKI_arTxMuteData_VCAN[CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_VCAN] =
{
  /* N (JT1/CycleTime), CycleTime, M (JT2/CycleTime), CAN ID                  */
  { 0,   0, 0, 0x1234},  // the ID must NOT be 0x0000 here, otherwise some operations will fail !!!
};
#endif

/* Configuration data for the BusOff monitoring VCAN                          */
#ifdef CNM_OSEKI_SELF
const CNM_OSEKI_tBusOffData CNM_OSEKI_BusOffData_VCAN =
{
  /* N (JT1/CycleTime), CycleTime, M (JT2/CycleTime)                          */
  1, 100, 20
};
#endif

/* Configuration data for the TX node monitoring MCAN                         */
#ifdef CNM_OSEKI_SELF
// this config is in ROM !!!
const CNM_OSEKI_tTxMuteData CNM_OSEKI_arTxMuteData_MCAN[CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_MCAN] =
{
  /* N (JT1/CycleTime), CycleTime, M (JT2/CycleTime), CAN ID                  */
  { 3, 550, 4, 0x0603},  // SWC

};
#endif

/* Configuration data for the BusOff monitoring MCAN                          */
#ifdef CNM_OSEKI_SELF
const CNM_OSEKI_tBusOffData CNM_OSEKI_BusOffData_MCAN =
{
  /* N (JT1/CycleTime), CycleTime, M (JT2/CycleTime)                          */
  1, 100, 20
};
#endif

/* NM modes assigned to NM states, since the FSM needs sequential values      */
#ifdef CNM_OSEKI_SELF
const int CNM_OSEKI_arNmModes[eState_NM_Max] =
{
  CNM_OSEKI_C_NMOff,
  CNM_OSEKI_C_NMOn,
  CNM_OSEKI_C_NMNormal,
  CNM_OSEKI_C_NMLimpHome
};
#endif

/* Bus configuration for network management                                   */
#ifdef CNM_OSEKI_SELF
// pointer to array of bus configuration, assigned at runtime
const CNM_OSEKI_tBusConfig * CNM_OSEKI_arBusConfig;

// different configurations
// SLOT 0 - the default slot: NO TX monitor - NO RX Monitor
const CNM_OSEKI_tBusConfig CNM_OSEKI_arBusConfig_Slot0[CNM_OSEKI_ANZAHL_BUSSE] =
{
  // Bus 0
  {
    CSM_C_CAN_BUS_VCAN,                         /* Bus 0 ID                   */
    NULL,                                       /* pointer to RX states       */
    NULL,                                       /* pointer to TX states       */
    & CNM_OSEKI_BusOffStates_VCAN,              /* pointer to BusOffStates    */
    NULL,                                       /* pointer to RX Node Data    */
    NULL,                                       /* pointer to TX Node Data    */
    & CNM_OSEKI_BusOffData_VCAN,                /* pointer to BusOffData      */
    CNM_OSEKI_NR_OF_RX_NODE_MONITORS_VCAN,      /* amount of RX monitors      */
    CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_VCAN,      /* amount of TX monitors      */
    CNM_OSEKI_C_TIME_BUSOFF_REINIT_VCAN         /* timeout for BusOff ReInit  */
  },

  // Bus 1
  {
    CSM_C_CAN_BUS_MCAN,                         /* Bus 1 ID                   */
    NULL,                                       /* pointer to RX states       */
    NULL,                                       /* pointer to TX states       */
    & CNM_OSEKI_BusOffStates_MCAN,              /* pointer to BusOff states   */
    NULL,                                       /* pointer to RX Node Data    */
    NULL,                                       /* pointer to TX Node Data    */
    & CNM_OSEKI_BusOffData_MCAN,                /* pointer to BusOff Data     */
    CNM_OSEKI_NR_OF_RX_NODE_MONITORS_MCAN,      /* amount of RX monitors      */
    CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_MCAN,      /* amount of TX monitors      */
    CNM_OSEKI_C_TIME_BUSOFF_REINIT_MCAN         /* timeout for BusOff ReInit  */
  },
};

// SLOT 1
const CNM_OSEKI_tBusConfig CNM_OSEKI_arBusConfig_Slot1[CNM_OSEKI_ANZAHL_BUSSE] =
{
  // Bus 0 = VCAN
  {
    CSM_C_CAN_BUS_VCAN,                         /* Bus 0 ID                   */
    CNM_OSEKI_arRxStatesBus_VCAN,               /* pointer to RX states       */
    CNM_OSEKI_arTxStatesBus_VCAN,               /* pointer to TX states       */
    & CNM_OSEKI_BusOffStates_VCAN,              /* pointer to BusOffStates    */
    CNM_OSEKI_arRxNodeData_VCAN,                /* pointer to RX Node Data    */
    CNM_OSEKI_arTxMuteData_VCAN,                /* pointer to TX Node Data    */
    & CNM_OSEKI_BusOffData_VCAN,                /* pointer to BusOffData      */
    CNM_OSEKI_NR_OF_RX_NODE_MONITORS_VCAN,      /* amount of RX monitors      */
    CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_VCAN,      /* amount of TX monitors      */
    CNM_OSEKI_C_TIME_BUSOFF_REINIT_VCAN         /* timeout for BusOff ReInit  */
  },

  // Bus 1 = MCAN
  {
    CSM_C_CAN_BUS_MCAN,                         /* Bus 1 ID                   */
    NULL,                                       /* pointer to RX states       */
    CNM_OSEKI_arTxStatesBus_MCAN,               /* pointer to TX states       */
    & CNM_OSEKI_BusOffStates_MCAN,              /* pointer to BusOff states   */
    NULL,                                       /* pointer to RX Node Data    */
    (CNM_OSEKI_tTxMuteData *) CNM_OSEKI_arTxMuteData_MCAN, /* pointer to TX Node Data, CONST casted away */
    & CNM_OSEKI_BusOffData_MCAN,                /* pointer to BusOff Data     */
    CNM_OSEKI_NR_OF_RX_NODE_MONITORS_MCAN,      /* amount of RX monitors      */
    CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_MCAN,      /* amount of TX monitors      */
    CNM_OSEKI_C_TIME_BUSOFF_REINIT_MCAN         /* timeout for BusOff ReInit  */
  },
};

// SLOT 2
const CNM_OSEKI_tBusConfig CNM_OSEKI_arBusConfig_Slot2[CNM_OSEKI_ANZAHL_BUSSE] =
{
  // Bus 0 = VCAN
  {
    CSM_C_CAN_BUS_VCAN,                         /* Bus 0 ID                   */
    CNM_OSEKI_arRxStatesBus_VCAN,               /* pointer to RX states       */
    CNM_OSEKI_arTxStatesBus_VCAN,               /* pointer to TX states       */
    & CNM_OSEKI_BusOffStates_VCAN,              /* pointer to BusOffStates    */
    CNM_OSEKI_arRxNodeData_VCAN,                /* pointer to RX Node Data    */
    CNM_OSEKI_arTxMuteData_VCAN,                /* pointer to TX Node Data    */
    & CNM_OSEKI_BusOffData_VCAN,                /* pointer to BusOffData      */
    CNM_OSEKI_NR_OF_RX_NODE_MONITORS_VCAN,      /* amount of RX monitors      */
    CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_VCAN,      /* amount of TX monitors      */
    CNM_OSEKI_C_TIME_BUSOFF_REINIT_VCAN         /* timeout for BusOff ReInit  */
  },

  // Bus 1 = MCAN
  {
    CSM_C_CAN_BUS_MCAN,                         /* Bus 1 ID                   */
    NULL,                                       /* pointer to RX states       */
    CNM_OSEKI_arTxStatesBus_MCAN,               /* pointer to TX states       */
    & CNM_OSEKI_BusOffStates_MCAN,              /* pointer to BusOff states   */
    NULL,                                       /* pointer to RX Node Data    */
    (CNM_OSEKI_tTxMuteData *) CNM_OSEKI_arTxMuteData_MCAN, /* pointer to TX Node Data, CONST casted away */
    & CNM_OSEKI_BusOffData_MCAN,                /* pointer to BusOff Data     */
    CNM_OSEKI_NR_OF_RX_NODE_MONITORS_MCAN,      /* amount of RX monitors      */
    CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_MCAN,      /* amount of TX monitors      */
    CNM_OSEKI_C_TIME_BUSOFF_REINIT_MCAN         /* timeout for BusOff ReInit  */
  },
};

// SLOT 3
const CNM_OSEKI_tBusConfig CNM_OSEKI_arBusConfig_Slot3[CNM_OSEKI_ANZAHL_BUSSE] =
{
  // Bus 0 = VCAN
  {
    CSM_C_CAN_BUS_VCAN,                         /* Bus 0 ID                   */
    CNM_OSEKI_arRxStatesBus_VCAN,               /* pointer to RX states       */
    CNM_OSEKI_arTxStatesBus_VCAN,               /* pointer to TX states       */
    & CNM_OSEKI_BusOffStates_VCAN,              /* pointer to BusOffStates    */
    CNM_OSEKI_arRxNodeData_VCAN,                /* pointer to RX Node Data    */
    CNM_OSEKI_arTxMuteData_VCAN,                /* pointer to TX Node Data    */
    & CNM_OSEKI_BusOffData_VCAN,                /* pointer to BusOffData      */
    CNM_OSEKI_NR_OF_RX_NODE_MONITORS_VCAN,      /* amount of RX monitors      */
    CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_VCAN,      /* amount of TX monitors      */
    CNM_OSEKI_C_TIME_BUSOFF_REINIT_VCAN         /* timeout for BusOff ReInit  */
  },

  // Bus 1 = MCAN
  {
    CSM_C_CAN_BUS_MCAN,                         /* Bus 1 ID                   */
    NULL,                                       /* pointer to RX states       */
    CNM_OSEKI_arTxStatesBus_MCAN,               /* pointer to TX states       */
    & CNM_OSEKI_BusOffStates_MCAN,              /* pointer to BusOff states   */
    NULL,                                       /* pointer to RX Node Data    */
    (CNM_OSEKI_tTxMuteData *) CNM_OSEKI_arTxMuteData_MCAN, /* pointer to TX Node Data, CONST casted away */
    & CNM_OSEKI_BusOffData_MCAN,                /* pointer to BusOff Data     */
    CNM_OSEKI_NR_OF_RX_NODE_MONITORS_MCAN,      /* amount of RX monitors      */
    CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_MCAN,      /* amount of TX monitors      */
    CNM_OSEKI_C_TIME_BUSOFF_REINIT_MCAN         /* timeout for BusOff ReInit  */
  },
};

// SLOT 4
const CNM_OSEKI_tBusConfig CNM_OSEKI_arBusConfig_Slot4[CNM_OSEKI_ANZAHL_BUSSE] =
{
  // Bus 0 = VCAN
  {
    CSM_C_CAN_BUS_VCAN,                         /* Bus 0 ID                   */
    CNM_OSEKI_arRxStatesBus_VCAN,               /* pointer to RX states       */
    CNM_OSEKI_arTxStatesBus_VCAN,               /* pointer to TX states       */
    & CNM_OSEKI_BusOffStates_VCAN,              /* pointer to BusOffStates    */
    CNM_OSEKI_arRxNodeData_VCAN,                /* pointer to RX Node Data    */
    CNM_OSEKI_arTxMuteData_VCAN,                /* pointer to TX Node Data    */
    & CNM_OSEKI_BusOffData_VCAN,                /* pointer to BusOffData      */
    CNM_OSEKI_NR_OF_RX_NODE_MONITORS_VCAN,      /* amount of RX monitors      */
    CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_VCAN,      /* amount of TX monitors      */
    CNM_OSEKI_C_TIME_BUSOFF_REINIT_VCAN         /* timeout for BusOff ReInit  */
  },

  // Bus 1 = MCAN
  {
    CSM_C_CAN_BUS_MCAN,                         /* Bus 1 ID                   */
    NULL,                                       /* pointer to RX states       */
    CNM_OSEKI_arTxStatesBus_MCAN,               /* pointer to TX states       */
    & CNM_OSEKI_BusOffStates_MCAN,              /* pointer to BusOff states   */
    NULL,                                       /* pointer to RX Node Data    */
    (CNM_OSEKI_tTxMuteData *) CNM_OSEKI_arTxMuteData_MCAN, /* pointer to TX Node Data, CONST casted away */
    & CNM_OSEKI_BusOffData_MCAN,                /* pointer to BusOff Data     */
    CNM_OSEKI_NR_OF_RX_NODE_MONITORS_MCAN,      /* amount of RX monitors      */
    CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_MCAN,      /* amount of TX monitors      */
    CNM_OSEKI_C_TIME_BUSOFF_REINIT_MCAN         /* timeout for BusOff ReInit  */
  },
};

// SLOT 5
const CNM_OSEKI_tBusConfig CNM_OSEKI_arBusConfig_Slot5[CNM_OSEKI_ANZAHL_BUSSE] =
{
  // Bus 0 = VCAN
  {
    CSM_C_CAN_BUS_VCAN,                         /* Bus 0 ID                   */
    CNM_OSEKI_arRxStatesBus_VCAN,               /* pointer to RX states       */
    CNM_OSEKI_arTxStatesBus_VCAN,               /* pointer to TX states       */
    & CNM_OSEKI_BusOffStates_VCAN,              /* pointer to BusOffStates    */
    CNM_OSEKI_arRxNodeData_VCAN_SLOT5,          /* pointer to RX Node Data    */
    CNM_OSEKI_arTxMuteData_VCAN,                /* pointer to TX Node Data    */
    & CNM_OSEKI_BusOffData_VCAN,                /* pointer to BusOffData      */
    CNM_OSEKI_NR_OF_RX_NODE_MONITORS_VCAN,      /* amount of RX monitors      */
    CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_VCAN,      /* amount of TX monitors      */
    CNM_OSEKI_C_TIME_BUSOFF_REINIT_VCAN         /* timeout for BusOff ReInit  */
  },

  // Bus 1 = MCAN
  {
    CSM_C_CAN_BUS_MCAN,                         /* Bus 1 ID                   */
    NULL,                                       /* pointer to RX states       */
    CNM_OSEKI_arTxStatesBus_MCAN,               /* pointer to TX states       */
    & CNM_OSEKI_BusOffStates_MCAN,              /* pointer to BusOff states   */
    NULL,                                       /* pointer to RX Node Data    */
    (CNM_OSEKI_tTxMuteData *) CNM_OSEKI_arTxMuteData_MCAN, /* pointer to TX Node Data, CONST casted away */
    & CNM_OSEKI_BusOffData_MCAN,                /* pointer to BusOff Data     */
    CNM_OSEKI_NR_OF_RX_NODE_MONITORS_MCAN,      /* amount of RX monitors      */
    CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_MCAN,      /* amount of TX monitors      */
    CNM_OSEKI_C_TIME_BUSOFF_REINIT_MCAN         /* timeout for BusOff ReInit  */
  },
};

// SLOT 6
const CNM_OSEKI_tBusConfig CNM_OSEKI_arBusConfig_Slot6[CNM_OSEKI_ANZAHL_BUSSE] =
{
  // Bus 0 = VCAN
  {
    CSM_C_CAN_BUS_VCAN,                         /* Bus 0 ID                   */
    CNM_OSEKI_arRxStatesBus_VCAN,               /* pointer to RX states       */
    CNM_OSEKI_arTxStatesBus_VCAN,               /* pointer to TX states       */
    & CNM_OSEKI_BusOffStates_VCAN,              /* pointer to BusOffStates    */
    CNM_OSEKI_arRxNodeData_VCAN_SLOT6,          /* pointer to RX Node Data    */
    CNM_OSEKI_arTxMuteData_VCAN,                /* pointer to TX Node Data    */
    & CNM_OSEKI_BusOffData_VCAN,                /* pointer to BusOffData      */
    CNM_OSEKI_NR_OF_RX_NODE_MONITORS_VCAN,      /* amount of RX monitors      */
    CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_VCAN,      /* amount of TX monitors      */
    CNM_OSEKI_C_TIME_BUSOFF_REINIT_VCAN         /* timeout for BusOff ReInit  */
  },

  // Bus 1 = MCAN
  {
    CSM_C_CAN_BUS_MCAN,                         /* Bus 1 ID                   */
    NULL,                                       /* pointer to RX states       */
    CNM_OSEKI_arTxStatesBus_MCAN,               /* pointer to TX states       */
    & CNM_OSEKI_BusOffStates_MCAN,              /* pointer to BusOff states   */
    NULL,                                       /* pointer to RX Node Data    */
    (CNM_OSEKI_tTxMuteData *) CNM_OSEKI_arTxMuteData_MCAN, /* pointer to TX Node Data, CONST casted away */
    & CNM_OSEKI_BusOffData_MCAN,                /* pointer to BusOff Data     */
    CNM_OSEKI_NR_OF_RX_NODE_MONITORS_MCAN,      /* amount of RX monitors      */
    CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_MCAN,      /* amount of TX monitors      */
    CNM_OSEKI_C_TIME_BUSOFF_REINIT_MCAN         /* timeout for BusOff ReInit  */
  },
};

// SLOT 7
const CNM_OSEKI_tBusConfig CNM_OSEKI_arBusConfig_Slot7[CNM_OSEKI_ANZAHL_BUSSE] =
{
  // Bus 0 = VCAN
  {
    CSM_C_CAN_BUS_VCAN,                         /* Bus 0 ID                   */
    CNM_OSEKI_arRxStatesBus_VCAN,               /* pointer to RX states       */
    CNM_OSEKI_arTxStatesBus_VCAN,               /* pointer to TX states       */
    & CNM_OSEKI_BusOffStates_VCAN,              /* pointer to BusOffStates    */
    CNM_OSEKI_arRxNodeData_VCAN,                /* pointer to RX Node Data    */
    CNM_OSEKI_arTxMuteData_VCAN,                /* pointer to TX Node Data    */
    & CNM_OSEKI_BusOffData_VCAN,                /* pointer to BusOffData      */
    CNM_OSEKI_NR_OF_RX_NODE_MONITORS_VCAN,      /* amount of RX monitors      */
    CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_VCAN,      /* amount of TX monitors      */
    CNM_OSEKI_C_TIME_BUSOFF_REINIT_VCAN         /* timeout for BusOff ReInit  */
  },

  // Bus 1 = MCAN
  {
    CSM_C_CAN_BUS_MCAN,                         /* Bus 1 ID                   */
    NULL,                                       /* pointer to RX states       */
    CNM_OSEKI_arTxStatesBus_MCAN,               /* pointer to TX states       */
    & CNM_OSEKI_BusOffStates_MCAN,              /* pointer to BusOff states   */
    NULL,                                       /* pointer to RX Node Data    */
    (CNM_OSEKI_tTxMuteData *) CNM_OSEKI_arTxMuteData_MCAN, /* pointer to TX Node Data, CONST casted away */
    & CNM_OSEKI_BusOffData_MCAN,                /* pointer to BusOff Data     */
    CNM_OSEKI_NR_OF_RX_NODE_MONITORS_MCAN,      /* amount of RX monitors      */
    CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_MCAN,      /* amount of TX monitors      */
    CNM_OSEKI_C_TIME_BUSOFF_REINIT_MCAN         /* timeout for BusOff ReInit  */
  },
};

// SLOT 8
const CNM_OSEKI_tBusConfig CNM_OSEKI_arBusConfig_Slot8[CNM_OSEKI_ANZAHL_BUSSE] =
{
  // Bus 0 = VCAN
  {
    CSM_C_CAN_BUS_VCAN,                         /* Bus 0 ID                   */
    CNM_OSEKI_arRxStatesBus_VCAN,               /* pointer to RX states       */
    CNM_OSEKI_arTxStatesBus_VCAN,               /* pointer to TX states       */
    & CNM_OSEKI_BusOffStates_VCAN,              /* pointer to BusOffStates    */
    CNM_OSEKI_arRxNodeData_VCAN,                /* pointer to RX Node Data    */
    CNM_OSEKI_arTxMuteData_VCAN,                /* pointer to TX Node Data    */
    & CNM_OSEKI_BusOffData_VCAN,                /* pointer to BusOffData      */
    CNM_OSEKI_NR_OF_RX_NODE_MONITORS_VCAN,      /* amount of RX monitors      */
    CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_VCAN,      /* amount of TX monitors      */
    CNM_OSEKI_C_TIME_BUSOFF_REINIT_VCAN         /* timeout for BusOff ReInit  */
  },

  // Bus 1 = MCAN
  {
    CSM_C_CAN_BUS_MCAN,                         /* Bus 1 ID                   */
    NULL,                                       /* pointer to RX states       */
    CNM_OSEKI_arTxStatesBus_MCAN,               /* pointer to TX states       */
    & CNM_OSEKI_BusOffStates_MCAN,              /* pointer to BusOff states   */
    NULL,                                       /* pointer to RX Node Data    */
    (CNM_OSEKI_tTxMuteData *) CNM_OSEKI_arTxMuteData_MCAN, /* pointer to TX Node Data, CONST casted away */
    & CNM_OSEKI_BusOffData_MCAN,                /* pointer to BusOff Data     */
    CNM_OSEKI_NR_OF_RX_NODE_MONITORS_MCAN,      /* amount of RX monitors      */
    CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_MCAN,      /* amount of TX monitors      */
    CNM_OSEKI_C_TIME_BUSOFF_REINIT_MCAN         /* timeout for BusOff ReInit  */
  },
};

// SLOT 9
const CNM_OSEKI_tBusConfig CNM_OSEKI_arBusConfig_Slot9[CNM_OSEKI_ANZAHL_BUSSE] =
{
  // Bus 0 = VCAN
  {
    CSM_C_CAN_BUS_VCAN,                         /* Bus 0 ID                   */
    CNM_OSEKI_arRxStatesBus_VCAN,               /* pointer to RX states       */
    CNM_OSEKI_arTxStatesBus_VCAN,               /* pointer to TX states       */
    & CNM_OSEKI_BusOffStates_VCAN,              /* pointer to BusOffStates    */
    CNM_OSEKI_arRxNodeData_VCAN,                /* pointer to RX Node Data    */
    CNM_OSEKI_arTxMuteData_VCAN,                /* pointer to TX Node Data    */
    & CNM_OSEKI_BusOffData_VCAN,                /* pointer to BusOffData      */
    CNM_OSEKI_NR_OF_RX_NODE_MONITORS_VCAN,      /* amount of RX monitors      */
    CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_VCAN,      /* amount of TX monitors      */
    CNM_OSEKI_C_TIME_BUSOFF_REINIT_VCAN         /* timeout for BusOff ReInit  */
  },

  // Bus 1 = MCAN
  {
    CSM_C_CAN_BUS_MCAN,                         /* Bus 1 ID                   */
    NULL,                                       /* pointer to RX states       */
    CNM_OSEKI_arTxStatesBus_MCAN,               /* pointer to TX states       */
    & CNM_OSEKI_BusOffStates_MCAN,              /* pointer to BusOff states   */
    NULL,                                       /* pointer to RX Node Data    */
    (CNM_OSEKI_tTxMuteData *) CNM_OSEKI_arTxMuteData_MCAN, /* pointer to TX Node Data, CONST casted away */
    & CNM_OSEKI_BusOffData_MCAN,                /* pointer to BusOff Data     */
    CNM_OSEKI_NR_OF_RX_NODE_MONITORS_MCAN,      /* amount of RX monitors      */
    CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_MCAN,      /* amount of TX monitors      */
    CNM_OSEKI_C_TIME_BUSOFF_REINIT_MCAN         /* timeout for BusOff ReInit  */
  },
};
#endif

#ifdef CNM_OSEKI_SELF      // map the following definitions into cnm_oseki.c
// currently we should have 28 entries (refer to macro calculation further up)
tCSM_NWM_CFG csm_arNWMCfg[CSM_NWM_C_MAX_USER] =
{
  /*-------------------------------------------------------------------------*/
  /* CAN CommunicationIndication for CSM_C_PTYPE_DC_OSEKI_NWM                */
  /*-------------------------------------------------------------------------*/
  /* since it may occur that several error detections are pending at the same */
  /* time, it is important to handle the bus off errors first                 */
  /* this is ensured by placing them here on top of the array                 */

  //--------------------------------------------------------------------------
  // 0 - Bus Off VCAN --------------------------------------------------------
  {
    CSM_C_CAN_BUS_VCAN,                       // BYTE bBus
    CSM_C_PTYPE_DC_OSEKI_NWM,                 // DWORD dwProtocolType
    {                                         // BYTE au8AddressField[2]
      CSM_C_ADR_FLD_DC_NM_BUSOFF_INDICATOR,
      0xFF
    },
    CSM_C_APPL_ID_VCAN_LOCAL_CTRL_SPM,     // WORD wApplId
    0x00,                                     // index 0, since only 1 state for this specific bus
  },
  //-------------------------------------------------------------------------
  // 1 - Bus Off MCAN -------------------------------------------------------
  {
    CSM_C_CAN_BUS_MCAN,                       // BYTE bBus
    CSM_C_PTYPE_DC_OSEKI_NWM,                 // DWORD dwProtocolType
    {                                         // BYTE au8AddressField[2]
      CSM_C_ADR_FLD_DC_NM_BUSOFF_INDICATOR,
      0xFF
    },
    CSM_C_APPL_ID_MCAN_LOCAL_CTRL_SPM,     // WORD wApplId
    0x00,                                     // index 0, since only 1 state for this specifc bus
  },
  //-------------------------------------------------------------------------
  // 2 - Rx AVM -------------------------------------------------------------
  {
    CSM_C_CAN_BUS_VCAN,                       // BYTE bBus
    CSM_C_PTYPE_DC_OSEKI_NWM,                 // DWORD dwProtocolType
    {                                         // BYTE au8AddressField[2]
      CSM_C_ADR_FLD_DC_NM_RX_INDICATOR,
      CSM_C_ADR_FLD_RN_NM_AVM
    },
    CSM_C_APPL_ID_VCAN_LOCAL_CTRL_SPM,     // WORD wApplId
    0x00,                                     // index in RX monitor array
  },
  // 3 - Rx BCM -------------------------------------------------------------
  {
    CSM_C_CAN_BUS_VCAN,                       // BYTE bBus
    CSM_C_PTYPE_DC_OSEKI_NWM,                 // DWORD dwProtocolType
    {                                         // BYTE au8AddressField[2]
      CSM_C_ADR_FLD_DC_NM_RX_INDICATOR,
      CSM_C_ADR_FLD_RN_NM_BCM
    },
    CSM_C_APPL_ID_VCAN_LOCAL_CTRL_SPM,     // WORD wApplId
    0x01,                                     // index in RX monitor array
  },
  // 4 - Rx ECM -------------------------------------------------------------
  {
    CSM_C_CAN_BUS_VCAN,                       // BYTE bBus
    CSM_C_PTYPE_DC_OSEKI_NWM,                 // DWORD dwProtocolType
    {                                         // BYTE au8AddressField[2]
      CSM_C_ADR_FLD_DC_NM_RX_INDICATOR,
      CSM_C_ADR_FLD_RN_NM_ECM
    },
    CSM_C_APPL_ID_VCAN_LOCAL_CTRL_SPM,     // WORD wApplId
    0x02,                                     // index in RX monitor array
  },
  // 5 - Rx USM -------------------------------------------------------------
  {
    CSM_C_CAN_BUS_VCAN,                       // BYTE bBus
    CSM_C_PTYPE_DC_OSEKI_NWM,                 // DWORD dwProtocolType
    {                                         // BYTE au8AddressField[2]
      CSM_C_ADR_FLD_DC_NM_RX_INDICATOR,
      CSM_C_ADR_FLD_RN_NM_USM
    },
    CSM_C_APPL_ID_VCAN_LOCAL_CTRL_SPM,     // WORD wApplId
    0x03,                                     // index in RX monitor array
  },
  // 6 - Rx METER -------------------------------------------------------------
  {
    CSM_C_CAN_BUS_VCAN,                       // BYTE bBus
    CSM_C_PTYPE_DC_OSEKI_NWM,                 // DWORD dwProtocolType
    {                                         // BYTE au8AddressField[2]
      CSM_C_ADR_FLD_DC_NM_RX_INDICATOR,
      CSM_C_ADR_FLD_RN_NM_METER
    },
    CSM_C_APPL_ID_VCAN_LOCAL_CTRL_SPM,     // WORD wApplId
    0x04,                                     // index in RX monitor array
  },
  // 7 - Rx STRG -------------------------------------------------------------
  {
    CSM_C_CAN_BUS_VCAN,                       // BYTE bBus
    CSM_C_PTYPE_DC_OSEKI_NWM,                 // DWORD dwProtocolType
    {                                         // BYTE au8AddressField[2]
      CSM_C_ADR_FLD_DC_NM_RX_INDICATOR,
      CSM_C_ADR_FLD_RN_NM_STRG
    },
    CSM_C_APPL_ID_VCAN_LOCAL_CTRL_SPM,     // WORD wApplId
    0x05,                                     // index in RX monitor array
  },
  // 8 - Rx SONAR -------------------------------------------------------------
  {
    CSM_C_CAN_BUS_VCAN,                       // BYTE bBus
    CSM_C_PTYPE_DC_OSEKI_NWM,                 // DWORD dwProtocolType
    {                                         // BYTE au8AddressField[2]
      CSM_C_ADR_FLD_DC_NM_RX_INDICATOR,
      CSM_C_ADR_FLD_RN_NM_SONAR
    },
    CSM_C_APPL_ID_VCAN_LOCAL_CTRL_SPM,     // WORD wApplId
    0x06,                                     // index in RX monitor array
  },
  // 9 - Rx HCM -------------------------------------------------------------
  {
    CSM_C_CAN_BUS_VCAN,                       // BYTE bBus
    CSM_C_PTYPE_DC_OSEKI_NWM,                 // DWORD dwProtocolType
    {                                         // BYTE au8AddressField[2]
      CSM_C_ADR_FLD_DC_NM_RX_INDICATOR,
      CSM_C_ADR_FLD_RN_NM_HCM
    },
    CSM_C_APPL_ID_VCAN_LOCAL_CTRL_SPM,     // WORD wApplId
    0x07,                                     // index in RX monitor array
  },
  // 10 - Rx SBW -------------------------------------------------------------
  {
    CSM_C_CAN_BUS_VCAN,                       // BYTE bBus
    CSM_C_PTYPE_DC_OSEKI_NWM,                 // DWORD dwProtocolType
    {                                         // BYTE au8AddressField[2]
      CSM_C_ADR_FLD_DC_NM_RX_INDICATOR,
      CSM_C_ADR_FLD_RN_NM_SBW
    },
    CSM_C_APPL_ID_VCAN_LOCAL_CTRL_SPM,     // WORD wApplId
    0x08,                                     // index in RX monitor array
  },
                                              // index (for bus VCAN) in User Array "CommunicationState"
};
#endif // CNM_OSEKI_SELF



// ##################################################
// _CSM_SECTION_HISTORY: user specific code start
// ##################################################
/*******************************************************************************
 * \doxydocu
 * \file          cnm_oseki_mp.h
 * \brief         OSEK Network Management. Project specific part of the modul
 *                internal interface header pair.
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/modules_swa/cnm/src/
 *
 * \ingroup       CNM
 * \ingroup       CNM_OSEK
 *
 * \authors       Borck
 *
 * COPYRIGHT      (c) 2009 Bosch Car Multimedia GmbH
 *                (c) 2015 Bosch Car Multimedia GmbH
 *
 * \history_begin
 *
 * 13.01.17  main\rn_aivi_proxy\2      A.Borck
 * - new code generation due to new database, for RIVIE/RNAIVI 2.1
 *
 * \history_end
 **** END OF FILE *************************************************************/
// ##################################################
// _CSM_SECTION_HISTORY: user specific code end
// ##################################################
