/* Description and history of cnm_oseki_m.h at the end of the file.           */
#ifndef CNM_OSEKI_M_HEADER
/** File name for preprozessor commands */
#define CNM_OSEKI_M_HEADER
/* Usually no includes except cnm_oseki_mp.h (below in this file) necessary.  */

/*******************************************************************************
 * defines and macros (scope: modul-local)
 ******************************************************************************/
#define CNM_OSEKI_C_TIMER_REASON_UNDEF              0x00  /**< Possible value for CNM_OSEKI_arState[bBus].bBusStateTimeoutReason */
#define CNM_OSEKI_C_TIMER_REASON_LISTEN_TIMEOUT     0x01  /**< Possible value for CNM_OSEKI_arState[bBus].bBusStateTimeoutReason */
#define CNM_OSEKI_C_TIMER_REASON_SHUTDOWN_TIMEOUT   0x02  /**< Possible value for CNM_OSEKI_arState[bBus].bBusStateTimeoutReason */


#define FSM_U32_TRANSITION_ID_INVALID  0xFFFFFFFF
#define FSM_DONT_CARE                  0xFFFFFFFF

enum
{
  FSM_EXIT_FUNC     = 1,
  FSM_ENTRY_FUNC    = 2,
  FSM_REACHED_FUNC  = 3
};

/*******************************************************************************
 * typedefs (scope: modul-local)
 ******************************************************************************/
typedef tVoid (*tFsmStateEntryFuncPtr)();           
typedef tVoid (*tFsmStateReachedFuncPtr)();
typedef tVoid (*tFsmStateExitFuncPtr)();
typedef tVoid (*tFsmStateFuncPtr)();                

typedef struct
{
  DWORD u32FsmState;
  DWORD u32Timeout;
  tFsmStateEntryFuncPtr   pfnvStateEntry;           // bei der Instanziierung ist der Name der Funktion auch ihr Pointer
  tFsmStateReachedFuncPtr pfnvStateReached;
  tFsmStateExitFuncPtr    pfnvStateExit;
}TFsmStateConf;

typedef struct
{
  DWORD u32TransitionId;
  DWORD u32CurrentFsmState;
  DWORD u32UpdateTrigger;
  DWORD u32Trigger;
  DWORD u32TriggerNotSet;
  DWORD u32NextFsmState;
}TStateTransitions;

/* struct for a FSM instance                                                  */
typedef struct
{
  BYTE _bCsmBus;
  DWORD _u32FsmState;
  DWORD _u32LastFsmState;
  DWORD _u32CurrentTrigger;
  DWORD _u32Trigger;
  DWORD _u32CurrentTriggerUpdate;
  DWORD _u32TriggerUpdate;
  DWORD _u32LastTransitionId;
  DWORD _u32MaxStateEntry;
  DWORD _u32MaxTransitionEntry;
  DWORD _u32TimeOut;
  BOOL _fTimeout;
  DWORD _u32TraceClass;

  const TStateTransitions * _paFsmTransitionTable;
  const TFsmStateConf     * _paFsmStateTable;

}CNM_OSEKI_FSM_tFsmInstance;

/* struct for a FSM configuration                                             */
typedef struct
{
  BYTE bCsmBus;
  DWORD u32InitFsmState;
  DWORD u32MaxTransitionEntry;
  const TStateTransitions * paFsmTransitionTable;
  DWORD u32MaxStateEntry;
  const TFsmStateConf     * paFsmStateTable;
  DWORD u32TraceClass;
}CNM_OSEKI_FSM_tFsmConfig;

/* struct for RX monitoring a single node, used as array for several nodes    */
typedef struct
{
  WORD wRxNodeCounter;
  BYTE bRxNodeAbsentState;
  BOOL fRxNodeTimeout;
  BYTE bCascade;
  BYTE bStateChanged;
}CNM_OSEKI_RxMonitorState;

/* struct for TX monitoring a single node, used as array for several nodes    */
typedef struct
{
  WORD wTxMuteCounter;
  BYTE bTxNodeMuteState;
  BOOL fTxMuteTimeout;
  BYTE bCascade;
  BYTE bStateChanged;
}CNM_OSEKI_TxMonitorState;

/* struct for BusOff monitoring, used as array for all configured busses      */
typedef struct
{
  WORD wBusOffCounter;
  BYTE bBusOffState;
  BOOL fBusOffTimeout;
  BYTE bStateChanged;
}CNM_OSEKI_BusOffMonitorState;

/* struct with data for RX message monitoring, used as array for several nodes */
typedef struct
{
  BYTE  bN;                                        /**< counter for IncAbs    */
  WORD  wCycleTime;                                /**< cycle time for Node   */
  WORD  wM;                                        /**< max. counter val      */
  DWORD dwId;                                      /** assigned CAN ID        */
}CNM_OSEKI_tRxNodeData;

/* struct with data for TX message monitoring, used as array for several nodes */
typedef struct
{
  BYTE  bN;                                        /**< counter for IncAbs    */
  WORD  wCycleTime;                                /**< cycle time for Node   */
  WORD  wM;                                        /**< max. counter val      */
  DWORD dwId;                                      /** assigned CAN ID        */
}CNM_OSEKI_tTxMuteData;

/* struct with data for Bus State monitoring, used as array for all busses    */
typedef struct
{
  BYTE  bN;                                        /**< counter for IncAbs    */
  WORD  wShortestTxTime;                           /**< shortest TX time      */
  WORD  wM;                                        /**< max. counter val      */
}CNM_OSEKI_tBusOffData;

/* struct with data for Patching the VCAN TX Mute Data                        */
typedef struct
{
  BYTE  bN;                                        /**< counter for IncAbs    */
  WORD  wCycleTime;                                /**< cycle time for Node   */
  WORD  wM;                                        /**< max. counter val      */
  DWORD dwId;                                      /** assigned CAN ID        */
}CNM_OSEKI_tTxMutePatchData;

/* struct for bus configuration, used as array with all available busses      */
typedef struct _CNM_OSEKI_tBusConfig
{
  BYTE  bCsmBus;
  CNM_OSEKI_RxMonitorState     * parRxStates;
  CNM_OSEKI_TxMonitorState     * parTxStates;
  CNM_OSEKI_BusOffMonitorState * parBusOffStates;

  const CNM_OSEKI_tRxNodeData  * parRxNodeData;
        CNM_OSEKI_tTxMuteData  * parTxMuteData;    // RAM or ROM !!!    
  const CNM_OSEKI_tBusOffData  * parBusOffData;

  BYTE  bAmountRxNodes;
  BYTE  bAmountTxNodes;

  DWORD dwBusOffReinitTime;
}CNM_OSEKI_tBusConfig;

/* struct to administrate several states, modes, timers used by the CNM       */
typedef struct
{
  BYTE bBusStateTimeoutReason;           /* reason for bus state timeout      */
  BYTE bBusState;                        /* NM bus state itself               */
  BYTE bNMMode;                          /* NM mode defined by state charts   */
  BYTE bRxMonitoringState;               /* RX Monitoring On or Off           */
  BYTE bTxMonitoringState;               /* TX Monitoring On or Off           */
  BYTE bBusOffMonitoringState;           /* BusOff Monitoring On or Off       */

  BOOL fBusStateTimeout;                 /* bus state timeout active          */
  BOOL fStartup;                         /* set to TRUE on ColdInit to be     */
                                         /* able to set NM to ON upon startup */

  /* states for node, mute and busoff monitoring                              */
  CNM_OSEKI_RxMonitorState      * pRxStates;
  CNM_OSEKI_TxMonitorState      * pTxStates;
  CNM_OSEKI_BusOffMonitorState  * pBusOffStates;

  /* data for node, mute and busoff monitoring                                */
  const CNM_OSEKI_tRxNodeData   * pRxNodeData;
        CNM_OSEKI_tTxMuteData   * pTxMuteData;  // ROM or RAM !!!     
  const CNM_OSEKI_tBusOffData   * pBusOffData;

  /* instance of an FSM for NM                                                */
  CNM_OSEKI_FSM_tFsmInstance * pNmFsmInstance;
}CNM_OSEKI_tState;


/*******************************************************************************
 * function prototype (scope: modul-local)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * variable declaration (scope: modul-local)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * include of project specific part
 ******************************************************************************/
#include "cnm_oseki_mp.h"    /* project specific configuration */

#else
  #error CNM_OSEKI_M.H included several times
#endif
/*******************************************************************************
 * \doxydocu
 * \file          cnm_oseki_m.h
 * \brief         OSEK Network Management. modul internal interface header
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/modules_swa/cnm/src/
 *
 * \ingroup       CNM
 *
 * \authors       Prhl
 *
 * COPYRIGHT      (c) 2009 Bosch Car Multimedia GmbH
 *
 * \history_begin
 *
 * 04.09.09  main\1  Prhl
 * - initial version
 *
 * 06.05.10  main\3  Borck
 * - data structures extended and added for node and mute monitoring
 *
 * 11.05.10  main\4  Borck
 * - data structures extended, new structs introduced
 *
 * 21.05.10  main\5  Borck
 * - data structures extended, new structs introduced
 *
 * 12.08.10  main\6  Borck
 * - TX/RX Monitor data structures extended by the capability to assign a CAN ID
 *
 * 17.08.10  main\7  Borck
 * - mechanism of monitor counters changed, here adding a struct element
 *
 * 02.11.10  main\8  Borck
 * - monitor counters type changed from BYTE to WORD
 *
 * 29.11.10  main\9  Borck
 * - monitor state structs extended by a changed flag
 *
 * 28.03.11  main\10 Borck
 * - CNM_OSEKI_tBusConfig extended by busoff reinit timeout value
 *
 * 05.05.11  main\11 Borck
 * - BusMode renamed to NMMode
 *
 * 07.06.11  main\12 Borck
 * - struct type CNM_OSEKI_tState extended by 3 items to store monitor states (On/Off)
 *
 * 16.12.11  main\13 Borck
 * - defines and structs for NM (FSM) state machine added.
 *
 * 14.04.15  main\14 Borck
 * - some typedef warnings corrected.
 *
 * 30.04.15  main\15 Borck
 * - struct tag name introduced for the bus config typedef.
 * - this fixes a declaration problem and allows forward declarations of the struct type
 *
 * 30.04.15  main\16 Borck
 * - previous comment added
 *
 * 21.07.15  main\17 Borck
 * - tU32 based data based on DWORD now
 *
 * 30.09.15  main\18 Borck
 * - some LINT issues fixed
 *
 * 20.01.16  main\19 Borck
 * - a new typedef created, TxMuteData related pointer types are NOT referencing const values anymore 
 * - this allows to held TxMuteData config in ROM or RAM 
 * - this is for the introduction of the possibility to handle a "slot and config dependent" TX Mute monitoring
 *
 * \history_end
 **** END OF FILE *************************************************************/
