/* Description and history of cnm_oseki_i.h at the end of the file.             */
#ifndef CNM_OSEKI_I_HEADER
/** File name for preprozessor commands */
#define CNM_OSEKI_I_HEADER
/** Doxygen instruction:
 * \defgroup      CNM_OSEK   CNM_OSEK
 *                This group contains all files belonging OSEK network management
 * \ingroup       CNM
*/

#include "cnm_oseki_ip.h"   /* include project specific part */
/* no further includes allowed */

/*******************************************************************************
 * defines and macros (scope: CAN stack)
 ******************************************************************************/
/* state transitions used with CNM_OSEKI_vIndicateStateTransition             */
#define CNM_OSEKI_C_DOWN_LISTEN       0x01
#define CNM_OSEKI_C_LISTEN_STARTUP    0x02
#define CNM_OSEKI_C_STARTUP_LISTEN    0x03
#define CNM_OSEKI_C_STARTUP_UP        0x04
#define CNM_OSEKI_C_UP_SHUTDOWN       0x05
#define CNM_OSEKI_C_SHUTDOWN_UP       0x06
#define CNM_OSEKI_C_SHUTDOWN_LISTEN   0x07
#define CNM_OSEKI_C_LISTEN_DOWN       0x08

/* Monitoring state */
typedef enum
{
  _MONITOR_OFF  = 0x0000,
  _MONITOR_ON   = 0x0001
} tCNM_MONITORING_STATE;

#define CNM_OSEKI_MONITOR_OFF    CSM_M_GET_LOBYTE(_MONITOR_OFF)
#define CNM_OSEKI_MONITOR_ON     CSM_M_GET_LOBYTE(_MONITOR_ON)

/* NM modes according to state charts for OSEKI NM                            */
/* used by the FSM                                                            */
typedef enum
{
  _NMOff            =  0x0000,
  _NMOn             =  0x0080,
  _NMAwake          =  0x0040,
  _NMBusSleep       =  0x0081,
  _NMNormal         =  0x00C2,
  _NMWaitBusSleep   =  0x00C4,
  _NMLimpHome       =  0x00C8
} tCNM_OSEKI_NM_STATE;

#define CNM_OSEKI_C_NMOn              CSM_M_GET_LOBYTE(_NMOn)           /* mainly used hierarchically nested */
#define CNM_OSEKI_C_NMAwake           CSM_M_GET_LOBYTE(_NMAwake)        /* mainly used hierarchically nested */

#define CNM_OSEKI_C_NMOff             CSM_M_GET_LOBYTE(_NMOff)          /* needed for cnm.c                */
#define CNM_OSEKI_C_NMBusSleep        CSM_M_GET_LOBYTE(_NMBusSleep)     /* NMOn & NMBusSleep               */
#define CNM_OSEKI_C_NMNormal          CSM_M_GET_LOBYTE(_NMNormal)       /* NMOn & NMAwake & NMNormal       */
#define CNM_OSEKI_C_NMWaitBusSleep    CSM_M_GET_LOBYTE(_NMWaitBusSleep) /* NMOn & NMAwake & NMWaitBusSleep */
#define CNM_OSEKI_C_NMLimpHome        CSM_M_GET_LOBYTE(_NMLimpHome)     /* NMOn & NMAwake & NMLimpHome     */

/*******************************************************************************
 * typedefs (scope: CAN stack)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * variable definition (scope: CAN stack)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * function prototypes (scope: CAN stack and operating system)
 ******************************************************************************/
extern LONG CNM_OSEKI_lInit(BYTE bInitMode);        /* called via CSM_lInit() */
extern LONG CNM_OSEKI_lExit(BYTE bExitMode);        /* called via CSM_lExit() */

#ifdef CSM_C_PTYPE_DC_OSEKI_NWM
extern LONG CSM_OSEKI_lApplCallbackInit(void *, BYTE, DWORD, const void *, tCSM_OSEKI_NWM_APPL_CALLBACK *);
extern LONG CSM_OSEKI_lGetCommunicationState(BYTE, DWORD, const void *, BYTE *, WORD);
#if (CSM_S_REMOTE_STACK == CSM_C_F_ON)
extern void CSM_OSEKI_vPROXYCommunicationInd( BYTE bBus, DWORD dwProtocolType, void *pvAddressField, BYTE bAction, WORD wApplId);
#endif //CSM_S_REMOTE_STACK == CSM_C_F_ON
extern VOID CSM_OSEKI_vProcessCommunicationInd(VOID);
extern LONG CNM_OSEKI_lCommunicationReq(BYTE, DWORD, const void *, BYTE, WORD);
extern VOID CNM_OSEKI_vProcessCommunicationReq(VOID);
#endif //CSM_C_PTYPE_DC_OSEKI_NWM

extern LONG CNM_OSEKI_lGotoMode(BYTE bBus, BYTE bMode);
extern VOID CNM_OSEKI_vIndicateStateTransition(BYTE bBus, BYTE bTransition);

extern BYTE CNM_OSEKI_bCalculateBusState(BYTE bBus);
extern BYTE CNM_OSEKI_bGetStatus(BYTE bBus);

extern VOID CNM_OSEKI_vProcessTimeout(void);

extern VOID CNM_OSEKI_vReceiveInd(const CSM_CAN_RX_DATA * prData);
extern VOID CNM_OSEKI_vDataCon(const CSM_CAN_CON_DATA * prData);

extern LONG CNM_OSEKI_lBusoffRecovery(BYTE bBus);
extern LONG CNM_OSEKI_lBusoffEntry(BYTE bBus);

extern void CNM_OSEKI_vReInitMonitoringStates(BYTE bBus);

/* Timer Callbacks - will be called on INTERRUPT Level !!!!                   */
extern void CNM_OSEKI_vReinitTimerExpired(BYTE bBus);
extern void CNM_OSEKI_vBusStateTimeout(DWORD dwValue);
extern void CNM_OSEKI_vRxNodeMonitorTimeoutBus0(DWORD dwValue);
extern void CNM_OSEKI_vTxMuteMonitorTimeoutBus0(DWORD dwValue);
extern void CNM_OSEKI_vRxNodeMonitorTimeoutBus1(DWORD dwValue);
extern void CNM_OSEKI_vTxMuteMonitorTimeoutBus1(DWORD dwValue);
extern void CNM_OSEKI_vBusOffMonitorTimeout(DWORD dwValue);
extern void CNM_OSEKI_vFsmTimeout(DWORD dwValue);
extern void CNM_OSEKI_vSendAllIndicationsAgain( void);

#else /* CNM_OSEKI_I_HEADER already defined */
# error CNM_OSEKI_I.H included several times
#endif
/*******************************************************************************
 * \doxydocu
 * \file          cnm_oseki_i.h
 * \brief         OSEK Network Management interface
 *                OSEK Network Management based on OSEK NM 2.51
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/modules_swa/cnm/src/
 *
 * \ingroup       CNM
 * \ingroup       CNM_OSEK
 *
 * \authors       Prhl
 *
 * COPYRIGHT      (c) 2009 Bosch Car Multimedia GmbH
 *
 * \history_begin
 *
 * 04.09.09  main\1  Prhl
 * - initial version
 *
 * 06.05.10  main\3  Borck
 * - some prototypes added for CNM
 *
 * 11.05.10  main\4  Borck
 * - node monitoring timeout functions are bus specific now
 *
 * 21.05.10  main\5  Borck
 * - timeout functions extended
 *
 * 04.08.10  main\6  Borck
 * - new Interface for State Transition Indication introduced
 *
 * 01.11.10  main\7  Borck
 * - prototypes for application interface added
 *
 * 09.11.10  main\8  Borck
 * - prototype for application interface added
 *
 * 05.05.11  main\9  Borck
 * - all NM modes (used by GotoMode) renamed and some more added.
 *
 * 07.06.11  main\10  Borck
 * - new prototypes added to application interface
 *
 * 17.06.11  main\11  Borck
 * - some small adaptations for ETG tracing
 *
 * 22.06.11  main\12  Borck
 * - prototype signature changed
 *
 * 16.12.11  main\13  Borck
 * - timeout callback for FSM added.
 *
 * 02.06.15  main\14  M.Prhl
 * - CSM_OSEKI_vPROXYCommunicationInd() added.
 *
 * 04.11.15  main\15  M.Prhl
 * - CNM_OSEKI_vSendAllIndicationsAgain() added.
 *
 * 24.11.17  main\g3inf4cv_csm_proxy_in\1  Jayashree
 * - Initial version for INF4CV
 *
 * \history_end
 *//**** END OF FILE **********************************************************/

