/* Description and history of cnm_i.h at the end of the file                  */
#ifndef CNM_I_HEADER
#define CNM_I_HEADER

/* Include project specific part if necessary. */
/* No further includes allowed. */
/* #include "cnm_ip.h" not necessary up to know */

/*******************************************************************************
 * defines and macros (scope: CAN stack)
 ******************************************************************************/
/* parameters for CNM_lGotoMode, CNM_lGetStatus */
#define CNM_C_BUS_OFF               0x00
#define CNM_C_CAN_SLEEP             0x01
#define CNM_C_CAN_BUS_SLEEP         0x02
#define CNM_C_CAN_NORMAL            0x04
#define CNM_C_BUS_START             0x08
#define CNM_C_IND_RING_DATA         0x10
#define CNM_C_BUS_OFF_END           0x20
#define CNM_C_WAIT_BUS_SLEEP        0x40
#define CNM_C_WAIT_BUS_SLEEP_CANCEL 0x80

/* General CNM error codes: (VK: removed because general CSM errors shall be used*/

/*******************************************************************************
 * typedefs (scope: CAN stack)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * variable definition (scope: CAN stack)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * function prototypes (scope: CAN stack and operating system)
 ******************************************************************************/

LONG CNM_lInit(BYTE bInitMode);
LONG CNM_lExit(BYTE bExitMode);

LONG CNM_lGetStatus(BYTE bBus);
LONG CNM_lGotoMode(BYTE bBus,BYTE bNM_Mode);

LONG CNM_lBusoffEntry(BYTE bBus);
LONG CNM_lBusoffRecovery(BYTE bBus);

BYTE CNM_bCalculateBusState(BYTE bBus);

#else
#error CNM_I.H included several times
#endif
/*******************************************************************************
 * \doxydocu
 * \file          cnm_i.h
 * \brief         CAN Network Management module interface header.
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/modules_swa/cnm/src/
 *
 * \ingroup       CNM
 * \ingroup       CNM_IF
 *
 * \authors       V-Team
 *
 * COPYRIGHT      (c) 2004 Blaupunkt GmbH
 *
 * \history_begin
 *
 * 03.09.04  \main\3  CM-DI/ESA3-Prhl
 * - CNM_bCalculateBusState() added
 *
 * 29.09.04  \main\4  CM-DI/ESA3-Battis
 * - CNM_lBusoffRecovery() added
 *
 * 03.02.05  \main\5  CM-DI/ESA3-Battis
 * - CNM_lBusoffReinit() inserted
 *
 * 09.06.05  \main\6  CM-DI/ESA3-K"ohler
 * - Doxygen comments added.
 * - Error code defines removed.
 *
 * 14.06.07  \main\7  CM-DI/VTEAM-Battis
 * - feature switch usage corrected.
 *
 * 07.12.06  \main\8  CM-DI/VTeam-Khler
 * - CSM_S_FORD_NM_OSEK code removed.
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
