/* Description and history of cda_ip.h at the end of the file.                */
#ifndef CDA_IP_HEADER
/** File name for preprozessor commands */
#define CDA_IP_HEADER

/*******************************************************************************
 * defines and macros
 * (scope: cda manager module interface)
 ******************************************************************************/
#if (CSM_S_CDA_SENDRESTRICTION == CSM_C_F_ON)
//  #define CDA_C_SEND_RESTRICTION_MASK_NO      (0x00000000UL) is defined in cda_i.h
//  #define CDA_C_SEND_RESTRICTION_MASK_ALL     (0xffffffffUL) is defined in cda_i.h
#define CDA_C_SEND_RESTRICTION_MASK_NO_TYPE     (0x00000001UL)  /**< This bit must be consistent with cda_abSendRestrictionTelegramTypeList[] content */
#define CDA_C_SEND_RESTRICTION_MASK_MCNET_ASDT  (0x00000002UL)  /**< This bit must be consistent with cda_abSendRestrictionTelegramTypeList[] content */
#define CDA_C_SEND_RESTRICTION_MASK_VAG_TP20    (0x00000004UL)  /**< This bit must be consistent with cda_abSendRestrictionTelegramTypeList[] content */
#define CDA_C_SEND_RESTRICTION_MASK_VAG_BAP_RAW (0x00000008UL)  /**< This bit must be consistent with cda_abSendRestrictionTelegramTypeList[] content */
#define CDA_C_SEND_RESTRICTION_MASK_VAG_BAP     (0x00000010UL)  /**< This bit must be consistent with cda_abSendRestrictionTelegramTypeList[] content */
#define CDA_C_SEND_RESTRICTION_MASK_ISO_TP      (0x00000020UL)  /**< This bit must be consistent with cda_abSendRestrictionTelegramTypeList[] content */
#define CDA_C_SEND_RESTRICTION_MASK_ISO_TP_AREA (0x00000040UL)  /**< This bit must be consistent with cda_abSendRestrictionTelegramTypeList[] content */
#define CDA_C_SEND_RESTRICTION_MASK_OSEK_NM     (0x00000080UL)  /**< This bit must be consistent with cda_abSendRestrictionTelegramTypeList[] content */
#define CDA_C_SEND_RESTRICTION_MASK_VWHIGH_NM   (0x00000100UL)  /**< This bit must be consistent with cda_abSendRestrictionTelegramTypeList[] content */
#define CDA_C_SEND_RESTRICTION_MASK_CBR_TX      (0x00000200UL)  /**< This bit must be consistent with cda_abSendRestrictionTelegramTypeList[] content */

#endif /* CSM_S_CDA_SENDRESTRICTION */

/*******************************************************************************
 * typedefs
 * (scope: cda manager module interface)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * variable definition
 * (scope: cda manager module interface)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * function prototypes
 * (scope: cda manager module interface
 ******************************************************************************/
/* --none-- */

#else /* CDA_IP_HEADER already defined */
#error CDA_IP.H included several times
#endif
/*******************************************************************************
 * \doxydocu
 * \file          cda_ip.h
 * \brief         Project specific part of the interface header(s) of CAN
 *                driver access modules (manager, controller and transceiver).
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       Main
 * \path          /di_can/modules_swa/cda/src/
 *
 * \ingroup       CDA
 *
 * \authors       V-Team
 *
 * COPYRIGHT      (c) 2005 Blaupunkt
 *
 * \history_begin
 *
 * 25.05.05  main/2  CM-DI/ESA3-K"ohler
 * - Initial template revision.
 *
 * 15.05.07  \main\3  CM-DI/VTeam-Prhl
 * - spaces after # deleted
 *
 * 25.05.07  \main\4  CM-DI/VTeam-Prhl
 * - defines for send restriction added
 *
 * 09.10.13  \main\5  Feldhaus
 * - added new types for send restriction list
 *
 * \history_end
 *//**** END OF FILE **********************************************************/

