/* Description and history of cbr_ip.h at the end of the file.               */

#ifndef CBR_M_HEADER
#define CBR_M_HEADER

/*****************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------*/
#include "cbr_mp.h"

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

/* error codes */
#define CBR_M_MAKE_ERROR(SecurityLevel,ErrorCode) \
            CSM_M_MAKE_ERROR(SecurityLevel,CSM_C_ERR_LOC_CBR,ErrorCode)


/*****************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------*/
/** data structure for transmit telegram state */
typedef struct
{
  BOOL  fTransmit;      /**< Trigger Flag for transmit request, if TRUE transmit is pennding. Possible value TRUE/FALSE */
  BOOL  fRepeatTimeout; /**< Trigger Flag for repeat timeout, if TRUE Timeout occured. Possible value TRUE/FALSE */
  BOOL  fValid;         /**< Dieses Flag ist TRUE wenn einmal SignalWrite aufgerufen wird */
#if (CSM_S_CBR_MIN_DELAY == CSM_C_F_ON)
  BOOL  fDelayTransmit; /**< This Flag delays the next transmit, if TRUE transmit is not possible. Possible value TRUE/FALSE */
#endif
#if  (CSM_S_CBR_TX_IF_APPL_ACTIVE == CSM_C_F_ON)
  BYTE  bRepeatCount;   /**< hier wird gezhlt wie oft noch das Telegram gesendet werden muss nachdem kein Signal mehr activ ist */
  DWORD dwActive;        /**< Diese Flags signalisieren fr jedes Signal den "Funktion aktiv" Zustand der Messages */
#endif
#if (CSM_S_REQUESTABLE_TIMER == CSM_C_F_ON)
  DWORD hRepeatTimer;      /**< Timer Handle TODO:kann ins ROM */
#endif
#if (CSM_S_REMOTE_STACK == CSM_C_F_ON)
  BOOL fBusWakeTemp;
#endif
}tCBR_TX_TELEGRAM_STATE;

/** data structure for receive telegram state */
typedef struct
{
  BOOL  fReceiveTimeout;    /**< Trigger Flag for receive timeout, if TRUE Timeout occured. Possible value TRUE/FALSE */
  BYTE  abIndicate[8];      /**< Diese Flags signalisieren fr jedes Signal das eine Indication an die Application erfolgen mu */
  DWORD dwState;            /**< telegram state, Possible values CSM_C_SIGNAL_NOT_RECEIVED, CSM_C_SIGNAL_ARRIVED, CSM_C_SIGNAL_ARRIVED_FIRST, CSM_C_SIGNAL_TIMEOUT */
  #if (CSM_S_REQUESTABLE_TIMER == CSM_C_F_ON)
  DWORD hReceiveTimer;      /**< Timer Handle TODO:kann ins ROM */
  #endif
}tCBR_RX_TELEGRAM_STATE;

/*****************************************************************
| variable declaration (scope: global)
|----------------------------------------------------------------*/
/* --none-- */

/*****************************************************************
| function prototypes (scope: global)
|----------------------------------------------------------------*/
/* --none-- */

#else
#error CBR_M.H included several times
#endif
/*******************************************************************************
 * \doxydocu
 * \file          cbr_m.h
 * \brief         CAN broadcast server module internal header
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/modules_swa/cbr/src/
 *
 * \ingroup       CBR
 *
 * \authors       V-Team
 *
 * COPYRIGHT      (c) 2004 Blaupunkt GmbH
 *
 * \history_begin
 *
 * 08.03.05 main\4  CM-DI/ESA3-Battis
 * - recieve renamed to receive
 *
 * 14.03.05 main\5  CM-DI/ESA3-Battis
 * - type declaration corrected after lint check
 *
 * 04.04.05 main\6  CM-DI/ESA3-Prhl
 * - min delay added
 *
 * 04.04.05 main\7 CM-DI/ESA3-Prhl
 * - change indication and activ flags
 *
 * 07.04.05 main\8 CM-DI/ESA3-Battis
 * - code cosmetics
 *
 * 07.04.05 main\9 CM-DI/ESA3-Battis
 * - min delay optimized
 *
 * 28.04.05 main\10 CM-DI/ESA3-Battis
 * - VW merge
 *
 * 06.07.05 main\11 CM-DI/ESA3-Zurmhl
 * - All error code defines commented out (error codes from
 * - csm_stack_i.h used instead!)
 *
 * 22.09.05 main\12 CM-DI/ESA3-Battis
 * - doxygen
 *
 * 22.02.08 main\13 VTeam-Prhl
 * - make doxygen happy.
 *
 * 03.04.13 main\14 Borck
 * - possible amount of signals per telegramm now extended to 64 by a change in struct tCBR_RX_TELEGRAM_STATE
 * - macros cbr_vSetIndicationFlag, cbr_vClrIndicationFlag and cbr_fGetIndicationFlag adapted in cbr.c !!!
 *
 * 20.03.15 main\15 Pistoor
 * - extended indication flag access to more than 32 signals in telegram
 *
 * 20.03.15 main\16 Pistoor
 * - undid last change because already done in version before
 *
 * 10.09.15 main\17 Prhl
 * - fBusWakeTemp added to typedef tCBR_TX_TELEGRAM_STATE
 *
 * \history_end */

/* *** END OF FILE ********************************************************* */
