/************************************************************************
 *FILE:           CBR_I.H
 *SW-COMPONENT:   CAN Broadcast Server module header
 *DESCRIPTION:    CAN header file for module
 *                external/internal used data/definitions
 *AUTHOR:         CM-DI/EHS3-Pistoor
 *COPYRIGHT:      (c) 2002 Blaupunkt Werke GmbH
 *
 ************************************************************************/

#ifndef CBR_I_HEADER
#define CBR_I_HEADER

/*****************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------*/
#include "cbr_ip.h"

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/
/* --none-- */

/*****************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------*/
/* --none-- */

/*****************************************************************
| variable declaration (scope: global)
|----------------------------------------------------------------*/
/* --none-- */

/*****************************************************************
| function prototypes (scope: global)
|----------------------------------------------------------------*/
/* ------------------------------------------------------------------------- */
extern LONG CBR_lInit(
  const BYTE bInitMode);

/* ------------------------------------------------------------------------- */
extern LONG CBR_lExit(
  const BYTE bExitMode);

/* ------------------------------------------------------------------------- */
extern LONG
CSM_CBR_lApplCallbackInit(
#if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
                          void * pvHandle,
#endif
                          BYTE  bBus,
                          const DWORD dwProtocolType,
                          const void * pvAddressField,
                          const tCSM_BR_SIGNAL_APPL_CALLBACK* prCallBackFkt);

/* ------------------------------------------------------------------------- */
extern LONG
CBR_lSignalCallBackInit(
#if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
                        void * pvHandle,
#endif
                        const DWORD dwSignalId,
                        const tCSM_PFN_CBR_SIGNAL_IND vPFNCBRSignalInd);

/* ------------------------------------------------------------------------- */
extern LONG
CBR_lStartTx(
  const BYTE bBus);

/* ------------------------------------------------------------------------- */
extern LONG
CBR_lStartRx(
  const BYTE bBus);

/* ------------------------------------------------------------------------- */
extern LONG
CBR_lStopTx(
  const BYTE bBus);

/* ------------------------------------------------------------------------- */
extern LONG
CBR_lStopRx(
  const BYTE bBus);

/* ------------------------------------------------------------------------- */
extern LONG CBR_lSignalWrite(const DWORD dwSignalId, const void * pvNewSignalData, const BYTE bDataBufferLength, const BYTE bTxType);
extern LONG CBR_lFullFrameSignalWrite(const DWORD dwSignalId, const void * pvNewSignalData, const BYTE bDataBufferLength, const BYTE bTxType);

/* ------------------------------------------------------------------------- */
extern LONG
CBR_lMultipleSignalWrite(
  const tCSM_MultipleSignalWrite *prSignalList,
  const BYTE  bNumberOfSignals);

/* ------------------------------------------------------------------------- */
extern LONG
CBR_lSignalRead(
  const DWORD dwSignalId,
  void  * pvActSignalData,
  const BYTE bDataBufferLength,
  DWORD * pdwSignalStatus);

/* ------------------------------------------------------------------------- */
extern LONG
CBR_lMultipleSignalRead(
  tCSM_MultipleSignalRead *prSignalList,
  const BYTE  bNumberOfSignals);

/* ------------------------------------------------------------------------- */
extern void
CBR_vProcessTransmit(
  void);

/* ------------------------------------------------------------------------- */
extern void
CBR_vProcessTimeout(
  void);

extern void
CBR_vProcessSignalInd(
  void);

/* ------------------------------------------------------------------------- */
extern void
CBR_vTransmitTimeout(
  const DWORD dwTelegramIndex);

/* ------------------------------------------------------------------------- */
extern void
CBR_vTransmitMinDelayTimeout(
  const DWORD dwTelegramIndex);

/* ------------------------------------------------------------------------- */
extern void
CBR_vReceiveTimeout(
  const DWORD dwTelegramIndex);

/* ------------------------------------------------------------------------- */
extern void
CBR_vSetRxGrpMask(const BYTE bMask);
/* ------------------------------------------------------------------------- */
extern void
CBR_vClrRxGrpMask(const BYTE bMask);
/* ------------------------------------------------------------------------- */
extern BYTE
CBR_bGetRxGrpMask(void);
/* ------------------------------------------------------------------------- */
extern void
CBR_vSetRxGroup2Outdated(const BYTE bRxGroup);
/* ------------------------------------------------------------------------- */
void
CBR_vSendAllSignalsAgain(void);
/* ------------------------------------------------------------------------- */

#else
#error CBR_I.H included several times
#endif
/*******************************************************************************
 * \doxydocu
 * \file          cbr_i.h
 * \brief         Header file for CBR external used function and defines.
 *
 *                Header file for CBR external used function and defines.
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/modules_swa/cbr/src/
 *
 * \ingroup       CBR
 *
 * \authors       V-Team
 *
 * COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 *
 * \history_begin
 * 23.06.04  main\3 CM-DI/ESU3-Prhl
 * - add CBR_lCommunicationReq()
 *
 * 28.06.04  main\4 CM-DI/ESU3-Prhl
 * - add CBR_lApplCallbackInit(), CBR_lSignalCallBackInit(),
 *   CBR_vProcessTransmit(), CBR_vProcessTimeout() and CBR_vProcessSignalInd()
 *
 * 03.09.04  main\5 CM-DI/ESA3-Prhl
 * - CBR_fCheckCommunicationReq(), CBR_vProcessCommunicationReg(),
 *   CBR_vProcessCommunicationCon(), CBR_vProcessCommunicationInd() added
 *
 * 07.09.04  main\6 CM-DI/ESA3-Prhl
 * - CBR_vTransmitTimeout(), CBR_vTransmitMinDelayTimeout(), CBR_vRecieveTimeout() added
 * - CBR_lExit() changed
 *
 * 22.09.04  main\7 CM-DI/ESA3-Prhl
 * - code reading, doxygen tags added
 *
 * 19.10.04  main\8 CM-DI/ESA3-Prhl
 * - warning removed
 *
 * 22.11.04  main\9 CM-DI/ESA3-Battis
 * - CBR_vRecieveTimeout() renamed to CBR_vReceiveTimeout()
 *
 * 11.02.05  \main\10  CM-DI/ESA3-Prhl
 * - CBR_vCSMBusStateInd() added
 *
 * 09.03.05  \main\11 CM-DI/ESA3-Battis
 * - RX groups support for timeout supervision implemented
 *
 * 04.04.05  \main\13 CM-DI/ESA3-Prhl
 * - some const added to make ESD happy
 *
 * 28.04.05  \main\14 CM-DI/ESA3-Battis
 * - const declarations added
 *
 * 19.09.05  \main\16 CM-DI/ESA3-Prhl
 * - add handle to all ...CallbackInit() funktions
 *
 * 19.09.05  \main\18 CM-DI/ESA3-Prhl
 * - add handle to all ...CallbackInit() funktions
 *
 * 14.06.06  \main\19 CM-DI/ESA3-Prhl
 * - CBR_vCSMBusStateInd removed
 *
 * 14.07.06  \main\20 CM-DI/ESA3-Prhl
 * - modify CSM_CBR_lApplCallbackInit(). add bBus
 *
 * 18.10.06  \main\21 CM-DI/ESA3-Prhl
 * - PVOID replaced
 *
 * 18.10.06  \main\22  CM-DI/ESA3-Khler
 * - Const for parameter pvActSignalData in CBR_lSignalRead() removed.
 *
 * 07.11.06  \main\23  CM-DI/ESA3-Battis
 * - void instead of VOID
 *
 * 13.02.07  \main\24  CM-DI/ERM13-Battis
 * - function CBR_bGetRxGrpMask() added.
 *
 * 05.07.07  \main\25  VTeam-Prhl
 * - function CBR_dwGetTxIdAndBus() removed
 *
 * 10.04.08  \main\26  VTeam-Prhl
 * - Function CBR_lMultipleSignalRead() added.
 *
 * 29.04.08  \main\27  VTeam-Prhl
 * - CBR_lMultipleSignalWrite() added.
 * - CBR_lMultipleSignalRead() modified.
 *
 * 22.09.08  \main\28 VTeam-Pistoor
 * -  Made LIN adaptions
 *
 * 22.04.14  \main\29 VTeam-Pistoor
 * - usage of pvHandle only in case (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
 *
 * 23.06.16  \main\30 A.Borck
 * - new function prototype for full frame signal writing added (required for CBR gateway)
 *
 * \history_end
 * *** END OF FILE ******************************************************* */
