/* Description and history of cda_c.h at the end of the file.                 */
#ifndef CBR_C_HEADER
/** File name for preprozessor commands */
#define CBR_C_HEADER

/*****************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------*/
/* --none-- */

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/
/* --none-- */

/*****************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------*/
/* --none-- */

/*****************************************************************
| variable declaration (scope: global)
|----------------------------------------------------------------*/
/* --none-- */

/*****************************************************************
| function prototypes (scope: global)
|----------------------------------------------------------------*/

VOID CBR_vCDAReceiveInd( const CSM_CAN_RX_DATA* const prData);
void CBR_vPROXYReceiveInd( const CSM_CAN_RX_DATA* const prData, const DWORD dwSignalStatus);


#else
#error CBR_C.H included several times
#endif
/*******************************************************************************
 * \doxydocu
 * \file          cbr_c.h
 * \brief         Callback interface header of CAN broadcast server module.
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESU3
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/modules_swa/cbr/src/
 *
 * \ingroup       CBR
 *
 * \authors       CM-DI/ESA3-Proehl
 *                CM-DI/ESA3-Battis
 *
 * COPYRIGHT      (c) 2003 Blaupunkt GmbH
 *
 * \history_begin
 *
 * 28.04.05 \main\4 CM-DI/ESA3-Battis
 * - const added
 *
 * 19.09.05 \main\5 CM-DI/ESA3-Prhl
 * - const added
 *
 * 22.09.05 \main\6 CM-DI/ESA3-Prhl
 * - doxygen
 *
 * 22.09.06 \main\7 CM-DI/ESA3-Haffner
 * - added receive function for proxy (signal ind)
 *
 * 29.09.06 \main\8 CM-DI/ESA3-Haffner
 * - switched PROXY-CBR interface to CDA style.
 *
 * 05.02.07 \main\9  CM-DI/ERM13-Battis
 * - CBR_vCDAReceiveInd and CBR_vPROXYReceiveInd implemented as single functions
 *   mapping to cbr_vReceiveInd
 *
 * 16.04.07 \main\9  VTeam-Battis
 * - static cbr_vReceiveInd() moved to cbr.c to reduce compiler warnings.
 *
 * 26.06.13 \main\10  VTeam-Pistoor
 * - Changed CBR_vPROXYReceiveInd()
 *
 * 07.01.14 \main\11  VTeam-Pistoor
 * - Changed CBR_vPROXYReceiveInd()
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
