/* Description and history of csmal_krnl_trace.c at the end of the file.      */
/** File name for preprozessor commands */
#define CSMAL_KRNL_TRACE_SELF

#ifdef CSMAL_KRNL_TRACE_SELF
// make LINT happy
#endif

/** csmal_krnl_trace.c is a file according V-team CAN-SW architecture implementation rules */
#define CSM_CAN_STACK

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include <osal_if.h>

#define TRACE_S_IMPORT_INTERFACE_TYPES
#include <trace_if.h>

// #define CSM_NO_TYPE_REDEFINITION      // not used anywhere !!
#include "csm_stack_i.h"
#include "csm_stack_m.h"
//#include "csm_access_krnl.h"           // not used up to now

#include <csmal_krnl_trace.h>

// va_start not available #include "stdarg.h"  /* Prototypes for va_start, va_end */

// Trace Class is only required if standard trace is active
#if (CSM_S_TRACE == CSM_C_F_ON)
#if (CSM_S_TRACE_ETG == CSM_C_F_ON)
  // none
#else
  //#define CSMAL_TRACE_CLASS    (256 * 196 + 1)
  #define CSMAL_TRACE_CLASS      (TR_COMP_CSM + 2)
#endif
#endif

/*
#define CSMAL_C_TRACELEVEL1  TR_LEVEL_ERRORS
#define CSMAL_C_TRACELEVEL2  TR_LEVEL_COMPONENT
#define CSMAL_C_TRACELEVEL3  TR_LEVEL_USER_4
*/

/* Feature switch is used only to control doxygen documentation */
#if (CSM_S_DOXYGEN_HIDE_NON_API_FCT == CSM_C_F_OFF)
/*******************************************************************************
 * function implementation (scope: file local = LOCAL)
 ******************************************************************************/
/*-- none --*/

/*******************************************************************************
 * function implementation (scope: CAN stack and operating system)
 *******************************************************************************/
#if (CSM_S_TRACE == CSM_C_F_ON)
#if (CSM_S_TRACE_ETG == CSM_C_F_ON)
// ETG Tracing is active -> we do not need the standard trace stuff
#else
// ETG Tracing is not active, so keep standard trace support
#define CSM_S_USE_TRACE_CORE // After MY09 final software this feature switch and the old corresponding code is to be removed.
/*******************************************************************************
 * function    CSMAL_vTraceOut
 * \doxydocu
 * \brief      CSM access layer trace routine
 *
 * \param[in]  wTraceOutLevel
 *              CSM internal trace level.
 *
 * \param[in]  coszFormat
 *             Format string to trace, followed by additional params (varargs).
 *
 * \return     VOID
 *
 * \lastreview
 * \history_begin
 * 02.06.2008  VTeam-Brunotte
 * - trace output is only made if the requested level is activ.
 * 22.01.2008  VTeam-Khler
 * - Initial Revision, derived from CSMAL_vTraceInfo/Error (3SOFT Schubart).
 * \history_end
 ******************************************************************************/
VOID CSMAL_vTraceOut(WORD wTraceOutLevel, const char* coszFormat, ...)
{
  va_list argList = {0}; // = NULL;
  LONG lSize = 0;
  BYTE bBuffer[256];
  BYTE* pbBuffer = (PBYTE)bBuffer;
  TR_tenTraceLevel rLldTraceLevel;  /* Trace level of low level trace driver
                                     * (\see trace_interface.h and adit_trace.h) */
  /* set system trace level */
  switch( wTraceOutLevel)
  {
    case CSM_C_TRACEOUT_LEVEL_WARNING:
    {
      rLldTraceLevel = TR_LEVEL_SYSTEM_MIN;
      /* rLldTraceLevel = TR_LEVEL_COMPONENT;   rLldTraceLevel = TR_LEVEL_SYSTEM;   */
      break;
    }
    case CSM_C_TRACEOUT_LEVEL_ERROR:
    {
      rLldTraceLevel = TR_LEVEL_ERRORS;
      break;
    }
    case CSM_C_TRACEOUT_LEVEL_SEVERE_ERROR:
    {
      rLldTraceLevel = TR_LEVEL_FATAL;
      break;
    }
    case CSM_C_TRACEOUT_LEVEL_INTERFACE:
    case CSM_C_TRACEOUT_LEVEL_INFO:
    default:
    {
      rLldTraceLevel = TR_LEVEL_USER_4;
      break;
    }
  } /* switch( wTraceOutLevel) */
  #ifndef VARIANT_S_FTR_ENABLE_OSAL_CSM_SOCKET_SIMU
  #ifdef CSM_S_USE_TRACE_CORE
  if (TR_core_bIsClassSelected(CSMAL_TRACE_CLASS, rLldTraceLevel)!=FALSE)
  #endif
  {
    va_start(argList, coszFormat);
    lSize = vsnprintf((char*)pbBuffer, sizeof(bBuffer), coszFormat, argList);
    va_end(argList);

    if (lSize >= 0)
    {
      TR_core_uwTraceOut(strlen((char*)pbBuffer) + 1,
                         CSMAL_TRACE_CLASS, rLldTraceLevel, pbBuffer);
    }
  }
  #else // VARIANT_S_FTR_ENABLE_OSAL_CSM_SOCKET_SIMU
  #if (CSM_S_DEBUG != CSM_C_F_ON)
    // do trace for level USER_4 only if DEBUG is ON
    if (rLldTraceLevel!=TR_LEVEL_USER_4)
  #endif
    {
      va_start(argList, coszFormat);
      lSize = vsnprintf((char*)pbBuffer, sizeof(bBuffer), coszFormat, argList);
      va_end(argList);
      printf((char*)pbBuffer);
      printf("\n");
    }
  #endif // VARIANT_S_FTR_ENABLE_OSAL_CSM_SOCKET_SIMU
}
#endif // CSM_S_TRACE_ETG
#endif // CSM_S_TRACE

#endif // CSM_S_DOXYGEN_HIDE_NON_API_FCT

//******************************************************************************
//* function implementation (scope: CAN stack #1 API)
//******************************************************************************
// none

#undef CSM_CAN_STACK
#undef CSMAL_KRNL_TRACE_SELF
/*******************************************************************************
 * \doxydocu
 * \file          csmal_krnl_trace.c
 * \brief         Trace functionality for CSM Access Layer
 *
 * \project       JV-Platfom
 * \path          /di_can/adapt/tengine/csm_access_krnl/sources/
 *
 * \ingroup       CSM_ACCESS_KRNL
 *
 * \authors       3SOFT GmbH, Schubart
 *
 * COPYRIGHT      (c) 2006 Blaupunkt GmbH
 *
 * \history_begin
 *
 * 25.10.06  Schubart, 3SOFT
 * Initial revision.
 *
 * 06.12.07  /main/2  VTeam-Khler
 * - Lint warnings removed.
 * - Doxygen comments added/corrected.
 * - Indentation changed
 *
 * 05.02.08  /main/3  VTeam-Khler
 * - CSMAL_vTraceOut() added instead of CSMAL_vTraceInfo() and
 *   CSMAL_vTraceError().
 *
 * 21.04.08  /main/4  VTeam-Pistoor
 * - Added precompiler switch CSM_S_TRACE around CSMAL_vTraceOut()
 *
 * 02.06.08 /main/5 VTeam-Brunotte
 * - CSMAL_vTraceOut: Trace level check added, before trace output function is
 *   called.
 *
 * 05.03.10 /main/6 VTeam-Pistoor
 * - Disabled content CSMAL_vTraceOut(), has to be adapted from Dragon to Triton
 *
 * 05.07.10 /main/7 VTeam-Pistoor
 * - Enabled content CSMAL_vTraceOut() again, only initialization argList had to be removed.
 *
 * 29.09.10  /main/8  VTeam-Khler
 * - Not used includes commented out. va_start, va_end lint warnings open.
 *
 * 07.10.10  /main/9  VTeam-Pistoor
 * - Corrected check of TR_core_bIsClassSelected(), return value is byte, not bool.
 *
 * 23.12.10  /main/10  VTeam-Pistoor
 * - CRemoved LINT warnings
 *
 * 23.10.12  /main/11  Kempen Borck
 * - annoying debug output featured.
 *
 * 14.11.16  /main/12  A.Borck
 * - Availability of trace function code made dependend on ETG feature
 *
 * 24.01.17  /main/13  A.Borck
 * - LINT fixes
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
