
/************************************************************************
*FILE					: swuhmi_statusupdatewnd_inf4cv.cpp
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: inf4cv Status Update Window.
*DESCRIPTION			: On Startup & On End, This window is used by the App.
*AUTHOR					: RRD7KOR (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2018	| 0.1		| RRD7KOR			| Initial
----------------------------------------------------------------------------

************************************************************************/


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL 			TR_TTFIS_SWUPDATE
#define ETG_I_TTFIS_CMD_PREFIX 			"DNL_"
#define ETG_I_FILE_PREFIX 				SWUHMI::LABEL::
#define ETG_DEFAULT_TRACE_CLASS 		TR_CLASS_SWUPDATE_HMI
#include "trcGenProj/Header/swuhmi_statusupdatewnd_inf4cv.cpp.trc.h"
#endif

#include "fcswupdatesrv/FcSwUpdateSrvJson.h"
#include "main/swuhmi_component.h"
#include "swuhmi_statusupdatewnd_inf4cv.h"
#include "main/swuhmi_configurator_inf4cv.h"
#include "../config/swuhmi_includes_inf4cv.h"
#include "../widgets/swuhmi_graphicsinterface_inf4cv.h"

namespace swuhmi {
/************************************************************************
*FUNCTION			: statusupdatewnd
*DESCRIPTION		: Constructor of Status Update Wnd.
*PARAMETER			: None
*RETURNVALUE		: Void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
statusupdatewnd::statusupdatewnd(){

	m_strDeviceId.clear();
	m_strStatusText.clear();

}

/************************************************************************
*FUNCTION			: statusupdatewnd
*DESCRIPTION		: Destructor of Status Update Wnd.
*PARAMETER			: None
*RETURNVALUE		: Void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
statusupdatewnd::~statusupdatewnd()
{

}

/************************************************************************
*FUNCTION			: InitalizeWnd
*DESCRIPTION		: Initialize of Status Update Wnd.
*PARAMETER			: None
*RETURNVALUE		: Void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
tVoid statusupdatewnd::InitalizeWnd()
{
	ETG_TRACE_USR2(("statusupdatewnd::InitalizeWnd"));

	GetScreenResolution();

     if(swu::exists(swuhmi_systemsettings_inf4cv::instance()->_inf4cvBackGroundImageLoc))
		SetBackGroundImage(swuhmi_systemsettings_inf4cv::instance()->_inf4cvBackGroundImageLoc);
    
	if(swu::exists(swuhmi_systemsettings_inf4cv::instance()->_backgndImageLoc))
		SetBackGroundImage(swuhmi_systemsettings_inf4cv::instance()->_backgndImageLoc,BOSCH_LOGO_X_POS,BOSCH_LOGO_Y_POS);

	string HeaderText("");
	m_HeaderLabel.SetXPos(HEADERLABEL_XPOS);
	m_HeaderLabel.SetYPos(HEADERLABEL_YPOS);
	m_HeaderLabel.SetLabelAlignment(E_LABEL_HORIZONTAL_CENTER_ALIGNMENT);
	m_HeaderLabel.SetFontHeight(LARGE_FONT_HEIGHT);
	m_HeaderLabel.SetFGColor(WHITE_COLOR);
	string TranslatedText("");
	if( isKDSOnlystick )
	{
		HeaderText.assign("System configuration data update");
		TranslatedText = swuhmi_systemsettings_inf4cv::instance()->GetTranslationText(_sysconfigstatuswnd_headerId);
	}
	else
	{
		HeaderText.assign("Software Update");
		TranslatedText = swuhmi_systemsettings_inf4cv::instance()->GetTranslationText(_statuswnd_headerId);
	}
	ETG_TRACE_USR2(("Translated Text:%s", TranslatedText.c_str()));
	if(!TranslatedText.empty())
	{
		HeaderText.clear();
		HeaderText = TranslatedText;
		m_HeaderLabel.SetTranslationStatus(true);
	}

	m_HeaderLabel.DrawText(HeaderText);

	m_strDeviceId.clear();

	if(SetLabelText())
	{
		m_StatusLabel.SetXPos(INFOLABEL_XPOS);
		m_StatusLabel.SetLabelAlignment(E_LABEL_HORIZONTAL_CENTER_ALIGNMENT);
		m_StatusLabel.SetYPos(INFOLABEL_YPOS);
		m_StatusLabel.SetFontHeight(MEDIUM_FONT_HEIGHT);
		m_StatusLabel.SetFGColor(WHITE_COLOR);
		m_StatusLabel.SetPreviousText(m_strStatusText);
		m_StatusLabel.DrawText(m_strStatusText);

		ETG_TRACE_USR3(("Device Id:%s", m_strDeviceId.c_str()));

		if(m_strDeviceId.length() > 0) {
			m_DeviceId.SetXPos(INFOLABEL_XPOS);
			m_DeviceId.SetLabelAlignment(E_LABEL_HORIZONTAL_CENTER_ALIGNMENT);
			m_DeviceId.SetYPos(INFOLABEL_YPOS);
			m_DeviceId.SetFontHeight(MEDIUM_FONT_HEIGHT);
			m_DeviceId.SetFGColor(WHITE_COLOR);
			string strText("Your head unit ID:");
			strText.append(m_strDeviceId);
			m_DeviceId.DrawText(strText);
		}
	}

	m_OutLine.SetXPos(OUTLINE_XPOS);
	m_OutLine.SetYPos(OUTLINE_YPOS);
	m_OutLine.SetFGColor(WHITE_COLOR);
	m_OutLine.SetLineWidth(OUTLINE_WIDTH);
	//m_OutLine.ShowOutLine();

	ShowWindow();

}

/************************************************************************
*FUNCTION			: DeInitalizeWnd
*DESCRIPTION		: DeInitialize of Status Update Wnd.
*PARAMETER			: None
*RETURNVALUE		: Void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
tVoid statusupdatewnd::DeInitalizeWnd()
{
	vDeInit();
	CloseWindow();
}

/************************************************************************
*FUNCTION			: vInit
*DESCRIPTION		: Initalize of ASF Messages
*PARAMETER			: None
*RETURNVALUE		: Void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
----------------------------------------------------------------------------
26-05-2016	| 0.2		| RRD7KOR			| Showing DeviceId in HMI.CMG3G-10462.
************************************************************************/
tVoid statusupdatewnd::vInit()
{
	ETG_TRACE_USR2(("vInit"));
}

/************************************************************************
*FUNCTION			: vDeInit
*DESCRIPTION		: DeInitalize of ASF Messages
*PARAMETER			: None
*RETURNVALUE		: Void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
----------------------------------------------------------------------------
26-05-2016	| 0.2		| RRD7KOR			| Showing DeviceId in HMI.CMG3G-10462.
************************************************************************/
tVoid statusupdatewnd::vDeInit()
{
	ETG_TRACE_USR2(("vDeInit"));
}


/************************************************************************
*FUNCTION			: SetLabelText
*DESCRIPTION		: Label Can be Chnages depends on the Input from fcswupdate.
*PARAMETER			: None
*RETURNVALUE		: tBool
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
tBool statusupdatewnd::SetLabelText()
{
	ETG_TRACE_USR2(("SetLabelText"));
	ETG_TRACE_COMP((" HMI State=%u", ETG_CENUM(tenUpdState, swuhmi_configurator_inf4cv::instance()->GetHMIState())));

	string TranslatedText("");

	FCSWUPD_NS_FCSWUPD::tenUpdState eHMIState = swuhmi_configurator_inf4cv::instance()->GetHMIState();

	tBool bReturn = false;
	m_strStatusText.clear();
	switch(eHMIState)
	{
	case FCSWUPD_NS_FCSWUPD::tenUpdState__Idle:
		m_strStatusText.assign("Initializing.......");
                TranslatedText = swuhmi_systemsettings_inf4cv::instance()->GetTranslationText(_statuswnd_init);
		bReturn = true;
		break;
	case FCSWUPD_NS_FCSWUPD::tenUpdState__NotReady:
		break;
	case FCSWUPD_NS_FCSWUPD::tenUpdState__SelectSource:
		m_strStatusText.assign("USB Format is not supported/USB device is not connected. Please connect the FAT32, exFAT (or) NTFS formatted USB Stick");
		TranslatedText = swuhmi_systemsettings_inf4cv::instance()->GetTranslationText(_statuswnd_messageId_NoUsb);
		bReturn = true;
		break;
	case FCSWUPD_NS_FCSWUPD::tenUpdState__SelectRelease:
		m_strStatusText.assign("Plug in the USB flash drive that contains the valid software installation files to proceed with the update. AVM, RVC and eCall functions will not be available.");
		//m_strDeviceId.assign(swuhmi_configurator_inf4cv::instance()->GetDeviceId());
		TranslatedText = swuhmi_systemsettings_inf4cv::instance()->GetTranslationText(_statuswnd_messageId);
		bReturn = true;
		break;
	case FCSWUPD_NS_FCSWUPD::tenUpdState__Config:
		m_strStatusText.clear();
		m_strStatusText.assign("Please plug in the USB flash drive to proceed with the software update.");
		TranslatedText = swuhmi_systemsettings_inf4cv::instance()->GetTranslationText(_statuswnd_usbinsertionId);
		bReturn = true;
		break;
	case FCSWUPD_NS_FCSWUPD::tenUpdState__Running:
		break;
	case FCSWUPD_NS_FCSWUPD::tenUpdState__MediumRemoved:
		m_strStatusText.clear();
                m_strStatusText.assign("The USB flash drive was disconnected. Please plug in the USB flash drive to proceed with the software update.");
                TranslatedText = swuhmi_systemsettings_inf4cv::instance()->GetTranslationText(_statuswnd_usbremovedId);
		bReturn = true;
                break;
	case FCSWUPD_NS_FCSWUPD::tenUpdState__Error:
		m_strStatusText.clear();
		if( isKDSOnlystick )
		{
                   m_strStatusText.assign("System configuration data file transfer has failed. Please enter the valid part number into the target.");
                   TranslatedText = swuhmi_systemsettings_inf4cv::instance()->GetTranslationText(_sysconfigstatuswnd_failureId);
		}
		else
		{
		   m_strStatusText.assign("Software update failed. System will reboot now.");
		   //m_strDeviceId.assign(swuhmi_configurator_inf4cv::instance()->GetDeviceId());
		   TranslatedText = swuhmi_systemsettings_inf4cv::instance()->GetTranslationText(_statuswnd_failureId);
		}
		bReturn = true;
		break;
	case FCSWUPD_NS_FCSWUPD::tenUpdState__Skipping:
		break;
	case FCSWUPD_NS_FCSWUPD::tenUpdState__Aborting:
		break;
	case FCSWUPD_NS_FCSWUPD::tenUpdState__Result:
		m_strStatusText.clear();
                if (swuhmi_configurator_inf4cv::instance()->GetUpdateResult()) {
                   if( isKDSOnlystick )
		   {
			ETG_TRACE_USR4(("nopartnumconfigured is exists:%d", swu::exists(partNumConfiguredMarker)));
			if(swu::exists(partNumConfiguredMarker))
			{
				m_strStatusText.assign("System configuration data file transfer has failed. Please enter the valid part number into the target.");
				TranslatedText = swuhmi_systemsettings_inf4cv::instance()->GetTranslationText(_sysconfigstatuswnd_failureId);
			}
			else
			{
				m_strStatusText.assign("System configuration data file transfer was successful. Please unplug the USB flash drive. System will restart");
				TranslatedText = swuhmi_systemsettings_inf4cv::instance()->GetTranslationText(_sysconfigstatuswnd_successId);
			}
		   }
		   else
		   {
			m_strStatusText.assign("Software Update successful. System will reboot now.");
			TranslatedText = swuhmi_systemsettings_inf4cv::instance()->GetTranslationText(_statuswnd_successId);
		   }
                }
                else {
		   if( isKDSOnlystick )
		   {
			m_strStatusText.assign("System configuration data file transfer has failed. Please enter the valid part number into the target.");
			TranslatedText = swuhmi_systemsettings_inf4cv::instance()->GetTranslationText(_sysconfigstatuswnd_failureId);
		   }
		   else
		   {
			m_strStatusText.assign("Software update failed. System will reboot now.");
			//m_strDeviceId.assign(swuhmi_configurator_inf4cv::instance()->GetDeviceId());
			TranslatedText = swuhmi_systemsettings_inf4cv::instance()->GetTranslationText(_statuswnd_failureId);
		   }
                }
		bReturn = true;
                break;

	case FCSWUPD_NS_FCSWUPD::tenUpdState__Reboot:
		break;
	default:
		break;
	}
	if(!TranslatedText.empty())
	{
		m_strStatusText.clear();
		m_strStatusText = TranslatedText;
		m_StatusLabel.SetTranslationStatus(true);
	}

	return bReturn;
}


}


