
/************************************************************************
*FILE					: swuhmi_configurator_inf4cv.cpp
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: Project HMI Configurator.
*DESCRIPTION			: This is master of swuhmi, it controls all the functionality.
*AUTHOR					: RRD7KOR (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2018	| 0.1		| RRD7KOR			| Initial
----------------------------------------------------------------------------

************************************************************************/

#include <algorithm>
#include "fcswupdatesrv/FcSwUpdateSrvJson.h"
#include "main/swuhmi_component.h"

#include "swuhmi_configurator_inf4cv.h"
#include "widgets/swuhmi_graphicsinterface_inf4cv.h"
#include "widgets/swuhmi_graphicsinterface.h"
#include "windows/swuhmi_statusupdatewnd_inf4cv.h"
#include "windows/swuhmi_recoveryupdatewnd_inf4cv.h"
#include "swuhmi_systemsettings_inf4cv.h"

#include "util/swu_configFactory.hpp"
#include "config/swuhmi_config.hpp"
#include "main/swuhmi_dataStore.h"

#define ETG_I_FILE_PREFIX swuhmi::swuhmi_configurator_inf4cv::instance()->

#include "util/swu_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TTFIS_CMD_PREFIX "SWUHMI_"
#define ETG_I_TRACE_CHANNEL    TR_TTFIS_SWUPDATE
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_HMI
#include "trcGenProj/Header/swuhmi_configurator_inf4cv.cpp.trc.h"
#endif

namespace swuhmi {

bool isKDSOnlystick = false;

swuhmi_configurator *poGetProjectSpecific() {
   return swuhmi_configurator_inf4cv::instance();
}

/************************************************************************
*FUNCTION			: swuhmi_configurator_inf4cv
*DESCRIPTION		: Constructor of inf4cv swuhmi Conifgurator.
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
----------------------------------------------------------------------------
26-05-2016	| 0.2		| RRD7KOR			| Showing DeviceId in HMI.CMG3G-10462.
************************************************************************/
swuhmi_configurator_inf4cv::swuhmi_configurator_inf4cv()
{
	ETG_I_REGISTER_FILE();
	m_pUpdateWindow 				= NULL;
	m_eCurrentHmiUpdateWnd			= INVALID_WND;
	m_eHMIState 					= FCSWUPD_NS_FCSWUPD::tenUpdState__Idle;

	m_u16FailedCount				= 255;
	m_s32RemainingTime				= -1;
	//m_onetimeTimer					= true;

	m_strDeviceId.clear();
}


/************************************************************************
*FUNCTION			: swuhmi_configurator_inf4cv
*DESCRIPTION		: Destructor of inf4cv swuhmi Conifgurator.
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
swuhmi_configurator_inf4cv::~swuhmi_configurator_inf4cv()
{
	// TODO Auto-generated destructor stub
	ETG_I_UNREGISTER_FILE();
	if(m_pUpdateWindow != NULL){
		delete m_pUpdateWindow;
		m_pUpdateWindow = NULL;
	}
}

/************************************************************************
*FUNCTION			: Initializeconfigurator
*DESCRIPTION		: Iniatialize the configurator
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
tVoid swuhmi_configurator_inf4cv::Initializeconfigurator()
{
  ETG_TRACE_USR4(("Initializeconfigurator"));

  swuhmi_systemsettings_inf4cv::instance()->DoSystemSettings();
  inf4cv_graphicsinterface::InitializeGraphics();
  graphicsinterface::CreateSurface();

  CreateFonts(swuhmi_systemsettings_inf4cv::instance()->_fontfilepath);
}

tVoid swuhmi_configurator_inf4cv::SetDelimiter(string strDelimiter) {

	ETG_TRACE_USR1(("SetDelimiter"));
	graphicsinterface::SetDelimiter(strDelimiter);
}

/************************************************************************
*FUNCTION			: vInit
*DESCRIPTION		: For ASF Message Subscribe
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
tVoid swuhmi_configurator_inf4cv::vInit()
{
	ETG_TRACE_USR4(("vInit"));
	std::string prjCfgFile="/opt/bosch/swupdate/fcswupdate/prjSwuHmiConfig.xml";
	ETG_TRACE_COMP(("ConfigPrj::check for swuhmi-cfg-file:%s", prjCfgFile.c_str()));
	if (swu::exists(prjCfgFile)) {
		   ETG_TRACE_COMP(("ConfigPrj::found swuhmi-cfg-file:%s", prjCfgFile.c_str()));
	      swu::setConfigXml(prjCfgFile, Config::instance(), DataStore::instance());
	}

	Msg_UpdateStateUpdate::vSubscribe(this);
	Msg_UpdateProgressUpdate::vSubscribe(this);
	Msg_UpdateErrorsUpdate::vSubscribe(this);

	if(m_pUpdateWindow == NULL)
	{
		CreateUpdateWnd(STATUS_UPDATE_WND);
		m_pUpdateWindow->vInit();
	}
	else
		m_pUpdateWindow->vInit();
}

/************************************************************************
*FUNCTION			: vInit
*DESCRIPTION		: For ASF Message Un-Subscribe.
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
tVoid swuhmi_configurator_inf4cv::vDeInit()
{
	Msg_UpdateStateUpdate::vUnSubscribe(this);
	Msg_UpdateProgressUpdate::vUnSubscribe(this);
	Msg_UpdateErrorsUpdate::vUnSubscribe(this);
}

/************************************************************************
*FUNCTION			: CreateUpdateWnd
*DESCRIPTION		: Creating the swuhmi Window
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
tVoid swuhmi_configurator_inf4cv::CreateUpdateWnd(E_HMIUPDATE_WND ehmiWnd)
{
	ETG_TRACE_COMP(("Current Update Wnd: %d", ETG_CENUM(E_HMIUPDATE_WND, ehmiWnd)));

	bool IsNewWnd = false;

	if(m_eCurrentHmiUpdateWnd != ehmiWnd || m_pUpdateWindow == 0) {

		ETG_TRACE_USR4(("Changing the Window"));

		if(m_pUpdateWindow != 0){
			m_pUpdateWindow->vDeInit();
			OSAL_DELETE m_pUpdateWindow;
			m_pUpdateWindow = 0;
		}

		m_eCurrentHmiUpdateWnd = ehmiWnd;
		if(m_eCurrentHmiUpdateWnd == STATUS_UPDATE_WND)
			m_pUpdateWindow = OSAL_NEW statusupdatewnd;
		else if(m_eCurrentHmiUpdateWnd == RECOVERY_UPDATE_WND)
			m_pUpdateWindow = OSAL_NEW recoveryupdatewnd;

		IsNewWnd = true;
	}

	if(m_pUpdateWindow != 0)
	{
		inf4cv_graphicsinterface::SwitchSurface();
		if(IsNewWnd)
			m_pUpdateWindow->vInit();
		m_pUpdateWindow->InitalizeWnd();
	}
}




/************************************************************************
 *FUNCTION		: vProcess
 *DESCRIPTION		: For Processing the Msg_UpdateStateUpdate ASF Message
 *PARAMETER			: Msg_UpdateStateUpdate (I)
 *PARAMETER				Info of State in Update
 *RETURNVALUE		: void
 *HISTORY:
 *Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
----------------------------------------------------------------------------
26-05-2016	| 0.2		| RRD7KOR			| Showing DeviceId in HMI.CMG3G-10462.
************************************************************************/
tVoid swuhmi_configurator_inf4cv::vProcess(Msg_UpdateStateUpdate *pMsg)
{
   ETG_TRACE_USR4(("Msg_UpdateStateUpdate"));

   FCSWUPD_NS_FCSWUPD::trUpdState const &UpdateState = SWU_ASF_GET_DATA(pMsg->payload, UpdateState);
   FCSWUPD_NS_FCSWUPD::tenUpdState eHMIState =  UpdateState.getEnState();

   if(!UpdateState.getTrain().empty() &&
      m_strTargetVersion.compare(UpdateState.getTrain()) != 0)
   {
      m_strTargetVersion.clear();
      m_strTargetVersion = UpdateState.getTrain();
   }

   if(!UpdateState.getHeadUnitId().empty() &&
      m_strDeviceId.compare(UpdateState.getHeadUnitId()) != 0){  //coverity fix
      m_strDeviceId.clear();
      m_strDeviceId = UpdateState.getHeadUnitId();
   }

   ETG_TRACE_COMP((" HMI State=%u", ETG_CENUM(FCSWUPD_NS_FCSWUPD::tenUpdState, eHMIState)));


   if(m_eHMIState != eHMIState)
   {
      m_eHMIState = eHMIState;
      switch(m_eHMIState)
      {
         case FCSWUPD_NS_FCSWUPD::tenUpdState__Idle:
            break;
         case FCSWUPD_NS_FCSWUPD::tenUpdState__NotReady:
            break;
         case FCSWUPD_NS_FCSWUPD::tenUpdState__Ready:
            m_eHMIState = FCSWUPD_NS_FCSWUPD::tenUpdState__SelectSource;
            CreateUpdateWnd(STATUS_UPDATE_WND);
            break;
         case FCSWUPD_NS_FCSWUPD::tenUpdState__SelectSource:
         case FCSWUPD_NS_FCSWUPD::tenUpdState__SelectRelease:
            CreateUpdateWnd(STATUS_UPDATE_WND);
            break;
         case FCSWUPD_NS_FCSWUPD::tenUpdState__Config:
            break;
         case FCSWUPD_NS_FCSWUPD::tenUpdState__Running:
            CreateUpdateWnd(RECOVERY_UPDATE_WND);
            break;
         case FCSWUPD_NS_FCSWUPD::tenUpdState__Error:
            CreateUpdateWnd(STATUS_UPDATE_WND);
            break;
         case FCSWUPD_NS_FCSWUPD::tenUpdState__MediumRemoved:
            CreateUpdateWnd(STATUS_UPDATE_WND);
            break;
         case FCSWUPD_NS_FCSWUPD::tenUpdState__Skipping:
            break;
         case FCSWUPD_NS_FCSWUPD::tenUpdState__Aborting:
            break;
         case FCSWUPD_NS_FCSWUPD::tenUpdState__Result:			
            SetUpdateResult((m_u16FailedCount == 0) ? true : false);
            CreateUpdateWnd(STATUS_UPDATE_WND);
            break;
         case FCSWUPD_NS_FCSWUPD::tenUpdState__Reboot:
            break;
      }
   }
}


/************************************************************************
*FUNCTION			: vProcess
*DESCRIPTION		: For Processing the Msg_UpdateProgressUpdate ASF Message
*PARAMETER			: Msg_UpdateProgressUpdate (I)
*PARAMETER				Info of Progress in Update
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
tVoid swuhmi_configurator_inf4cv::vProcess(Msg_UpdateProgressUpdate *pMsg)
{

	FCSWUPD_NS_FCSWUPD::trUpdProgress const &UpdateProgress = SWU_ASF_GET_DATA(pMsg->payload, UpdateProgress);

	ETG_TRACE_USR4(("Media Train:%s", UpdateProgress.getTrain().c_str()));

	if(!UpdateProgress.getTrain().empty() &&
			m_strMediaSWVersion.compare(UpdateProgress.getTrain()) != 0)
		m_strMediaSWVersion = UpdateProgress.getTrain();

	if(m_u16FailedCount != UpdateProgress.getU32NumFailed())
		m_u16FailedCount = static_cast<tU16>(UpdateProgress.getU32NumFailed());

	ETG_TRACE_USR4(("SubModule Name:%s", UpdateProgress.getSubModuleName().c_str()));
	ETG_TRACE_USR4(("getU32NumAll:%d", UpdateProgress.getU32NumAll()));
	ETG_TRACE_USR4(("isKDSOnlystick:%d", isKDSOnlystick));
	ETG_TRACE_USR4(("KDSDisplayTextEnabled is exists:%d", swu::exists(kdsDisplayTextMarker)));

	if( (UpdateProgress.getU32NumAll() == 1) && (!isKDSOnlystick) && (kdsSubModuleName.compare(UpdateProgress.getSubModuleName()) == 0) &&
            ( swu::exists(kdsDisplayTextMarker) ) )
	{
		isKDSOnlystick = true;
		ETG_TRACE_USR1(("swuhmi_configurator_inf4cv::vProcess Msg_UpdateProgressUpdate isKDSOnlystick = %u", isKDSOnlystick));
	}

}


/************************************************************************
*FUNCTION			: vProcess
*DESCRIPTION		: For Processing the Msg_UpdateErrorsUpdate ASF Message
*PARAMETER			: Msg_UpdateErrorsUpdate (I)
*PARAMETER				Info of Errors in Update
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
tVoid swuhmi_configurator_inf4cv::vProcess(Msg_UpdateErrorsUpdate *pMsg)
{
	ETG_TRACE_USR4(("Msg_UpdateErrorsUpdate"));

	printf("Msg_UpdateErrorsUpdate");

	FCSWUPD_NS_FCSWUPD::trErrorIds const &ErrorIds = SWU_ASF_GET_DATA(pMsg->payload, UpdateErrors);
	vector<FCSWUPD_NS_FCSWUPD::tenErrorId> t_ErrorId = ErrorIds.getErrorIds();

	ETG_TRACE_USR4(("Msg_UpdateErrorsUpdate, size:%d", t_ErrorId.size()));

	for (vector<FCSWUPD_NS_FCSWUPD::tenErrorId>::iterator Iter = t_ErrorId.begin() ; Iter != t_ErrorId.end(); Iter++)
	{
		ETG_TRACE_COMP(("Errors=%u", ETG_CENUM(FCSWUPD_NS_FCSWUPD::tenErrorId, *Iter)));
		if(*Iter == FCSWUPD_NS_FCSWUPD::tenErrorId__SWL_ERROR_MEDIA_UNAVAILABLE)
		{
			m_strTargetVersion.clear();
			m_strTargetVersion = m_strMediaSWVersion;
			break;
		}
	}
}


ETG_I_CMD_DEFINE((simChangeNextWindow, "simChangeNextWindow"))
void swuhmi_configurator_inf4cv::simChangeNextWindow()
{
	ETG_TRACE_COMP(("swuhmi_configurator_inf4cv::simChangeNextWindow START"));
	if(m_pUpdateWindow != NULL)
	{
		E_HMIUPDATE_WND eHMiWnd;
		m_pUpdateWindow->CloseWindow();
		if(m_eCurrentHmiUpdateWnd == STATUS_UPDATE_WND)
			eHMiWnd = RECOVERY_UPDATE_WND;
		else if(m_eCurrentHmiUpdateWnd == RECOVERY_UPDATE_WND)
			eHMiWnd = STATUS_UPDATE_WND;
		CreateUpdateWnd(eHMiWnd);
	}
	ETG_TRACE_COMP(("swuhmi_configurator_inf4cv::simChangeNextWindow STOP"));
}

}
