
/************************************************************************
*FILE					: swuhmi_carioadapter_inf4cv.cpp
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: Project Specific Cairo Adapter.
*DESCRIPTION			: In Addition to Common Functionality, added one's can be implemented.
*AUTHOR					: RRD7KOR (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2018	| 0.1		| RRD7KOR			| Initial
************************************************************************/

#include "swuhmi_carioadapter_inf4cv.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL 			TR_TTFIS_SWUPDATE
#define ETG_I_TTFIS_CMD_PREFIX 			"SWUHMI_LABEL_"
#define ETG_I_FILE_PREFIX 				SWUHMI::LABEL::
#define ETG_DEFAULT_TRACE_CLASS 		TR_CLASS_SWUPDATE_HMI
#include "trcGenProj/Header/swuhmi_carioadapter_inf4cv.cpp.trc.h"
#endif

inf4cv_carioadapter::inf4cv_carioadapter() {
	// TODO Auto-generated constructor stub

}

inf4cv_carioadapter::~inf4cv_carioadapter() {
	// TODO Auto-generated destructor stub
}

tVoid inf4cv_carioadapter::Drawinf4cvProgressBar(INF4CV_ProgressBarInfo stProgressBarInfo)
{
	ETG_TRACE_USR4(("Drawinf4cvProgressBar"));
	ETG_TRACE_USR4(("Progress Value:%f", stProgressBarInfo.fProgressVal));
     
	//Draw in the Surface
	if(!stProgressBarInfo.strBackGndImagePath.empty() && !stProgressBarInfo.strForeGndImagePath.empty() )
    {
		cairo_surface_t* pBackGndImage;
		pBackGndImage = cairo_image_surface_create_from_png(stProgressBarInfo.strBackGndImagePath.c_str());
		cairo_set_source_surface(m_pCairo, pBackGndImage, (tDouble)stProgressBarInfo.u16XPos, (tDouble)stProgressBarInfo.u16YPos);
		cairo_surface_destroy(pBackGndImage);
		cairo_paint(m_pCairo);
  
		tU32 u32ForeGndImgWidth = 0;
		if(stProgressBarInfo.fProgressVal > 0)
		{
			cairo_surface_t* pForeGndImage;
			cairo_save(m_pCairo);
			pForeGndImage = cairo_image_surface_create_from_png(stProgressBarInfo.strForeGndImagePath.c_str());
			u32ForeGndImgWidth = cairo_image_surface_get_width(pForeGndImage);
			cairo_translate(m_pCairo, (tDouble)stProgressBarInfo.u16XPos, (tDouble)stProgressBarInfo.u16YPos);
			cairo_scale(m_pCairo, (tDouble)stProgressBarInfo.fProgressVal, 1.0);
			u32ForeGndImgWidth = static_cast<uint32_t>((static_cast<float>(u32ForeGndImgWidth) * stProgressBarInfo.fProgressVal) - 7 );

			cairo_set_source_surface(m_pCairo, pForeGndImage, 0.0, 0.0);
			cairo_paint(m_pCairo);
			cairo_restore(m_pCairo);
			cairo_surface_destroy(pForeGndImage);
		}     
	}
       
}

