#ifndef FCSWUPD_PRJ_H
#define FCSWUPD_PRJ_H

// this file should only be included by source-files specific for MIB

#include "util/swu_memberList.hpp"
#include "main/fcswupd_mainMessages.hpp"
#include "main/fcswupd_main.h"
#include "main/fcswupd_component_inc.h"
#include "main/fcswupd_history.h"



namespace fcswupdate {

class ParserIf;
class LanguageIf;
class Msg_NotifyFlashingDone;
class Msg_NotifyDevManagerChanged;
class Msg_CopyProgressBarElements;

#define PROGRESSBAR_SRC_SLIDERHEADER    		"Progressbar_BaseSliderHeader.png"
#define PROGRESSBAR_SRC_ALPHASLIDER			"Progressbar_Alpha4SliderHeader.png"
#define PROGRESSBAR_SRC_TICKS				"Progressbar_21TicksProgressHeader.png"
#define PROGRESSBAR_SRC_POINTER				"Progressbar_PointerHeader.png"

#define PROGRESSBAR_DEST_SLIDERHEADER			"Progressbar_BackGround.png"
#define PROGRESSBAR_DEST_ALPHASLIDER			"Progressbar_ForeGround.png"
#define PROGRESSBAR_DEST_TICKS				"Progressbar_Measurement.png"
#define PROGRESSBAR_DEST_POINTER			"Progressbar_PointerHeader.png"


// this class has to be implemented project-specific
class FcSwUpdProject : public FcSwUpdProjectSpecific,
                           public swu::Singleton<FcSwUpdProject>
{
   friend class swu::Singleton<FcSwUpdProject>;

public:

   virtual tVoid vInitPrj();
   virtual tVoid vDeInitPrj();

     virtual const char *getName() {
        return "FcSwUpdProject";
     }
     virtual void traceState();

   virtual CtrlAdapter *pCreateCtrlAdapter(Ctrl *pCtrl, tenSwUpdateMode enMode);

   virtual tVoid vOnFcSwUpdState(tenSwUpdateState enState);
   virtual tVoid vOnSystemDataChanged();
   virtual tVoid vEnterRecoveryDownload();

   virtual ParserIf *createPrjParser(trSourceInfo sourceInfo);

   virtual tVoid vSetPrjState(tenPrjState enPrjState);
   // pure prj-specific interface
   tVoid vProcess(Msg_NotifyDevManagerChanged *pMsg);
   tVoid vProcess(Msg_CopyProgressBarElements *pMsg);

   // prj-specific asf-proxies
   swu::ProxyAccess< FcSwUpdateComponent, FCSWUPD_NS_FCSWUPD::FcSwUpdateSrvProxy > _fcSwUpdateProxy;

private:
   static const ::std::string PNG_SUFFIX() { return "png"; }

   FcSwUpdProject();
   swu::MemberList<FcSwUpdRoot> _memberList;
};


}
#endif
