/*******************************************************************************************
* FILE:			dl_V850MessageFactory.h
*
* SW-COMPONENT: Software Download
*
* DESCRIPTION: 
*				
*
* AUTHOR:		Aditya Kumar Jha
*
* COPYRIGHT:	(c) 2013  2014 Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
*********************************************************************************************
* HISTORY:
* ------------------------------------------------------------------------------------------------
* Date 				| Rev. 				| Author 		   	| Modification
* ------------------------------------------------------------------------------------------------
*				29.08.2013	Aditya Kumar Jha
*				Initial Version.
*				18.02.2014	Aditya Kumar Jha : Move define to seperate file dl_V850MessageDefine.h.
*               12.06.2014  Aditya Kumar Jha , Neera.K.Ponnappa : Implemented No CRC and No Reset
*               30.06.2014  Neera.K.Ponnappa : Implemented Security Bytes and Jtag ID
*              31.07.2014  Neera.K.Ponnappa : Lint Warnings solved
*              01.08.2014	Aditya Kumar Jha : IS1515_CRQ 4166-2: Prevention of: Linux root user can bypass 
*															 signature check of V850 code during software update.
*-----------------------------------------------------------------------------------------------------------------------
*  17-03-2015		| 2.1	| VRI7COB (RBEI)	| Implementation of Change Request From Lothar.
* 					|		|					| After BL Update & Reset is send, Poll V850 to Get the Response For Active Session
* 					|		|					| Polling has to be done with time period of 2 sec for 8 cycles.
* 					|		|					| New State Added: DL_SUCCESS_BL_STATE, DL_START_APP_UPDATE
*----------------------------------------------------------------------------------------------------------------------
* 23-03-2015		| 2.2	| VRI7COB (RBEI)	| Review Issues are corrected. & CMG3GB-860 is fixed.
* --------------------------------------------------------------------------------------------------------------------
* 19-02-2016		| 2.3	| VRI7COB (RBEI)	| Implementing the CRQ, CMG3G-9596
* --------------------------------------------------------------------------------------------------------------------
********************************************************************************************/

#ifndef _DL_V850MESSAGEFACTORY_H_
#define _DL_V850MESSAGEFACTORY_H_

#include<iostream>
#include<fstream>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
// for InterNodeCommunication:
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h> 
#include <sys/time.h>
#include <time.h>
#include <netinet/tcp.h>
#include <queue>
#include "ep_mainloop.h"

//#include <system_types.h>
#include "ai_osal_linux/components/system/system_types.h"
#include "ai_osal_linux/components/inc/inc.h"
#include "ai_osal_linux/components/inc/inc_ports.h"
#include "ai_osal_linux/components/inc/dgram_service.h"

#include "MessageQueue.h"

//Client Request messages
#define DL_REQUEST_INVALID									0x00
#define DL_REQUEST_START									0x01
#define DL_REQUEST_ABORT									0x02
#define DL_REQUEST_PROGRESS									0x03
#define DL_REQUEST_STATE									0x04
#define DL_REQUEST_BM_VERSION								0x05
#define DL_REQUEST_BL_VERSION								0x06
#define DL_REQUEST_APP_VERSION								0x07
#define DL_REQUEST_BM_CRC									0x08
#define DL_REQUEST_BL_CRC									0x09
#define DL_REQUEST_APP_CRC									0x0A
#define DL_REQUEST_ECU_RESET								0x0B
#define DL_REQUEST_SECURITY_ACCESS                          0x0C
#define DL_REQUEST_JTAG_ACCESS                              0x0D
#define DL_REQUEST_READ_SECURITY							0x0E
#define DL_DO_JTAGFINGERPRINT_VALIDATION					0x0F
#define DL_DO_STARTUP_SEQUENCE								0x10
#define DL_DO_SCC_RESET										0x11


//V850 Download Response message
#define DL_RESPONSE_RESULT									0x01
#define DL_RESPONSE_RECEIVED								0x02

//V850 Download State
#define	DL_UNKNOWN_STATE									0
#define	DL_INIT_STATE										1
#define	DL_VERIFY_STATE										2
#define	DL_SEQ_SETUP_STATE									3
#define	DL_TRANSFER_STATE									4
#define	DL_TRANSFER_DONE_STATE								5
#define	DL_TIMEOUT_STATE									6
#define	DL_ABORT_STATE										7
#define	DL_SUCCESS_STATE									8
#define	DL_FAILED_STATE										9
#define DL_SUCCESS_BL_STATE									10
#define DL_RETRY_STATE										11


#define USE_DGRAM_SERVICE
#define DEFAULT_MSGSZ										240
#define FILE_NAME_SIZE										256

#define BLOCK_SIZE											512
#define DATA_TRANSFER_SIZE									514 // Msg code(1 byte) + Block No.(1 byte) + Blocksize

#define FLASH_MAX_DEV										32     // max. supported devicetypes

#define INFO_LEVEL 1
#define INFO_LEVEL_1 1
#define INFO_LEVEL_2 2
#define INFO_LEVEL_3 3
#define INFO_ENABLED
#ifdef INFO_ENABLED
#define INFO_MSG(level, fmtstr, args...) \
	(level <= INFO_LEVEL) ? fprintf(stderr, "" fmtstr "\n", ##args) : 0;
#else
#define INFO_MSG(level, fmtstr, args...)
#endif

typedef struct
{ 
	tU16  Typ;                                               /* Typ of Header */
	tLong   Pos;                                     /* File position of Header */
	tULong Start;                                    /* Startaddress of Device */
	tULong Length;                                     /* Length of Data block */
	tULong CS;                                       /* Checksum of Data block */
} Flash_TYInfo;

typedef struct
{ 
	Flash_TYInfo Header[FLASH_MAX_DEV];
	tU8 Count;
} Flash_strTYInfo;

typedef enum
{
	E_JTAG_VALIDATION_INVALID = 0,
	E_JTAG_VALIDATION_NOTIMPLEMENTED,
	E_JTAG_VALIDATION_SUCCESS,
	E_JTAG_VALIDATION_FAILURE
}E_JTAG_VALIDATION_RESULT;


class dl_tclV850MessageFactory
{

public:
	dl_tclV850MessageFactory();
	virtual ~dl_tclV850MessageFactory();

	tU32 u32PackDownloadRequestPacket( tCString commandStr, tString pTempBuf, tU32 tempBufSize, tU32 u32BinaryFileSize, tU32 u32Address ) const;
	tU32 u32PackCmdPacket( tCString strCmdPac, tString pTempBuf, tU32 tempBufSize ) const;
	tU32 u32ReadBinaryFile( FILE *fp, char * pcTempBuff , tU32 u32BytesToRead ) const;
	tU32 u32GetFileSize( tCString pcTempFileName ) const;
	static tU32 u32ArgToPayload( tString buffer, tU32 u32BufLen, tCString strArgPayLoad );
	tVoid vHexDump(tCString intro, tString buffer, tU32 u32Len) const;
	tULong DFInfo_ulwInit(FILE *DF_file,Flash_strTYInfo *Info);
	tULong u32GetFileLen(Flash_strTYInfo *Info, tU16 Typ) const;
	tULong u32GetMemoryAddress(Flash_strTYInfo *Info, tU16 Typ) const;
	tInt iReadBinaryDataPtr(FILE *DF_file, Flash_strTYInfo *Info, tU16 Typ) const;
	tU32 u32PackSecuritySignReqPacket( tCString commandStr, tString pTempBuf, tString pTempDataBuf, tU32 tempBufSize, tU32 u32BinaryFileSize ) const;
	tU32 u32GetRSASignature (FILE *DF_file, Flash_strTYInfo *Info, tString pTempBuf, tU32 MemBlock);
	tU8 u8GetBlockIndex ( Flash_strTYInfo *Info, tU32 Typ);
	tU32 u32GetRSAOffset ( FILE *DF_file, tU32 u32SIBLen);
	tU32 u8GetRSAStartPos( FILE *DF_file, tU32 u32RSAMaxLen, tU32 &u32BlockLen, tU32 MemBlock);
	tVoid vPrintTimeStamp(tVoid) const;

   //std::fstream  myStream;

	tVoid vEnableDisableDebugTraces(tBool _bStatus) { m_bDebugTraceStatus = _bStatus; }

private:
	tBool m_bDebugTraceStatus;
	void vSet_at( tString pTempBuf, tU32 &start_pos, tU32 data_in, tU32 data_size) const;


};

#endif // _DL_V850MESSAGEFACTORY_H_

