/*******************************************************************************************
* FILE:			dl_V850MessageDefine.h
*
* SW-COMPONENT: Software Download
*
* DESCRIPTION: 
*				
*
* AUTHOR:		Aditya Kumar Jha
*
* COPYRIGHT:	(c) 2013  2014 Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
*********************************************************************************************
* HISTORY:
*				12.02.2014	Aditya Kumar Jha
*				Initial Version.Active
*           21.05.2014	Aditya Kumar Jha 
*				Added new defines.
*           30.06.2014  Neera.K.Ponnappa : Implemented Security Bytes and Jtag ID
*           01.08.2014	Aditya Kumar Jha : IS1515_CRQ 4166-2: Prevention of: Linux root user can bypass 
*														 signature check of V850 code during software update.
** --------------------------------------------------------------------------------------------------------------------
* 19-02-2016		| 2.3	| VRI7COB (RBEI)	| Implementing the CRQ, CMG3G-9596
* --------------------------------------------------------------------------------------------------------------------
********************************************************************************************/

#ifndef _DL_V850MESSAGEDEFINE_H_
#define _DL_V850MESSAGEDEFINE_H_

// UDS message definitions
//Request message
//Request message Diagnostic Session Control
#define MSG_TX_DIAG_SESS_CTRL_DEF 						"10-01"				// Default session, normal operation
#define MSG_TX_DIAG_SESS_CTRL_PRG 						"10-02"				// Programming mode
#define MSG_TX_DIAG_SESS_CTRL_EXT 						"10-03"				// Extended session mode
#define MSG_TX_DIAG_SESS_CTRL_BTL 						"10-60"				// Bootloader mode

//Request message Read Data By Identifier
#define MSG_TX_READ_DATA_IDENTI_STATE 					"22-f1-00"			// Read active session state
#define MSG_TX_READ_DATA_IDENTI_VER_PRG 				"22-f1-86"			// Verify programming session

#define MSG_RX_READ_VER_BYTE_1							22
#define MSG_RX_READ_VER_BYTE_2							25
#define MSG_RX_READ_VER_BYTE_3							15
#define MSG_RX_READ_VER_BYTE_MAX							40
#define MSG_RX_READ_VER_OFFSET							10

//boot manager:
#define MSG_TX_READ_DATA_IDENTI_BM_BUILD_USER      "22-25-10"
#define MSG_TX_READ_DATA_IDENTI_BM_TIMESTAMP       "22-25-11"
#define MSG_TX_READ_DATA_IDENTI_BM_LABEL           "22-25-12"
#define MSG_TX_READ_DATA_IDENTI_BM_BOSCH_NUMBER    "22-25-13"
#define MSG_TX_READ_DATA_IDENTI_BM_OEM_NUMBER      "22-25-14"
#define MSG_TX_READ_DATA_IDENTI_BM_VERSION         "22-25-15"
#define MSG_TX_READ_DATA_IDENTI_BM_USER1           "22-25-16"
#define MSG_TX_READ_DATA_IDENTI_BM_USER2           "22-25-17"
#define MSG_TX_READ_DATA_IDENTI_BM_FGIU_ID         "22-25-18"
#define MSG_TX_READ_DATA_IDENTI_BM_ID_STRING       "22-25-19"

//boot loader:
#define MSG_TX_READ_DATA_IDENTI_BL_BUILD_USER      "22-25-20"
#define MSG_TX_READ_DATA_IDENTI_BL_TIMESTAMP       "22-25-21"
#define MSG_TX_READ_DATA_IDENTI_BL_LABEL           "22-25-22"
#define MSG_TX_READ_DATA_IDENTI_BL_BOSCH_NUMBER    "22-25-23"
#define MSG_TX_READ_DATA_IDENTI_BL_OEM_NUMBER      "22-25-24"
#define MSG_TX_READ_DATA_IDENTI_BL_VERSION         "22-25-25"
#define MSG_TX_READ_DATA_IDENTI_BL_USER1           "22-25-26"
#define MSG_TX_READ_DATA_IDENTI_BL_USER2           "22-25-27"
#define MSG_TX_READ_DATA_IDENTI_BL_FGIU_ID         "22-25-28"
#define MSG_TX_READ_DATA_IDENTI_BL_ID_STRING       "22-25-29"

//application:
#define MSG_TX_READ_DATA_IDENTI_APP_BUILD_USER      "22-25-30"
#define MSG_TX_READ_DATA_IDENTI_APP_TIMESTAMP       "22-25-31"
#define MSG_TX_READ_DATA_IDENTI_APP_LABEL           "22-25-32"
#define MSG_TX_READ_DATA_IDENTI_APP_BOSCH_NUMBER    "22-25-33"
#define MSG_TX_READ_DATA_IDENTI_APP_OEM_NUMBER      "22-25-34"
#define MSG_TX_READ_DATA_IDENTI_APP_VERSION         "22-25-35"
#define MSG_TX_READ_DATA_IDENTI_APP_USER1           "22-25-36"
#define MSG_TX_READ_DATA_IDENTI_APP_USER2           "22-25-37"
#define MSG_TX_READ_DATA_IDENTI_APP_FGIU_ID         "22-25-38"
#define MSG_TX_READ_DATA_IDENTI_APP_ID_STRING       "22-25-39"

#define MSG_TX_READ_DATA_IDENTI_BM_CRC 				"22-25-50"			// Read Boot Manager Checksum
#define MSG_TX_READ_DATA_IDENTI_BL_CRC 				"22-25-51"			// Read Boot loader Checksum
#define MSG_TX_READ_DATA_IDENTI_APP_CRC 				"22-25-52"			// Read Application Checksum

//Request message for Security Access
#define MSG_TX_SECURITY_ACCESS                          0x67
#define MSG_TX_SECURITY_ACCESS_SEED						"27-11-FF-FF-FF-FF"	// Request seed															
#define MSG_TX_SECURITY_ACCESS_SEND_KEY				"27-12-01-02-03-04-01-02-03-04-01-02-03-04-01-02-03-04-01-02-03-04-01-02-03-04-01-02-03-04-01-02-03-04"		

//Request message for Write Data By Identifier
#define MSG_TX_WRITE_DATA_IDENTI_FPRINT				"2E-F1-5A-13-03-01-8F-00-00-00-00-00-00-00-00-00"		// Write fingerprint
#define MSG_TX_WRITE_DATA_IDENTI_SECURITY_SIGN		"2E-25-F0"  // Write Security signature

//Request message
#define MSG_TX_ROUTINE_CTRL								"31-00"				// flash erase, check memory, etc.														
#define MSG_TX_ROUTINE_CTRL_ERASE_MEM					"31-01-FF-00-02-40-00-01-FF-00-06"			// Erase memory

#define MSG_TX_REQUEST_DNL									"34-00-44"		// Request download
#define MSG_TRANSF_DATA										"36-00"		    	// Transfer data
#define MSG_TX_TRANSF_DATA									0x36		    	// Transfer data
#define MSG_TX_REQUEST_TRANSF_EXIT						"37"				// Transfer exit
#define MSG_TX_ECU_RESET									"11-01"				// ECU reset

//Response message
//Response for Diagnostic Session Control
#define MSG_RX_DIAG_SESS_CTRL								0x50
#define MSG_RX_DIAG_SESS_CTRL_DEF 						0x01
#define MSG_RX_DIAG_SESS_CTRL_PRG 						0x02
#define MSG_RX_DIAG_SESS_CTRL_EXT 						0x03
#define MSG_RX_DIAG_SESS_CTRL_BTL 						0x60

//Response for Read Data By Identifier
#define MSG_RX_READ_DATA_IDENTI								0x62

#define MSG_RX_READ_DATA_IDENTI_STATE1 					0xF1
#define MSG_RX_READ_DATA_IDENTI_STATE2 					0x00

#define MSG_RX_READ_DATA_IDENTI_PRG_STATE 				0x02

#define MSG_RX_READ_DATA_IDENTI_PS_STATE_LOCKED			0x01
#define MSG_RX_READ_DATA_IDENTI_PS_STATE_UNLOCKED		0x02
#define MSG_RX_READ_DATA_IDENTI_PS_STATE_FPW				0x03
#define MSG_RX_READ_DATA_IDENTI_PS_STATE_ME				0x04
#define MSG_RX_READ_DATA_IDENTI_PS_STATE_ME_FAILED		0x44
#define MSG_RX_READ_DATA_IDENTI_PS_STATE_DS				0x05
#define MSG_RX_READ_DATA_IDENTI_PS_STATE_TD				0x06
#define MSG_RX_READ_DATA_IDENTI_PS_STATE_TD_FAILED		0x46
#define MSG_RX_READ_DATA_IDENTI_PS_STATE_DNL_FINISH	0x07
#define MSG_RX_READ_DATA_IDENTI_PS_STATE_MC				0x08
#define MSG_RX_READ_DATA_IDENTI_PS_STATE_MC_FAILED    0x48
#define MSG_RX_READ_DATA_IDENTI_PS_STATE_PDC				0x09
#define MSG_RX_READ_DATA_IDENTI_PS_STATE_PDC_FAILED   0x49


#define MSG_RX_READ_DATA_IDENTI_DEF_STATE 			0x01

#define MSG_RX_READ_DATA_IDENTI_DS_STATE		 		0x00
#define MSG_RX_READ_DATA_IDENTI_DS_STATE_APP	 		0x61

#define MSG_RX_READ_DATA_IDENTI_VER_PRG1 				0xF1
#define MSG_RX_READ_DATA_IDENTI_VER_PRG2 				0x86
#define MSG_RX_READ_DATA_IDENTI_VER_PRG3 				0x02

#define MSG_RX_READ_DATA_IDENTI_CRC_AND_VERSION 	0x25

#define MSG_RX_READ_DATA_IDENTI_BM_BUILD_USER      0x10
#define MSG_RX_READ_DATA_IDENTI_BM_TIMESTAMP       0x11
#define MSG_RX_READ_DATA_IDENTI_BM_LABEL           0x12
#define MSG_RX_READ_DATA_IDENTI_BM_BOSCH_NUMBER    0x13
#define MSG_RX_READ_DATA_IDENTI_BM_OEM_NUMBER      0x14
#define MSG_RX_READ_DATA_IDENTI_BM_VERSION         0x15
#define MSG_RX_READ_DATA_IDENTI_BM_USER1           0x16
#define MSG_RX_READ_DATA_IDENTI_BM_USER2           0x17
#define MSG_RX_READ_DATA_IDENTI_BM_FGIU_ID         0x18
#define MSG_RX_READ_DATA_IDENTI_BM_ID_STRING       0x19

//boot loader:
#define MSG_RX_READ_DATA_IDENTI_BL_BUILD_USER      0x20
#define MSG_RX_READ_DATA_IDENTI_BL_TIMESTAMP       0x21
#define MSG_RX_READ_DATA_IDENTI_BL_LABEL           0x22
#define MSG_RX_READ_DATA_IDENTI_BL_BOSCH_NUMBER    0x23
#define MSG_RX_READ_DATA_IDENTI_BL_OEM_NUMBER      0x24
#define MSG_RX_READ_DATA_IDENTI_BL_VERSION         0x25
#define MSG_RX_READ_DATA_IDENTI_BL_USER1           0x26
#define MSG_RX_READ_DATA_IDENTI_BL_USER2           0x27
#define MSG_RX_READ_DATA_IDENTI_BL_FGIU_ID         0x28
#define MSG_RX_READ_DATA_IDENTI_BL_ID_STRING       0x29

//application:
#define MSG_RX_READ_DATA_IDENTI_APP_BUILD_USER     0x30
#define MSG_RX_READ_DATA_IDENTI_APP_TIMESTAMP      0x31
#define MSG_RX_READ_DATA_IDENTI_APP_LABEL          0x32
#define MSG_RX_READ_DATA_IDENTI_APP_BOSCH_NUMBER   0x33
#define MSG_RX_READ_DATA_IDENTI_APP_OEM_NUMBER     0x34
#define MSG_RX_READ_DATA_IDENTI_APP_VERSION        0x35
#define MSG_RX_READ_DATA_IDENTI_APP_USER1          0x36
#define MSG_RX_READ_DATA_IDENTI_APP_USER2          0x37
#define MSG_RX_READ_DATA_IDENTI_APP_FGIU_ID        0x38
#define MSG_RX_READ_DATA_IDENTI_APP_ID_STRING      0x39

#define MSG_RX_READ_DATA_IDENTI_BM_CRC 				0x50
#define MSG_RX_READ_DATA_IDENTI_BL_CRC 				0x51
#define MSG_RX_READ_DATA_IDENTI_APP_CRC 				0x52

//Response for Write Data By Identifier
#define MSG_RX_WRITE_DATA_IDENTI						0x6E
#define MSG_RX_WRITE_DATA_IDENTI_FPRINT1				0xF1
#define MSG_RX_WRITE_DATA_IDENTI_FPRINT2				0x5A

#define MSG_RX_WRITE_DATA_IDENTI_SIGN1					0x25
#define MSG_RX_WRITE_DATA_IDENTI_SIGN2					0xF0
#define MSG_RX_WRITE_DATA_IDENTI_SIGN3					0x83
				

//Response for Security Access
#define MSG_RX_SECURITY_ACCESS							0x67
#define MSG_RX_SECURITY_ACCESS_SEED						0x11
#define MSG_RX_SECURITY_ACCESS_SEND_KEY					0x12

//Response for Reuest download
#define MSG_RX_REQUEST_DNL								0x74
#define MSG_RX_REQUEST_DNL1								0x20

//Response for transfer Data
#define MSG_RX_TRANSF_DATA								0x76

//Response for transfer Exit
#define MSG_RX_REQUEST_TRANSF_EXIT						0x77

//Response for ECU Reset
#define MSG_RX_ECU_RESET								0x51

//Response for Routine Control
#define MSG_RX_ROUTINE_CTRL								0x71
#define MSG_RX_ROUTINE_CTRL_ERASE_MEM1					0x01
#define MSG_RX_ROUTINE_CTRL_ERASE_MEM2					0xFF
#define MSG_RX_ROUTINE_CTRL_ERASE_MEM3					0x00
#define MSG_RX_ROUTINE_CTRL_ERASE_MEM4					0x00

//Negative Response
#define MSG_NEG_RX										0x7f

#define MSG_NEG_RX_NOT_SUPPORT							0x12
#define MSG_NEG_RX_INVALID_FORMAT						0x13
#define MSG_NEG_RX_LONG_RESP							0x14
#define MSG_NEG_RX_COND_NOT_CORRECT						0x22
#define MSG_NEG_RX_REQ_SEQ_ERROR						0x24
#define MSG_NEG_RX_REQ_OUT_OF_RANGE						0x31
#define MSG_NEG_RX_ACCESS_DENIED						0x33
#define MSG_NEG_RX_INVALID_KEY							0x35
#define MSG_NEG_RX_EXCEED_ATTEMPTS						0x36
#define MSG_NEG_RX_TIMEDELAY_NOT_EXP					0x37
#define MSG_NEG_RX_UPLOAD_DL_NOT_ACCEPT					0x70
#define MSG_NEG_RX_TRANS_DATA_SUSPEND					0x71
#define MSG_NEG_RX_PROG_FAILURE							0x72
#define MSG_NEG_RX_SEQ_COUNTER							0x73
#define MSG_NEG_RX_VOLTAGE_ERROR1						0x92
#define MSG_NEG_RX_VOLTAGE_ERROR2						0x93
#define MSG_NEG_RX_JTAG_ERROR1							0x2E

//Positive Response
#define MSG_POSITIVE_RX_LOWER_BYTE						0x78
#define MSG_POSITIVE_RX_HIGHER_BYTE						0x7f

//Security Access 
#define MSG_TX_SECURITY_BYTE                            "2E-25-80-"

//Security Access Response

//#define MSG_RX_SEC_MAX_VAL                            0x1f
#define MSG_RX_READ_SEC_PROTECT_BYTE                  "22-25-80"
#define MSG_RX_READ_SECURITY_DATA                       0x25 
#define MSG_RX_READ_SECURITY_DATA_BYTE                  0x80
#define MSG_RX_READ_JTAG_DATA_BYTE                  	0x81


#define MSG_RX_SEC_BOOT_BLOCK_ERASE                 0x01      
#define MSG_RX_SEC_BLOCK_ERASE                      0x02     
#define MSG_RX_SEC_CHIP_ERASE                       0x04     
#define MSG_RX_SEC_WRITE_PROC                       0x08     
#define MSG_RX_SEC_READ_PROC                        0x10   
#define MSG_RX_SEC_INVALID_SECURITY					0xFF

//JTAG Access
#define MSG_TX_JTAG_BYTE				  "2E-25-81"
#define MSG_RX_READ_JTAG_PROTECT_BYTE     "22-25-81"
#define MSG_TX_VALIDATE_JTAG_BYTES		  "2E-25-83"

#endif // _DL_V850MESSAGEDEFINE_H_
