/*******************************************************************************************
* FILE:			dl_IncSender.cpp
*
* SW-COMPONENT:Software Download
*
* DESCRIPTION:	This file sends the message packet to the open port over INC driver.
*				
*
* AUTHOR:		Aditya Kumar Jha
*
* COPYRIGHT:	(c) 2013  2014 Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
*********************************************************************************************
* HISTORY:
* ------------------------------------------------------------------------------------------------
* Date 				| Rev. 	 | Author 		   	| Modification
* ------------------------------------------------------------------------------------------------
*					29.08.2013	Aditya Kumar Jha
*					Initial Version.
*					18.02.2014	Aditya Kumar Jha : Change for new trace class TR_CLASS_SWUPDATE_V850.
*              02.07.2014  Neera.K.Ponnappa : Replaced _exit with OSAL_vSetProcessExitCode() & OSAL_vProcessExit()
*					16.09.2014	Aditya Kumar Jha : Fixes for Jira ticket CMG3GB-1128.
*---------------------------------------------------------------------------------------------------
* 12-03-2015		| 2.0	| VRI7COB (RBEI)	| Enabling TTFI's Traces;Ticket Number:CMG3GB-1324
*---------------------------------------------------------------------------------------------------
********************************************************************************************/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "ai_sw_update/common/base/imp/swupd_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
  	#define ETG_I_TRACE_CHANNEL 			TR_TTFIS_SWUPDATE_CTRL
	#define ETG_I_TTFIS_CMD_PREFIX 			"DNL_"
	#define ETG_I_FILE_PREFIX 				dl_tclIncSender::
    #define ETG_DEFAULT_TRACE_CLASS 		TR_CLASS_SWUPDATE_V850
	#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_V850
  #include "trcGenProj/Header/dl_IncSender.cpp.trc.h"
#endif

#include <sys/time.h>
#include "dl_IncSender.h"

// OSAL types are required for Datapool
#define OSAL_S_IMPORT_INTERFACE_TYPES
#include "osal_if.h"

/*******************************************************************************************
* FUNCTION:		dl_tclIncSender
* DESCRIPTION:	Private Constructor
* PARAMETER:
*					NULL
*				
*
* RETURNVALUE:	Void
*
* HISTORY:
*					29.08.2013	Aditya Kumar Jha
*	d				Initial Version.
*					12-03-2015 VRI7COB (RBEI)
********************************************************************************************/
dl_tclIncSender::dl_tclIncSender()
{
}


/*******************************************************************************************
* FUNCTION:		~dl_tclIncSender
* DESCRIPTION:	Destructor
* PARAMETER:
*					NULL
*				
*
* RETURNVALUE:	Void
*
* HISTORY:
*					29.08.2013	Aditya Kumar Jha
*					Initial Version.
*					12-03-2015 VRI7COB (RBEI)
********************************************************************************************/
dl_tclIncSender::~dl_tclIncSender()
{
}

/*******************************************************************************************
* FUNCTION:		s32WriteCommandPacket
* DESCRIPTION:	This function write a command packet to the port over INC driver.
* PARAMETER:
*					sk_dgram * localDatagram
*					tString pTempBuf [command packet]
*					tU64 tempBufSize [Size of packet]
*				
*
* RETURNVALUE:	tS32 //byte written
*
* HISTORY:
*					29.08.2013	Aditya Kumar Jha
*					Initial Version.
********************************************************************************************/
tS32 dl_tclIncSender::s32WriteCommandPacket( sk_dgram * localDatagram, tString pTempBuf, tU32 tempBufSize ) const
{
	tCString method = "s32WriteCommandPacket";
	ETG_TRACE_USR4 (("%s was entered", method));

	tS32 s32ByteWritten = -1;

	if ( NULL != localDatagram )
	{
		//Write Command to the port
		s32ByteWritten = (tS32)(ssize_t )(dgram_send(localDatagram, pTempBuf, tempBufSize));

		if (s32ByteWritten < 0) 
		{
			ETG_TRACE_USR4(("DNL: ERROR writing to socket"));
			perror("ERROR writing to socket"); 
		}
	}

	ETG_TRACE_USR4 (("%s was left", method));

	return s32ByteWritten;
}

/*******************************************************************************************
* FUNCTION:		bWriteDataPacket
* DESCRIPTION:	This function write a binary data packet to the port over INC driver.
* PARAMETER:
*					tS32 s32LocalSockFD,
*				   tString bytes,
*					tU32 u32Length
*
* RETURNVALUE:	BOOL
*
* HISTORY:
*					29.08.2013	Aditya Kumar Jha
*					Initial Version.
********************************************************************************************/
tBool dl_tclIncSender::bWriteDataPacket( tS32 s32LocalSockFD, tString bytes, tU32 u32Length ) const
{
	tCString method = "bWriteDataPacket";
	ETG_TRACE_USR4 (("%s was entered", method));

	tU32 u32ByteWritten = 0;
	tBool bRetVal = false;

	if ( NULL != bytes )
	{
		//Write data to the port
		u32ByteWritten = (tU32)(ssize_t)write(s32LocalSockFD, bytes, u32Length);
		if ( u32ByteWritten != u32Length ) 
		{
			ETG_TRACE_USR4(("DNL: ERROR writing to socket"));
			perror("ERROR writing to socket"); 			
		}
		else
		{
			bRetVal = true;
		}
	}

	ETG_TRACE_USR4 (("%s was left", method));

	return bRetVal;
}

/*******************************************************************************************
* FUNCTION:		error
* DESCRIPTION:	log the error and exit the program execution.
*					
* PARAMETER:
*					tCString
*				
*
* RETURNVALUE:	Void
*
* HISTORY:
*					29.08.2013	Aditya Kumar Jha
*					Initial Version.
********************************************************************************************/
tVoid dl_tclIncSender::error( tCString msg ) const
{
    perror( msg );
	OSAL_vSetProcessExitCode(2);
    OSAL_vProcessExit();
}
