#ifndef SWU_XML_ITEM_H
#define SWU_XML_ITEM_H

#include "tinyxml/tinyxml.h"
#include "util/swu_types.h"
#include "util/swu_util.hpp"

namespace swu {
class XmlItemContainer;
class XmlItemBase {
   friend class XmlItemContainer;

 protected:
   XmlItemBase(XmlItemContainer *itemContainer, std::string key);

   void store(TiXmlElement *xmlRoot, std::string val);

   void restore(TiXmlElement *xmlRoot, std::string &val);
   void store(TiXmlElement *xmlRoot, tUInt val);
   void restore(TiXmlElement *xmlRoot, tUInt &val);
   void traceVal(tUInt const &val, char const *action) const;
   void traceVal(std::string const &val, char const *action) const;

   virtual void store(TiXmlElement *xmlRoot)=0;
   virtual void restore(TiXmlElement *xmlRoot)=0;


public:
   std::string const &getKey();
   void traceVal() const {traceVal("");};
   virtual void traceVal(char const *action) const =0;
 private:
   std::string _key;
};


template<class STORAGE, class VAL=STORAGE>
class XmlItem:public XmlItemBase {
   friend class XmlItemContainer;
public:
   XmlItem(XmlItemContainer *itemContainer, std::string key, VAL val):
      XmlItemBase(const_cast<XmlItemContainer *>(itemContainer), key),
      _val(val)
   {}
   void set(VAL val) {
      XmlItemBase::traceVal((STORAGE)_val, "set");
      _val=val;
   }
   VAL const &get() const {
      XmlItemBase::traceVal((STORAGE)_val, "get");
      return _val;
   }
   virtual void store(TiXmlElement *xmlRoot) {
      XmlItemBase::store(xmlRoot, (STORAGE)_val);
   }
   virtual void restore(TiXmlElement *xmlRoot) {
      STORAGE tmp=(STORAGE)_val;
      XmlItemBase::restore(xmlRoot, tmp);
      _val=(VAL)tmp;
   }
   virtual void traceVal(char const *action) const{
      XmlItemBase::traceVal(_val, action);
   }

private:
   VAL _val;
};

class XmlItemContainer {
protected:
   XmlItemContainer() {};


public:
   void registerItem(XmlItemBase *item);

   void store(TiXmlElement *xmlRoot);
   void restore(TiXmlElement *xmlRoot);
private:
   std::map<std::string, XmlItemBase *> _items;
};


#if 0
// usage:
MyXmlContainer:swu::XmlContainer {
   MyXmlContainer():
      testInt(this, "TEST_INT", 42),
      testString(this, "TEST_STRING", "My test string content")
      {}
}

XmlItem<tUInt> testInt;
XmlItem<std::string> testString;

#endif
}

#endif
