#ifndef SWU_XML_DOC_H
#define SWU_XML_DOC_H

#include "tinyxml/tinyxml.h"
#include "util/swu_types.h"
#include "util/swu_robustFile.h"

namespace swu {
/*
  class to "hack" tiny-xml.
  We want to pull a node out of a doc without deleting it.
  Everything is private.
  Only purpose is to be called by Swu_UnlinkNode()
*/
class Swu_TiXmlNode: public TiXmlNode {
   friend TiXmlNode *Swu_UnlinkNode(TiXmlNode *);

private:
   TiXmlNode *StealChild(TiXmlNode *stealThis_);

   static TiXmlNode *StealChild(TiXmlNode *parent_, TiXmlNode *child);
};

/*
  utility to steal a node from an TiXmlDocument
*/
inline TiXmlNode *Swu_UnlinkNode(TiXmlNode *child) {
   return Swu_TiXmlNode::StealChild(child->Parent(), child);
}


inline TiXmlElement *moveElem(TiXmlElement *elem, TiXmlElement *to) {

   if(!elem || !to){
      return 0;
   }

  TiXmlElement* tmp = Swu_UnlinkNode(elem)->ToElement();
  to->LinkEndChild(tmp);
  return elem;
}

/*
  utility to connect a xml-document to a file.
*/
class XmlFile {
public:
//   XmlFile(std::string path, std::string name, TiXmlDocument *xmlDoc);

//   XmlFile(std::string name, TiXmlDocument *xmlDoc);

   XmlFile(std::string name);

   ~XmlFile();

   bool store();

   bool restore();

   bool remove();

   bool exists();

   static XmlFile *create(std::string name);

   TiXmlDocument &getXmlDoc() {
      return _xmlDoc;
   }
   TiXmlElement *getXmlRoot(char const *rootName=0) {
      if (rootName) {
         return _xmlDoc.FirstChildElement(rootName);
      }
      else {
         return _xmlDoc.FirstChildElement();
      }
   }
   TiXmlDocument const &getConstXmlDoc() const {
      return _xmlDoc;
   }

   inline const std::string &file_path() {
#ifndef __SW_UPDATE_UNIT_TESTING__
      return _robustFile.file_path();
#else
	  return 0;
#endif
   }

   bool isValid() {
      return _loaded;
   }

   TiXmlDocument _xmlDoc;
private:
#ifndef __SW_UPDATE_UNIT_TESTING__
   RobustFile _robustFile;
#endif
   std::string _name;
   bool _loaded;
};
}

#endif
