/*
 * swu_xmlDoc.cpp
 *
 *  Created on: Oct 15, 2013
 *      Author: efs1hi
 */
#include "util/swu_filesystem.h"
#include "swu_xmlDoc.h"

#include "util/swu_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_UTIL
#include "trcGenProj/Header/swu_xmlDoc.cpp.trc.h"
#endif

using namespace std;

namespace swu {


XmlFile::XmlFile(string name) :
   _name(name),
   _robustFile(name),
   _loaded(false)
{
  _robustFile.init();
}


XmlFile::~XmlFile() {
}

bool XmlFile::store() {
   ETG_TRACE_USR1(("RobustFile::store(%100s) loaded=%u START", _name.c_str(), _loaded));
   _loaded = _xmlDoc.SaveFile(_robustFile.file_path().c_str());
   SWU_ASSERT_RETURN_FALSE(_loaded);
   _loaded = _robustFile.sync();
   SWU_ASSERT_RETURN_FALSE(_loaded);
   return _loaded;

}

bool  XmlFile::restore() {
   ETG_TRACE_USR1(("RobustFile::restore(%100s) loaded=%u START", _name.c_str(), _loaded));
   if (_loaded) {
      return true;
   }
   if (!_robustFile.restore()) {
      _robustFile.remove();
      return false;
   }
   _loaded=_xmlDoc.LoadFile(_robustFile.file_path().c_str());
   ETG_TRACE_USR1(("RobustFile::restore(%100s) loaded=%u END", _name.c_str(), _loaded));
   return _loaded; 
}

bool XmlFile::remove() {
   ETG_TRACE_USR1(("RobustFile::remove(%100s) loaded=%u START", _name.c_str(), _loaded));
   _xmlDoc=TiXmlDocument();
   _loaded=false;
   bool res=_robustFile.remove();
   ETG_TRACE_USR1(("RobustFile::remove(%100s) loaded=%u END", _name.c_str(), _loaded));
   return res;
}

bool XmlFile::exists() {
   ETG_TRACE_USR1(("RobustFile::exists(%100s) loaded=%u START", _name.c_str(), _loaded));
   if (_loaded) {
      return true;
   }
   restore();
   ETG_TRACE_USR1(("RobustFile::exists(%100s) loaded=%u END", _name.c_str(), _loaded));
   return _loaded;
}

TiXmlNode* Swu_TiXmlNode::StealChild(TiXmlNode *stealThis_) {
   Swu_TiXmlNode *stealThis = (Swu_TiXmlNode *) stealThis_;
   if (!stealThis) {
      return 0;
   }

   if (stealThis->parent != this) {
      assert( 0);
      return 0;
   }

   Swu_TiXmlNode *stolensNext = (Swu_TiXmlNode *) stealThis->next;
   Swu_TiXmlNode *stolensPrev = (Swu_TiXmlNode *) stealThis->prev;
   if (stolensNext)
      stolensNext->prev = stolensPrev;
   else
      lastChild = stolensPrev;

   if (stolensPrev)
      stolensPrev->next = stolensNext;
   else
      firstChild = stolensNext;

   //delete removeThis;
   stealThis->parent = 0;
   stealThis->next = 0;
   stealThis->prev = 0;
   return stealThis_;
}

TiXmlNode* Swu_TiXmlNode::StealChild(TiXmlNode *parent_, TiXmlNode *child) {
   Swu_TiXmlNode *parent = (Swu_TiXmlNode *) parent_;
   return parent->StealChild(child);
}
}

