#include "util/swu_wupAccess.h"

#include "util/swu_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_UTIL
#include "trcGenProj/Header/swu_wupAccess.cpp.trc.h"
#endif

namespace swu {

WUP_Access::WUP_Access():
   _hDeviceWup(OSAL_ERROR)
{}

WUP_Access::~WUP_Access() {
   close();
}

   bool WUP_Access::isOpen() {
      return (_hDeviceWup != OSAL_ERROR);
   }

   bool WUP_Access::open() {
      ETG_TRACE_USR1(("WUP_Access.open START, isOpen()=%u", isOpen()));

      if (!isOpen()) {
         printf("WUP_Access.open call OSAL_IOOpen\n");
         _hDeviceWup = OSAL_IOOpen (OSAL_C_STRING_DEVICE_WUP, OSAL_EN_READWRITE);
         printf("WUP_Access.open done: OSAL_IOOpen\n");
         if (!isOpen()) {
            ETG_TRACE_FATAL(("WUP_Access: could not open OSAL_C_STRING_DEVICE_WUP"));
         }
      }
      ETG_TRACE_USR1(("WUP_Access.open END isOpen()=%u", isOpen()));
      return isOpen();
   }

   void WUP_Access::close() {
      ETG_TRACE_USR1(("WUP_Access.close START, isOpen()=%u", isOpen()));
      if (isOpen()) {
         OSAL_s32IOClose(_hDeviceWup);
         _hDeviceWup=OSAL_ERROR;
      }
   }

bool WUP_Access::ioctl(tS32 code, DEV_WUP_trResetProcessorInfo options) {
   ETG_TRACE_USR1(("WUP_Access.ioctl : START isOpen=%u code=%d ", isOpen(), code));
   if (!isOpen()) {
      open();
   }
   bool allOk=isOpen();
   if (!allOk) {
      ETG_TRACE_FATAL(("WUP_Access.ioctl : could not open DEV_WUP"));
   }

   if (allOk) {
      tS32 osalRes=OSAL_s32IOControl(_hDeviceWup, code, (intptr_t)&options);
      allOk=(OSAL_OK == osalRes);
      if (!allOk) {
         ETG_TRACE_FATAL(("WUP_Access.ioctl : OSAL_s32IOControl failed"));
      }

      }
      ETG_TRACE_USR1(("WUP_Access.ioctl : END allOk=%u", allOk));

      return allOk;
   }
bool WUP_Access::ioctl(tS32 code, tS32 options) {

   ETG_TRACE_USR1(("WUP_Access.ioctl : START isOpen=%u code=%d options=%d", isOpen(), code, options));
   if (!isOpen()) {
      open();
   }
   bool allOk=isOpen();
   if (!allOk) {
      ETG_TRACE_FATAL(("WUP_Access.ioctl : could not open DEV_WUP"));
   }

   if (allOk) {
      tU8 u8StartType = 0;
      tS32 osalRes=OSAL_s32IOControl(_hDeviceWup, code, (intptr_t)&options);
      allOk=(OSAL_OK == osalRes);
      if (!allOk) {
         ETG_TRACE_FATAL(("WUP_Access.ioctl : OSAL_s32IOControl failed"));
      }

   }
   ETG_TRACE_USR1(("WUP_Access.ioctl : END allOk=%u", allOk));

   return allOk;
}

}


