/**
 * @file      swu_uin.hpp
 * @author    Philipp Blanke (blp4hi) <philipp.blanke@de.bosch.com>
 * @date      Thu 17 Dec 2015, 17:38
 * @copyright Robert Bosch Car Multimedia GmbH
 * @brief     Classes to provide the target's UIN.
 *
 */

#ifndef SWU_UIN_HPP
#define SWU_UIN_HPP

#include <string>
#include "util/swu_crypto.hpp"
#include "util/swu_singleton.hpp"

namespace swu {

/** @class UinInf 
 *  @brief Interface for UIN providers.
 */
class UinIf {
public:
   UinIf() : _uin(""), _loaded(false) {}
   virtual ~UinIf() {}
   virtual bool load()=0;

   std::string getUin ();
   bool isLoaded () const { return _loaded; }

protected:
   std::string _uin;
   bool _loaded;
};


/** @class NORUin
 *  @brief The class NORUin provides the UIN from NOR memory.
 */
class NORUin : public UinIf, public Singleton < NORUin >
{
   friend class Singleton< NORUin >;
   NORUin();

public:
   virtual ~NORUin() {}
   virtual bool load();

private:
   bool setUin (const std::vector<SWU_BYTE>& data);
};


/** @class SdcUin
 *  @brief The class SdcUin provides the UIN from a file encrypted with SDC.
 */
class SdcUin : public UinIf, public Singleton < SdcUin >
{
   friend class Singleton< SdcUin >;
   SdcUin();

public:
   virtual ~SdcUin() {}
   virtual bool load();
};

/** @class FileUin
 *  @brief The class FileUin provides the UIN from a file.
 */
class FileUin : public UinIf, public Singleton < FileUin >
{
   friend class Singleton< FileUin >;
   FileUin();

public:
   virtual ~FileUin() {}
   virtual bool load();
};
}

#endif /* !SWU_UIN_HPP */

