#ifndef SWU_TRACE_H
#define SWU_TRACE_H

#include "util/swu_types.h"
#include "../base/imp/swupd_trace.h"


#define SWU_TRACE_VARG(LVL, ... ) \
   if (etg_bIsTraceActive(TR_CLASS_SWUPDATE_UTIL, LVL)) {       \
      swu::traceVarg(LVL, __VA_ARGS__);                         \
   }

#define SWU_TRACE_VARG_ERR(... )                \
   SWU_TRACE_VARG(1, __VA_ARGS__ )
#define SWU_TRACE_VARG_USR1( ... )              \
   SWU_TRACE_VARG(5, __VA_ARGS__ )
#define SWU_TRACE_VARG_USR4( ... )              \
   SWU_TRACE_VARG(8, __VA_ARGS__ )

namespace swu {
void traceVarg(int traceLevel, char const *format,...);
void traceError(char const *text);
void traceInfo(char const *text);
void traceConsole(char const *text);
void traceAssert(char const *file, unsigned int line);
void traceBacktrace();

void printToDownloadPipe( std::string const &output);
void attachFileToDownloadPipe(std::string filename);

void print2errmem(char const *Format, ...);
void print2stdout(const char *Format, ...);
}


#endif
