#include <iostream>
#include <fstream>
#include <execinfo.h>

#include <unistd.h>        // for print2errmem()
#include <fcntl.h>         // for print2errmem()

#include "util/swu_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_UTIL
#include "trcGenProj/Header/swu_trace.cpp.trc.h"
#endif

namespace swu {
void traceVarg(int traceLevel, char const *format,... ) {
   va_list args;
   va_start(args, format);
   char text[255];
   vsnprintf(text, 255, format, args);
   text[254]=0;
   va_end(args);
   ETG_TRACE_LVL((traceLevel, "%s", text));
   if (!traceLevel) {
      printf("%s\n", text);
   }
}


  void traceError(const char *text) {
    ETG_TRACE_ERR(("ERROR: %s", text));
  }

  void traceInfo(const char *text) {
    ETG_TRACE_USR1(("INFO: %s", text));
  }
  
  void traceAssert(char const *file, unsigned int line) {
    ETG_TRACE_FATAL(("FATAL assert in file:%150s, line:%u", file, line));
    traceBacktrace();
  }

  void traceConsole(char const *text) {
     FILE *f;
     f = fopen("/dev/console","w");
     if (f) {
      fprintf(f,"%s\n", text);
      fclose(f);      
    }      
  }

void traceBacktrace()
{
#define SWU_MAX_BACKTRACE_ENTRIES 20

   void *aEntries[SWU_MAX_BACKTRACE_ENTRIES];
   size_t nEntries;
   char **ppFnNames;
   size_t i=0;
   ETG_TRACE_FATAL(("\n"));
   nEntries=backtrace(aEntries, SWU_MAX_BACKTRACE_ENTRIES);
   ppFnNames = backtrace_symbols(aEntries,static_cast<int> (nEntries) );
   ETG_TRACE_FATAL(("BACKTRACE: %d frames", nEntries));
   for (i=0; i < nEntries; i++) {
      ETG_TRACE_FATAL(("%s\n", ppFnNames[i]));
   }
   ETG_TRACE_FATAL(("\n"));
   free(ppFnNames);

}

void printToDownloadPipe(const std::string& output) {
   std::ofstream downloadPipe("/tmp/downloadPipe", std::ofstream::app);
   downloadPipe << output << "\n";
   std::cout << output << "\n";
   downloadPipe.close();
}

void attachFileToDownloadPipe(std::string filename) {
   std::ofstream downloadPipe("/tmp/downloadPipe", std::ofstream::app);
   std::ifstream source(filename.c_str());

   downloadPipe << source.rdbuf();
   downloadPipe << "\n";
   std::cout << source.rdbuf();

   source.close();
   downloadPipe.close();
}


//FIXME: Not nice, but ETG_TRACE_ERRMEM is unreadable
void print2errmem(const char *Format, ...)
{
  int     fd=open("/dev/errmem", O_WRONLY);
  char    msg[1024];
  va_list arglst;

  if(fd>=0)
  {
    va_start(arglst, Format);
    vsnprintf(msg, sizeof(msg), Format, arglst);
    va_end(arglst);
    write(fd, msg, strlen(msg));
    close(fd);
  }
}

void print2stdout(const char *Format, ...)
{
  int     fd=dup(STDOUT_FILENO);
  char    msg[1024];
  va_list arglst;

  if(fd<0)
    return;

  va_start(arglst, Format);
  vsnprintf(msg, sizeof(msg), Format, arglst);
  va_end(arglst);
  write(fd, msg, strlen(msg));
  close(fd);
}


}
