#include "swu_singleton.hpp"

#include "swu_memberList.hpp"
#include "swu_configItem.hpp"
#include "swu_configBase.hpp"
#include "swu_kds.h"
#include "swu_registry.h"
#include "util/swu_environment.hpp"
#include "util/swu_dataStore.hpp"

#include "util/swu_trace.h"


namespace fcswupdate {
using namespace swu;
using namespace std;

class SwuDataStoreIf:
      public DataStore,
      public Singleton<SwuDataStoreIf>
{
public:
   virtual char const *getName() {
      return "SwuDataStoreIf";
   }
   virtual void traceState(){};
private:
   SwuDataStoreIf():
      DataStore("/var/opt/bosch/persistent/dataStoreTest.xml")
{}
};


class SwuTestConfig:
      public ConfigBase,
      public Singleton<SwuTestConfig>
{
public:
   virtual char const *getName() {
      return "SwuTestConfig";
   }

   ConfigItem<tU32> cfg_testU32;
   ConfigItem<string> cfg_testStr;
   ConfigItem<tU32> cfg_testMarkerFile;
   ConfigItem<tU32> cfg_testKds;
   ConfigItem<string> cfg_testRegistry;
   ConfigItem<string> cfg_testDataStore;
   ConfigItem<string> cfg_testEnv;
   
   SwuTestConfig():
      cfg_testU32(this, "cfg_testU32", 0),
      cfg_testStr(this, "cfg_testStr", "cfg_testStrVal"),
      cfg_testMarkerFile(this, "cfg_testMarkerFile", 0,
                         new MarkerFileItemDescription("/tmp/swupd/SwuStarted")),
      cfg_testKds(this, "cfg_testKds", 0,
                   new KdsItemDescription<tU32>(0xA070, 16,  1, 2, enKsdEntryType_UInt)),
      cfg_testRegistry(this, "cfg_testRegistry", "",
                           new RegistryItemDescription<string>("/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/VERSIONS", "ADR_SW_Version")),
      cfg_testDataStore(this, "cfg_testDataStore", "DataStoreTestVal",
                        new DataStoreItemDescription<string>(_dataStore, "DataStoreTestVal")),
      cfg_testEnv(this, "cfg_testEnv", "testHome",
                           new EnvironmentItemDescription<string>("HOME"))

   {
      
   }

};

class SwuComp1: public Singleton<SwuComp1> {
public:
   friend class Singleton<SwuComp1>;
   void traceState(){};
   static tBool bSendLoobBackMsg(MsgCompBase<SwuComp1> *msg) {return false;};
   static const tU32 _id=81;

};

class SwuComp2: public Singleton<SwuComp2> {
public:
   friend class Singleton<SwuComp2>;
   void traceState(){};
   static tBool bSendLoobBackMsg(MsgCompBase<SwuComp2> *msg) {return false;};
   static const tU32 _id=82;
};

struct Msg_TestMsg11: public Msg< Msg_TestMsg11, SwuComp1 > {
   Msg_TestMsg11() {};
   virtual tVoid vTrace();
};

struct Msg_TestMsg12: public Msg< Msg_TestMsg12, SwuComp1 > {
   Msg_TestMsg12() {};
   virtual tVoid vTrace();
};

struct Msg_TestMsg21: public Msg< Msg_TestMsg21, SwuComp2 > {
   Msg_TestMsg21() {};
   virtual tVoid vTrace();
};

class SwuTestMemberSimple: public MemberBase, public Singleton<SwuTestMemberSimple> {
    friend class Singleton<SwuTestMemberSimple>;
public:
   void traceState(){};
  
};

class SwuTestMemberSimpleSingleton:public MemberBase, public Singleton<SwuTestMemberSimpleSingleton> {
    friend class Singleton<SwuTestMemberSimpleSingleton>;
public:
   void traceState(){};
  
};


class SwuTestMember11:public Member<SwuComp1>, public Singleton<SwuTestMember11> {
    friend class Singleton<SwuTestMember11>;
public:
   tVoid vProcess(Msg_TestMsg12 *pMsg){
      
   }
   void traceState(){};
  
};

class SwuTestMember12:public Member<SwuComp1>, public Singleton<SwuTestMember12> {
    friend class Singleton<SwuTestMember12>;
public:
   void traceState(){};
   
};

class SwuTestMember21:public Member<SwuComp2>, public Singleton<SwuTestMember21> {
    friend class Singleton<SwuTestMember21>;
public:
   void traceState(){};
   
};


class SwuTestMain1:  public Member<SwuComp1>, public Singleton<SwuTestMain1> {
    friend class Singleton<SwuTestMain1>;

  public:


    virtual tVoid vInit(){
       SwuTestConfig *cfg=SwuTestConfig::instance();
       _memberList.addMember(cfg)->vInit();
       tU32 u32Dummy;
       cfg->cfg_testU32.set(12);
       cfg->cfg_testU32.get(u32Dummy);
       string strDummy;
       cfg->cfg_testStr.set("hello testStr");
       cfg->cfg_testStr.get(strDummy);

       cfg->cfg_testMarkerFile.set(1);
       cfg->cfg_testMarkerFile.get(u32Dummy);

       cfg->cfg_testKds.set(0x815);
       cfg->cfg_testKds.get(u32Dummy);

       cfg->cfg_testRegistry.set("DummyRegistryVal");
       cfg->cfg_testRegistry.get(strDummy);

       cfg->cfg_testDataStore.set("DummyDataStoreVal");
       cfg->cfg_testDataStore.get(strDummy);

       cfg->cfg_testEnv.get(strDummy);

       
       _memberList.addMember(SwuTestMember11::instance())->vInit();
       _memberList.addMember(SwuTestMemberSimple::instance())->vInit();
       _memberList.addMember(SwuTestMemberSimpleSingleton::instance())->vInit();
       Msg_TestMsg11::vSubscribe(this);

    };
    virtual tVoid vDeInit(){};
     virtual const char *getName() {
        return "SwuTestMain1";
     }
     virtual void traceState();

    tVoid vProcess(Msg_TestMsg11 *pMsg){
       Msg_TestMsg12 *msg12= new Msg_TestMsg12;
       notify(*msg12);
       notifyLater(msg12);
       Msg_TestMsg11::vUnSubscribe(this);
    };
 

    MemberList<SwuComp1> _memberList;


  };
}
