#ifndef SWU_SINGLETON_HPP
#define SWU_SINGLETON_HPP

#include "util/swu_types.h"

namespace swu {

  /*
    Simple Singleton
  */
  template <typename C>
  class Singleton {
  public:
    static C* instance ()
    {
      if (!_instance) {
        _instance = OSAL_NEW C;
      }
      return _instance;
    }
    virtual ~Singleton ()
    {
      _instance = 0;
    }

     bool hasInstance() {
        return _instance!=0;
     }
     
  private:
    //lint -esym(1704, Singleton*::Singleton*) prio3 constructor has private access specification
    Singleton(const Singleton<C>&);	
    Singleton& operator=(const Singleton<C>&);
#ifdef __SW_UPDATE_UNIT_TESTING__
  public:
#endif
    static C* _instance;
  protected:
    Singleton () { }
    void setInstance(C* poThis) {
      _instance =poThis;
    }
  };

  template <typename C> C* Singleton <C>::_instance = 0;
}

#endif

