#ifndef SWU_REGISTRY_H
#define SWU_REGISTRY_H

#include "util/swu_memberList.hpp"
#include "util/swu_configItem.hpp"

class reg_tclRegKey;

namespace swu {


struct RegUtil {
private:
   RegUtil & operator=(const RegUtil &);
   RegUtil(const RegUtil &);

public:
   RegUtil(std::string path);

   ~RegUtil();

   bool bOpen();

   void vClose();
   bool bIsOpen() const {
      return _bOpen;
   };

   bool write(std::string key, tU32 val);
   bool write(std::string key, std::string val);
   bool write(std::string key, std::vector<tU8> val);


   bool read(std::string key, tU32 &val);
   bool read(std::string key, std::string &val);
   bool read(std::string key, std::vector<tU8> &val);



private:
   std::string _path;
   bool _bOpen;
   reg_tclRegKey *_oReg;
};



template<class VARTYPE>
struct RegistryItemDescription: public ItemDescription<VARTYPE> {

   RegistryItemDescription(std::string path, std::string key):
      _path(path),
      _key(key)
   {};

   bool write(VARTYPE const &val) {
      RegUtil regUtil(_path);
      return regUtil.write(_key, val);
   };

   bool read(VARTYPE &val) {
      RegUtil regUtil(_path);
      return regUtil.read(_key, val);
   };

   std::string _key;
   std::string _path;


};
}

#endif

