
#ifndef SWU_RCARBOOTCHAIN_H_
#define SWU_RCARBOOTCHAIN_H_


#include "swu_types.h"
#include "swu_singleton.hpp"
#include "swu_facUtil.h"

namespace swu {

#define MAGIC_ARRAY_SIZE  (5*4)
#define MAGIC_BUFFER_SIZE (MAGIC_ARRAY_SIZE * 4)
#define BLOCK_SIZE        512

class rcarBootChain :
      public Singleton<rcarBootChain> {
   
   friend class Singleton< rcarBootChain >;
   rcarBootChain();

public:

   virtual ~rcarBootChain() {}
   /**
     * Activates the recovery mode for the active boot chain.
     * @return true for success, else false
     */
   const bool activateRecoveryMode();


    /**
     * Activates the application mode for the active boot chain.
     * @return true for success, else false
     */
   const bool activateApplicationMode();

    /**
     * Switch the active boot chain to One.
     * @return true for success, else false
     */
   const bool switchBootChainOne();

    /**
     * Switch the active boot chain to Two.
     * @return true for success, else false
     */
   const bool switchBootChainTwo();

   /*
     switch the boot chain from active to inactive / inactive to active
     this is called in case of SW-Update.
    */
   const bool switchBootSectors();

   /*
     read Magic from hyperflash, 
    */
   bool readMagic(tU32 flashAddr, tU32 &val);

   /*
     write magic to hyperflash, inactive sector.
    */
   bool writeMagic(tU32 flashAddr, tU32 val);

   /*
     write magic to hyperflash, active sector.
    */
   bool writeMagicToActiveSector(tU32 flashAddr, tU32 val);

   /*
     erase the value in particular flash address
    */
   bool eraseMagic(tU32 flashAddr);

   /*
     get the active boot chain from Hyperflash
    */
   bool usedBootChain(tU32 &activeChain); 

   /*
     to know the recovery mode Magic is set / not
    */
   bool isRecoveryMagicSet(bool &isSet);

   /*
     dump boot all bootchain config.
    */
   void dumpBootChainConfig();

private:
   void getFacDataForReadBootChain_1(facInfo &info);
   void getFacDataForReadBootChain_2(facInfo &info);

   void getFacDataForWriteBootChain_1(facInfo &info);
   void getFacDataForWriteBootChain_2(facInfo &info);

   void getFacDataForEraseBootChain_1(facInfo &info);
   void getFacDataForEraseBootChain_2(facInfo &info);

   bool checkAndReadMagics();
   bool forceReadMagics();
   
   tU32 getMagicIndexFromAddr(tU32 relativeFlashAddr);

   void printDownloadPipe();

   tU32 _activeSectorChain;

   bool _inValidate;
   
   std::vector<tU32>  _magicAreaData_1;
   std::vector<tU32>  _magicAreaData_2;   

};
}

#endif
