#ifndef SWU_PRE_INIT_HPP
#define SWU_PRE_INIT_HPP

#include "util/swu_singleton.hpp"

namespace swu {


class PreInitBase;

template <class COMP>
class PreInit;

class PreInitManagerBase {
   
public:
   void execute();

protected:
   void reg(PreInitBase *usr);


   PreInitManagerBase():
   _first(0), _last(0) 
   {}

   PreInitBase *_first;
   PreInitBase *_last;
};


// use template to have pre-initialization separated by COMP
template <class COMP>
class PreInitManager: 
      public PreInitManagerBase,
      public Singleton<PreInitManager<COMP> > {
         friend class Singleton<PreInitManager<COMP> >;
   friend class PreInit<COMP>;

private:
   void reg(PreInit<COMP> *usr) {
      PreInitManagerBase::reg((PreInitBase *)usr);
   }

};


/*
  only static object may derive from PreInitBase
 */
class PreInitBase {
   friend class PreInitManagerBase;
protected:
   PreInitBase():_next(0) {};
   virtual ~PreInitBase() {
   }
   virtual void execute()=0;
private:
   // intrusive single linked list
   PreInitBase *_next;
};

template <class COMP>
class PreInit: public PreInitBase {
public:
PreInit():
   PreInitBase() {
   PreInitManager<COMP>::instance()->reg(const_cast<PreInit<COMP> *>(this));
}

};

}
#endif
