#ifndef SWU_OTP_H
#define SWU_OTP_H



#include "util/swu_types.h"
#include "util/swu_configItem.hpp"


namespace swu
{
    typedef std::map<unsigned int, unsigned int>  OTPDataMap;
    struct OTPItemDescriptionBase;



    class OTPDriver
    {
    public:
        static OTPDriver    *GetInstance(void);
        bool                GetData(unsigned int *Value, const unsigned int FuseID);

    private:
        OTPDriver();
        ~OTPDriver();
        bool    ParseHexChar(unsigned int *Value, const unsigned char Char);
        bool    AddToMap(const unsigned char *Buff, const int BuffLen);
        bool    ReadOTPArea(void);

        OTPDataMap  DataMap;

    public:
        static OTPDriver    *Instance;
    };
}
#endif  // SWU_OTP_H
