#ifndef SWU_MSG_CALLER_HPP
#define SWU_MSG_CALLER_HPP

#include <stdio.h>
#include "util/swu_types.h"

#include "util/swu_trace.h"
#include "util/swu_msgCallerBase.hpp"

namespace swu {

// forward-declaration of member.
// only members may receive messages
// iNotify is only allowed between classes that belong to same component 
class MemberMsg;

// forward-declaration of base-class for all messages
class MsgBase;



/*
	Caller-classes. Call unrelated target with given message-type 
*/

template<class MSG>
class MsgCallerMsgBase: public MsgCallerBase {
public:
   MsgCallerMsgBase(std::list<MsgCallerBase *> *poSubcriberList, bool hasPrio):MsgCallerBase(poSubcriberList, hasPrio)
    {}
	// generic interface called by base-class (base-class does not know about the specifc msg-type)
    virtual tVoid vCall(MsgBase *pMsg) {
		// forward vCall with correct msg-type
        vCall((MSG *)pMsg);
    };
	// we don't know the real type of the member to be called, so let it be implemented by the derived class
    virtual tVoid vCall(MSG *pMsg)=0;
};

// the leaf-class, a messge caller that knows real types of message and member
template<class MSG, class CLASS> 
class MsgCaller: public MsgCallerMsgBase<MSG>{
public:
   typedef typename CLASS::compType compType;
   MsgCaller(CLASS *poClass, std::list<MsgCallerBase *> *poSubcriberList, bool hasPrio):MsgCallerMsgBase<MSG>(poSubcriberList, hasPrio), _poClass(poClass) {};
    virtual tVoid vCall(MSG *pMsg) {
       // make sure that component match
       compType *dummy=(typename MSG::compType *)0;
        _poClass->vProcess(pMsg);
    }

   virtual MemberMsg *getMember() {
      MemberMsg *member=_poClass;
      return _poClass;
   }

    CLASS *_poClass;
};



}

#endif

