
#ifndef SWU_MSG_HPP
#define SWU_MSG_HPP

#include "util/swu_msgCaller.hpp"
#include "util/swu_sem.h"

#include "swu_types.h"

#include "util/swu_trace.h"
#include "swu_memberBase.hpp"

//lint -sem(::swu::MsgBase::bNotifyLater,custodial(msg))
//lint -sem(::swu::MsgCompBase::bNotifyLater,custodial(this))
namespace swu {

/*
  Message-classes the can be broadcasted
*/
// the base-class for all messages

//template<MSG, COMP_ROOT>


class MemberMsg;

template<class MSG,  class COMP_ROOT>
class Msg;


class MsgBase {
   template <class COMP_ROOT>
   friend class Member;
   template<class COMP_ROOT>
   friend class MsgCompBase;
public:
   virtual ~MsgBase() {
   }


   virtual std::list<MsgCallerBase *> &getSubscriberList()=0;

   static bool isSubscribed(MemberMsg *member, std::list<MsgCallerBase *> &subscriberList) {
      for(std::list<MsgCallerBase *>::iterator iter= subscriberList.begin();iter!=subscriberList.end();++iter) {
         MsgCallerBase *caller=*iter;
         MemberMsg *subscribedMember=caller->getMember();

         if (member==subscribedMember) {
            // subsription already exists, do nothing
            return true;
         }
      }
      return false;
   }

   virtual tVoid vTrace()=0;   



   static tVoid vUnSubscribe(MemberMsg *poThis, std::list<MsgCallerBase *> &_subscriberList) {
      bool doTrace=etg_bIsTraceActive(TR_CLASS_SWUPDATE_UTIL, ETG_LEVEL_USER_4);
      if (doTrace) {
         MsgBase::logAction("vUnSubscribe", (void *)poThis);
      }

      for(std::list<MsgCallerBase *>::iterator iter= _subscriberList.begin();iter!=_subscriberList.end();++iter) {
         MsgCallerBase *caller= *iter;
         MemberMsg *subscribedMember=caller->getMember();
         if (subscribedMember==poThis) {
            poThis->vRemoveCaller(caller);
            if (caller->_enState == MsgCallerBase::tenState_busy) {
               /* 
                  we can't delete an active caller, so mark it as deleted.
                  real deleting will be done, when the caller is no longer used
               */
               caller->_enState=MsgCallerBase::tenState_deleted;
            }
            else {
               OSAL_DELETE caller;
            }
            break;
         }
      }
   }

   virtual tBool bPost()=0;

   static void logAction(const char *action, void *poThis);
   void logNotify(char const *action, unsigned int iNotifyCount);
protected:
   tBool bNotifyLater(MsgBase *msg, std::list<MsgBase *>&msgQueue, tBool loopBackReady, Sem &sem);
   
private:
   static void onLoopbackReady(tBool &loopBackReady, std::list<MsgBase *>&msgQueue, Sem &sem); 
   // todo: restrict to member.notify
   tUInt  iNotify() {
      static tUInt iNotifyCount=0;
      tUInt iNotifyCountLocal = ++iNotifyCount;
      tUInt iNumNofify=0;
      bool doTrace=etg_bIsTraceActive(TR_CLASS_SWUPDATE_UTIL, ETG_LEVEL_USER_4);
      if (doTrace) {
         MsgBase::logNotify("START", iNotifyCountLocal);
         vTrace();
      }
      std::list<MsgCallerBase *>::iterator iter= getSubscriberList().begin();
      while( iter != getSubscriberList().end()) {
         std::list<MsgCallerBase *>::iterator iterNext=iter;
         MsgCallerBase *poCaller=*iter;
         if (poCaller->_enState==MsgCallerBase::tenState_deleted) {
	    // caller is deleted, don't use it
	    ++iter;
	    continue;
         }
         ++iterNext;
         poCaller->_enState=MsgCallerBase::tenState_busy;
         MsgBase *poThis=this;
         iNumNofify++;
         poCaller->vCall(poThis);
	  
         if (poCaller->_enState==MsgCallerBase::tenState_deleted) {
	    /*
	      during vCall the called member unsubscribed.
	      So we postponed deleting it, we do it now
	    */
	    OSAL_DELETE poCaller;
         } 
         else {
            poCaller->_enState=MsgCallerBase::tenState_idle;
         }
         iter=iterNext;

      }
      if (doTrace) {
         MsgBase::logNotify("END", iNotifyCountLocal);
      }

      return iNumNofify;
   }

   
};


template<class COMP_ROOT>
class MsgCompBase: public MsgBase {
public:
   typedef COMP_ROOT compType;
   template<class CLASS> 
   tUInt iNotifyByNonMember(CLASS *){
      typename CLASS::compType *dummy=(COMP_ROOT *) 0;
      return iNotify();
   }

   static void onLoopbackReady()  {
      MsgBase::onLoopbackReady(_loopBackReady, _msgQueue, _sem);
   }
   
   tBool bNotifyLater() {
      return MsgBase::bNotifyLater(this, _msgQueue, _loopBackReady, _sem);
   }

protected:
   static tBool _loopBackReady;
   static Sem _sem;
   static std::list<MsgBase *>_msgQueue;

};

template<typename COMP_ROOT>
tBool MsgCompBase<COMP_ROOT>::_loopBackReady;
template<typename COMP_ROOT>
std::list<MsgBase *> MsgCompBase<COMP_ROOT>::_msgQueue;
template<typename COMP_ROOT>
Sem MsgCompBase<COMP_ROOT>::_sem;



// template-base-class for a message
template<  class MSG, class COMP_ROOT>
class Msg: public MsgCompBase<COMP_ROOT> {
public:
   virtual std::list<MsgCallerBase *> &getSubscriberList() {
      return _subscriberList;
   }
   virtual tBool bPost() {
      COMP_ROOT::instance()->bSendLoobBackMsg(this);
      return true;
   }
   template< class CLASS>
   static tVoid vSubscribe(CLASS *poThis, bool hasPrio=false) {
      // member poThis wants to subsribe to this message
      bool doTrace=etg_bIsTraceActive(TR_CLASS_SWUPDATE_UTIL, ETG_LEVEL_USER_4);
      if (doTrace) {
         MsgBase::logAction("vSubscribe", (void *)poThis);
      }
      // check, if member poThis is already subscribed
      if (MsgBase::isSubscribed(poThis, _subscriberList)) {
            // subsription already exists, do nothing
         return;
      }
      // create new caller
      // provide poThis so the caller can call me later.
      // provide my subsciber-list, so the caller knows my subscriber-list.
      MsgCaller<MSG, CLASS> *caller= new MsgCaller<MSG, CLASS>(poThis, &_subscriberList, hasPrio);
      poThis->vAddCaller(caller);
   }

   static tVoid vUnSubscribe(MemberMsg *poThis) {
      MsgBase::vUnSubscribe(poThis, _subscriberList);
   };


private:
   static  std::list<MsgCallerBase *> _subscriberList;
};

template<typename MSG, typename COMP_ROOT> 
std::list<MsgCallerBase *> Msg<MSG, COMP_ROOT>::_subscriberList;
}

#endif

