#include "swu_msg.hpp"

#include "util/swu_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_UTIL
#include "trcGenProj/Header/swu_msg.cpp.trc.h"
#endif

using namespace std;

namespace swu { 

tBool MsgBase::bNotifyLater(MsgBase *msg, list<MsgBase *>&msgQueue, tBool loopBackReady, Sem &sem) {
   tBool bRes=TRUE;
   ETG_TRACE_USR4(("bNotifyLater START loopBackReady=%u", loopBackReady));
   sem.lock();
   if (!loopBackReady) {
      msgQueue.push_back(this);
   }
   else {
      bRes = bPost();
   }
   sem.unlock();
   ETG_TRACE_USR4(("bNotifyLater END loopBackReady=%u", loopBackReady));
   return bRes;
}

void MsgBase::onLoopbackReady(tBool &loopBackReady, list<MsgBase *>&msgQueue, Sem &sem) {
   // do this when loopback becomes avail
   sem.lock();
   ETG_TRACE_USR1(("MsgBase::onLoopbackReady START, q-size=%u", msgQueue.size()));
   loopBackReady=TRUE;
   while(!msgQueue.empty()) {
      MsgBase *pMsg=msgQueue.front();
      msgQueue.pop_front();
      pMsg->iNotify();
   }
   sem.unlock();
   ETG_TRACE_USR1(("MsgBase::onLoopbackReady END"));
}





void MsgBase::logAction(char const *action, void *poThis) {
   ETG_TRACE_USR4(("MsgBase::%30s (%p)", action, poThis));
}


void MsgBase::logNotify(char const *action, unsigned int iNotifyCount) {
   ETG_TRACE_USR4(("MsgBase::iNotify %6s (%p), (iNotifyCount=%u)", action, this,  iNotifyCount));
}


   
}
