#ifndef SWU_MEMBER_BASE_HPP
#define SWU_MEMBER_BASE_HPP

#include "swu_types.h"

#include "util/swu_trace.h"



namespace swu {
class MsgBase;
class MsgCallerBase;
class MemberBase {
   friend class MsgBase;
private:
   MemberBase & operator=(const MemberBase &);
   MemberBase(const MemberBase &);

public:
   virtual char const *getName() {
      return "UNKNOWN";
   }
   MemberBase() {};
   virtual ~MemberBase() {};
   virtual void traceState()=0;
   virtual tVoid vInit(){};
   virtual tVoid vDeInit(){};
   
public:

};

class MemberSimple: public MemberBase {
   friend class MsgBase;
public:


};


class MemberMsg: public MemberBase {
   friend class MsgBase;
public:
   virtual ~MemberMsg();
   tVoid vRemoveCaller(MsgCallerBase * caller);

protected:
   std::list<MsgCallerBase *> callerList;
protected:
   tVoid vAddCaller(MsgCallerBase *caller);



};


}

#endif

