/*
 * swu_localtime.hpp
 *
 *  Created on: Dec 18, 2013
 *      Author: efs1hi
 */

#ifndef SWU_LOCALTIME_HPP_
#define SWU_LOCALTIME_HPP_

#include <util/swu_types.h>

class TiXmlElement;

namespace swu {

class LocalTime {
public:
   LocalTime();

   LocalTime(std::string utc);

   LocalTime(const TiXmlElement *e);

   LocalTime(unsigned int year, unsigned int month, unsigned int day,
             unsigned int hour, unsigned int minute, unsigned int second=0);

   bool readXml(const TiXmlElement *e);

   TiXmlElement *toXml() const;




   unsigned int getYear() const;
   unsigned int getMonth() const;
   unsigned int getDay() const;
   unsigned int getHour() const;
   unsigned int getMinute() const;
   unsigned int getSecond() const;
   time_t getUTC() const;

   std::string toString() const;


   void traceState();



private:
   void fromString(std::string value);
   unsigned long long int _utc;
   unsigned int _year;
   unsigned int _month;
   unsigned int _day;
   unsigned int _hour;
   unsigned int _minute;
   unsigned int _second;

};

}

#endif
