/*
 * swu_localtime.cpp
 *
 *  Created on: Dec 18, 2013
 *      Author: efs1hi
 */

#include "tinyxml/tinyxml.h"
#include "util/swu_util.hpp"
#include "util/swu_localtime.hpp"
#include <sstream>
#include <time.h>

#include "util/swu_trace.h"
#include "util/swu_util.hpp"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_UTIL
#include "trcGenProj/Header/swu_localtime.cpp.trc.h"
#endif

namespace swu {



LocalTime::LocalTime(unsigned int year, unsigned int month, unsigned int day,
                     unsigned int hour, unsigned int minute, unsigned int second):
   _utc(0),
   _year(year), 
   _month(month),
   _day(day),
   _hour(hour),
   _minute(minute),
   _second(second){
   ETG_TRACE_COMP(("LocalTime CTOR(%u %u %u %u %u %u):%s", 
                   year, month, day, hour, minute,second,
                   toString().c_str()));
   
}

LocalTime::LocalTime() {
   time_t utc=time(NULL);
   _utc = (unsigned long long int)utc;
   struct tm tm;
   (void)localtime_r(&utc, &tm);

   _year=tm.tm_year + 1900;
   _month=tm.tm_mon + 1;
   _day=tm.tm_mday;
   _hour=tm.tm_hour;
   _minute=tm.tm_min;
   _second=tm.tm_sec;
   ETG_TRACE_COMP(("LocalTime CTOR(time):%s", toString().c_str()));
}


LocalTime::LocalTime(const TiXmlElement *e) {
   readXml(e);
}


void LocalTime::traceState() {
   toString();
}



LocalTime::LocalTime(std::string utcString) {
   fromString(utcString);
   ETG_TRACE_COMP(("LocalTime CTOR(utcString=%50s):%s", utcString.c_str(), toString().c_str()));

}
 
std::string LocalTime::toString() const {
   char res[100];
   res[99]=0;
   sprintf(res, "%04u-%02u-%02u %02u:%02u:%02u utc=%llu",
           _year, _month, _day, _hour, _minute, _second, _utc);
   
   //   ETG_TRACE_COMP(("LocalTime toString():%s", res));
   return std::string(res);
}

void LocalTime::fromString(std::string value) {
   ETG_TRACE_COMP(("LocalTime fromString(%s)", value.c_str()));
   _year=0; _month=0; _day=0; _hour=0; _minute=0; _second=0; _utc=0;
   sscanf(value.c_str(), 
          "%4u-%2u-%2u %2u:%2u:%2u utc=%llu", 
          &_year, &_month, &_day, &_hour, &_minute, &_second, &_utc);
   ETG_TRACE_COMP(("LocalTime fromString() res=%s", toString().c_str()));

}

/*
  creates
  <UTC>
  <utc>
    20016-09-05 13:45:59 utc=1234567
  </utc>
  </UTC>
 */
TiXmlElement *LocalTime::toXml() const {
   TiXmlElement *e=new TiXmlElement("UTC");
   addTextChild(e, "utc", toString());
   return e;
}

bool LocalTime::readXml(const TiXmlElement *e) {
   _utc=0;
   _year=0;
   _month=0;
   _day=0;
   _hour=0;
   _minute=0;
   _second=0;

   if (!e) {
      ETG_TRACE_ERR(("LocalTime::readXml():Can not read a local time from null pointer."));
      return false;
   }
   TiXmlElement const *base=e->FirstChildElement("utc");
   if (!base) {
      ETG_TRACE_ERR(("LocalTime::readXml():node utc missing."));
      return false;
   }
   
   const char *value = getTextFromChild(e, "utc", false);
   if (!value) {
      ETG_TRACE_ERR(("LocalTime::readXml():node utc is empty."));
      return false;
   }
   fromString(value);
   return true;
}

   unsigned int LocalTime::getYear() const
   {
      return _year;
   }

   unsigned int LocalTime::getMonth() const
   {
      return _month;
   }

   unsigned int LocalTime::getDay() const
   {
      return _day;
   }

   unsigned int LocalTime::getHour() const
   {
      return _hour;
   }

   unsigned int LocalTime::getMinute() const
   {
      return _minute;
   }

   unsigned int LocalTime::getSecond() const
   {
      return _second;
   }

   time_t LocalTime::getUTC() const
   {
      return static_cast<time_t> (_utc);  // gen3armmake, gen3x86make: conversion to 'time_t {aka long int}' from 'long long unsigned int'
   }


}


