#ifndef SWU_INC_IF_HPP
#define SWU_INC_IF_HPP

#include "inc/inc_ports.h"
#include "inc/inc_scc_port_extender_gpio.h"
#include "util/swu_types.h"

#include "util/swu_trace.h"


namespace swu {

struct DgramHolder;

class IncIf {
public:
   IncIf(uint16_t s16LocalPort=DOWNLOAD_PORT);
   ~IncIf();

   SWU_MOCK_VIRTUAL bool bOpen();

   SWU_MOCK_VIRTUAL void vClose();


   SWU_MOCK_VIRTUAL bool isOpen() {
      return _bOpen;
   }

   SWU_MOCK_VIRTUAL bool bSend(std::vector<tU8> &msg);


   SWU_MOCK_VIRTUAL bool bRecv(std::vector<tU8> &msg, tU32 rcvLen=_dgramRcvLen);

   
private:

   // sorry cannot forward-declare sk_dgram
   DgramHolder *_dgramHolder;
   tS32 _sockfd; 
   bool _bOpen;
   static const tU32 _dgramRcvLen = 0xFF;
   uint16_t _s16LocalPort; // standard network interface uses uint16_t so type is changed from int to uint16_t

   IncIf ( const IncIf & ); //Coverity fix for 48201
   IncIf & operator = ( const IncIf & ); //Coverity fix for 47835

};



}

#endif

