
#include "swu_globallog.h"

namespace swu {

void failureCallstack(std::string fileName, int line, std::string functionName, char const* format,...) {

   va_list args;
   va_start(args, format);
   char text[255];
   vsnprintf(text, 255, format, args);
   text[254]=0;
   va_end(args);

   traceLog log(fileName, line, functionName, FAILURE_TOKEN_TEXT, std::string(text));
   log.traceFatalLog();
   log.traceErrMemLog();
   log.traceConsoleLog();
   log.traceDownloadpipeLog(); 
}

void interfaceCallstack(std::string fileName, int line, std::string functionName, char const* format,...) {

   va_list args;
   va_start(args, format);
   char text[255];
   vsnprintf(text, 255, format, args);
   text[254]=0;
   va_end(args);

   traceLog log(fileName, line, functionName, INTERFACE_TOKEN_TEXT, std::string(text));
   log.traceFatalLog();
   log.traceDownloadpipeLog();
}

void infoCallstack(std::string fileName, int line, std::string functionName, char const* format,...) {

   va_list args;
   va_start(args, format);
   char text[255];
   vsnprintf(text, 255, format, args);
   text[254]=0;
   va_end(args);

   traceLog log(fileName, line, functionName, INFO_TOKEN_TEXT, std::string(text));
   log.traceFatalLog();
}


}

