

#include <string>
#include <vector>

#include "swu_util.hpp"
#include "swu_execCommand.h"
#include "swu_facUtil.h"
#include "swu_filesystem.h"

#include "base/imp/swupd_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
  #define ETG_DEFAULT_TRACE_CLASS     TR_CLASS_SWUPDATE_UTIL
  #include "trcGenProj/Header/swu_facUtil.cpp.trc.h"
#endif

namespace swu {

static const std::string _facDir = FAC_DIRECTORY;
static const std::string _inputFile = _facDir + "/input.txt";
static const std::string _outputFile = _facDir + "/output.txt";
static const std::string _logFile = _facDir + "/log.txt";
static const std::string _facOutLoc = "/opt/bosch/base/bin/fac_out.out";
static const std::string _readCmd = _facOutLoc + " if=SCCFLASH of=" + _outputFile;
static const std::string _writeCmd = _facOutLoc + " of=SCCFLASH if=" + _inputFile;
static const std::string _eraseCmd = _facOutLoc + " erase ";
static const std::string _verbose = "1";

static const tU32 _defaultBlockSize = 512;
static const tU32 _defaultCount = 1;


facUtil::facUtil() {
}

facUtil::~facUtil() {

}

bool facUtil::read(facInfo info, std::vector<tU32> &data) {
   ETG_TRACE_USR2(("facUtil::read - START"));
   bool bReturn = false;

   if(prepareFac(info)) {
   
      std::string cmd = _readCmd + " bs=" + intToString(info._blockSize) + " skip=" + intToString(info._skip) + " count=" + intToString(info._count) + " seek=" + intToString(info._seek) + " verbose=" + _verbose +" ?>> " + _logFile;
      
      ETG_TRACE_USR4(("facUtil::read cmd:%s", cmd.c_str()));
      tU32 facExitCode = execCommand(cmd);
      ETG_TRACE_USR3(("facUtil::read, FAC exitcode:%u", facExitCode));
             
      if(exists(_outputFile)) {
         
         std::string succText = " echo fac::read has passed with code:" + intToString(facExitCode) + " ?>> " + _logFile;
         execCommand(succText);
         
         if(loadFile(_outputFile, data)) {
            ETG_TRACE_USR3(("facUtil::read:loadFile passed"));
            bReturn = true;
         } else {
            std::string errText = " echo fac::read has failed with code:" + intToString(facExitCode) + " ?>> " + _logFile;
            execCommand(errText);

            std::string hexDump = "hexdump " + _outputFile + " ?>> " + _logFile;
            ETG_TRACE_FATAL(("loadFile is fails:%s", _outputFile.c_str()));
         }
      } else {
         ETG_TRACE_FATAL(("_outputFile:%s is not present", _outputFile));
      }
      
   } else {
      ETG_TRACE_FATAL(("prepareFac is failed"));
   }
      
   ETG_TRACE_USR2(("facUtil::read - END status:%u", bReturn));
   return bReturn;
}

bool facUtil::write(facInfo info, std::vector<tU32> data) {
   
   ETG_TRACE_USR2(("facUtil::write - START"));
   bool bReturn = false;

   if(prepareFac(info)) {
      
      if(writeFile(data, _inputFile)) {
         ETG_TRACE_USR3(("writing to file success:%s", _inputFile.c_str()));

         std::string cmd = _writeCmd + " bs=" + intToString(info._blockSize) + " skip=" + intToString(info._skip) + " count=" + intToString(info._count) + " seek=" + intToString(info._seek) + " verbose=" + _verbose +" ?>> " + _logFile;
         
         ETG_TRACE_USR3(("facUtil::write, cmd:%s", cmd.c_str()));
         
         tU32 facExitCode = execCommand(cmd);
         ETG_TRACE_USR3(("facUtil::write, FAC exitcode:%u", facExitCode));
         
         if(!facExitCode) {
            std::string succText = " echo fac::write has passed with code:" + intToString(facExitCode) + " ?>> " + _logFile;
            execCommand(succText);
            bReturn = true;
         } else {
            std::string errText = " echo fac::write has failed with code:" + intToString(facExitCode) + " ?>> " + _logFile;
            execCommand(errText);
         }
      }
   }
   
   ETG_TRACE_USR2(("facUtil::write,END bReturn:%u", bReturn));
   return bReturn;

}

bool facUtil::erase(facInfo info) {
   
   ETG_TRACE_USR2(("facUtil::erase - START"));
   bool bReturn = false;

   std::string cmd = _eraseCmd + "bs=" + intToString(info._blockSize) + " seek=" + intToString(info._seek) + " count=" + intToString(info._count) +" verbose=" + _verbose + " ?>> " + _logFile;

   ETG_TRACE_USR4(("facUtil::erase cmd:%s", cmd.c_str()));
   tU32 facExitCode = execCommand(cmd);
   ETG_TRACE_USR3(("facUtil::erase, FAC exitcode:%u", facExitCode));        
   
   if(!facExitCode) {
      std::string succText = " echo fac::erase has passed with code:" + intToString(facExitCode) + " ?>> " + _logFile;
      execCommand(succText);      
      bReturn = true;
   } else {
      std::string errText = " echo fac::erase has failed with code:" + intToString(facExitCode) + " ?>> " + _logFile;
      execCommand(errText);        
   }

   ETG_TRACE_USR2(("facUtil::erase-END, bReturn:%u", bReturn));
   return bReturn;

}


bool facUtil::prepareFac(facInfo &info) {
   ETG_TRACE_USR2(("facUtil::prepareFac - START"));

   if(!exists(_facOutLoc)) {
      ETG_TRACE_FATAL(("fac out is not found in path:%s", _facOutLoc.c_str()));
      return false;
   }

   if(info._blockSize == 0) {
      info._blockSize = _defaultBlockSize;
   }

   if(info._count == 0) {
      info._count = _defaultCount;
   }

   if(!makeDirectoryRecursive(FAC_DIRECTORY, 0755)) {
      ETG_TRACE_USR1(("facUtil::prepareFac: can't create the FAC directory"));
   }

   if(exists(_inputFile)) {
      removeFile(_inputFile);
   }

   if(exists(_outputFile)) {
      removeFile(_outputFile);
   }

   ETG_TRACE_USR2(("facUtil::prepareFac - END"));

   return true;
}


}
