#include <sys/stat.h>
#include <sys/wait.h>
//#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>

//#include "sstream"
//#include <iostream>
//#include <fstream>
//#include <regex.h>

#include <fstream>
#include "swu_filesystem.h"

#include <pthread.h>
#include <signal.h>
#include "util/swu_types.h"
#include "util/swu_util.hpp"
#include "util/swu_execCommand.h"
#include "util/swu_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_UTIL
#include "trcGenProj/Header/swu_execCommand.cpp.trc.h"
#endif

namespace swu {

static const unsigned int SYSTEM_CALL_MAX_BUFFER = 256;

int32_t execCommand(const std::string & inSystemCall) {
   ETG_TRACE_COMP(("execScript was entered for command %s", inSystemCall.c_str()));

   pid_t ret, pid;
   int status;
   bool  redirectStdOut=false;
   bool  redirectStdErr=false;
   bool  redirect=false;
   bool append=false;
   bool  background=false;
   int fd = -1;

   char * const env[] = { strdup("HOME=/"), strdup("PATH=/bin:/usr/bin:/sbin:/usr/sbin:/opt/bosch/base/bin"), NULL };
   char log_file[SYSTEM_CALL_MAX_BUFFER] = { 0 };

   char *str1, *token, *saveptr;
   char * args[SYSTEM_CALL_MAX_BUFFER] = { 0 };
   uint32_t j = 0;

   str1 = const_cast < char* >(inSystemCall.c_str());
   for (;; j++, str1 = NULL) {
      token = strtok_r(str1, " ", &saveptr);
      if (token == NULL) {
         break;
      }
      ETG_TRACE_COMP(("execCommand token='%s'", token));

      if(background)
      {
         // & has to be the last token
         ETG_TRACE_ERR(("found tokens after &"));
         // Force the function to go into error handling. Even the error message matches quite well
         j=SYSTEM_CALL_MAX_BUFFER-1;
      }
      else if (redirect && !log_file[0])
      {
         // should be last token, the outfile for redirection
         ETG_TRACE_COMP(("log file name = %s", token));
         strncpy(log_file, token, SYSTEM_CALL_MAX_BUFFER);
         log_file[SYSTEM_CALL_MAX_BUFFER - 1] = 0;
      }
      else if(!strcmp(token, "&"))
      {
         // should be the last token
         ETG_TRACE_COMP(("execCommand will execute in background"));
         background=true;
      }
      else if (!strcmp(token, ">") || !strcmp(token, "1>") ) {
         ETG_TRACE_COMP(("execCommand set redirect stdout"));
         // found redirection-pattern
         redirectStdOut=true;
         redirect=true;
      } 
      else if (!strcmp(token, ">>") || !strcmp(token, "1>>") ) {
         // found redirection-pattern
         ETG_TRACE_COMP(("execCommand set redirect, stdout, append"));
         append=true;
         redirectStdOut=true;
         redirect=true;
      } 
      else if(!strcmp(token, "2>")) {
         ETG_TRACE_COMP(("execCommand set redirect, stderr"));
         redirectStdErr=true;
         redirect=true;
      }
      else if(!strcmp(token, "2>>")) {
         ETG_TRACE_COMP(("execCommand set redirect, stderr, append"));
         append=true;
         redirectStdErr=true;
         redirect=true;
      }
      else if(!strcmp(token, "?>")) {
         ETG_TRACE_COMP(("execCommand set redirect, stderr, stderr"));
         redirectStdOut=true;
         redirectStdErr=true;
         redirect=true;
      }
      else if(!strcmp(token, "?>>")) {
         ETG_TRACE_COMP(("execCommand set redirect, stderr, stderr, append"));
         append=true;
         redirectStdOut=true;
         redirectStdErr=true;
         redirect=true;
      }
      else {
         ETG_TRACE_COMP(("execCommand set args[%u]:'%s'", j, token));
         args[j] = (char *) malloc(sizeof(char) * (strlen(token) + 1));
         strcpy(args[j], token);
      }
      if (j >= SYSTEM_CALL_MAX_BUFFER - 1) {
         ETG_TRACE_ERR(("Too many params: %s", inSystemCall.c_str()));
         for (int k = 0; env[k] != NULL; k++) {
            free(env[k]);
         }
         for (int k = 0; args[k] != NULL; k++) {
            free(args[k]);
         }
         return 32000;
      }
   }

   args[j] = NULL;
   int i = 0;

   ETG_TRACE_COMP(("Parameters:"));
   while (args[i] != NULL) {
      ETG_TRACE_COMP(("  %s ", args[i]));
      i++;
   }

   if (redirect) {
      if (append) {
      fd = open(log_file, O_CREAT | O_WRONLY | O_APPEND, S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH);
      }
      else {
         fd = open(log_file, O_CREAT | O_WRONLY, S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH);
      }
   }

   pid = fork();
   if (pid == -1) {
      ETG_TRACE_ERR(("fork error"));
      for (int k = 0; env[k] != NULL; k++) {
         free(env[k]);
      }
      for (int k = 0; args[k] != NULL; k++) {
         free(args[k]);
      }
      if (fd >= 0)
         close(fd);
      return 32001;
   } else if (pid != 0) {
      ETG_TRACE_COMP(("execCommand started pid %d", pid));
      for (int k = 0; env[k] != NULL; k++) {
         free(env[k]);
      }
      for (int k = 0; args[k] != NULL; k++) {
         free(args[k]);
      }

      if(background)
         return 0;

      while ((ret = waitpid(pid, &status, 0)) == -1) {
         if (errno != EINTR) {
            /* Handle error */
            ETG_TRACE_ERR(("Error in not EINTR, it is %s", strerror(errno)));
            ETG_TRACE_ERR(("  as int: %d", errno));
            break;
         }
      }

      ETG_TRACE_COMP(("execCommand: RET=%d", ret));
      ETG_TRACE_COMP(("execCommand: status=%d", status));

      if (WIFEXITED(status)) {
         ETG_TRACE_COMP(("execCommand: returned %d", WEXITSTATUS(status)));
         if (fd >= 0)
            close(fd);
         return WEXITSTATUS(status);
      }

      if (fd >= 0)
         close(fd);
      return 0;
   } else {
      if (redirectStdOut) {
         close(1);
         if (fd >= 0)
            dup2(fd, 1);
      }
      if (redirectStdErr) {
         close(2);
         if (fd >= 0)
            dup2(fd, 2);
      }
      if (execvpe(args[0], args, env) == -1) {
         ETG_TRACE_ERR(("execCommand: could not start command %s", inSystemCall.c_str()));
         _Exit(127);
      }
      // Here are dragons!
      ETG_TRACE_FATAL(("execCommand: dragons found..."));
   }

   // Here are dragons!
   ETG_TRACE_FATAL(("execCommand: was left in the area with the dragons..."));
   if (fd >= 0)
      close(fd);
   return 32002;
}

int32_t execCommandSimple(const char *Cmd, ...)
{
   ETG_TRACE_COMP(("execCommandSimple was entered for command %s", Cmd));

   char *const env[]={ strdup("HOME=/"), strdup("PATH=/bin:/usr/bin:/sbin:/usr/sbin:/opt/bosch/base/bin"), NULL };
   va_list     arglst;
   char        **args=(char **)malloc(sizeof(char *));
   int         argnum=0;
   char        *next_arg;
   pid_t       pid;
   int         ret, status;

   va_start(arglst, Cmd);

   args[0]=strdup(Cmd);
   for(next_arg=va_arg(arglst, char *); next_arg; next_arg=va_arg(arglst, char *))
   {
      args=(char **)realloc(args, sizeof(char *)*(++argnum+2));
      args[argnum]=strdup(next_arg);
   }
   args[argnum+1]=NULL;

   va_end(arglst);

   pid=fork();
   if(pid==-1)
   {
      ETG_TRACE_ERR(("fork error"));
      for(int i=0; env[i]; ++i)
         free(env[i]);
      for(int i=0; args[i]; ++i) {
         free(args[i]);
         args[i] = 0;
      }
      free(args);
      return 32001;
   }
   else if(pid)
   {
      ETG_TRACE_COMP(("execCommand started pid %d", pid));
      while((ret=waitpid(pid, &status, 0))==-1)
      {
         if(errno!=EINTR)
         {
            /* Handle error */
            ETG_TRACE_ERR(("Error in not EINTR, it is %s", strerror(errno)));
            ETG_TRACE_ERR(("  as int: %d", errno));
            break;
         }
      }

      for(int i=0; env[i]; ++i)
         free(env[i]);
      for(int i=0; args[i]; ++i) {
         free(args[i]);
         args[i] = 0;
      }
      free(args);
      args = 0;

      ETG_TRACE_COMP(("execCommand: RET=%d", ret));
      ETG_TRACE_COMP(("execCommand: status=%d", status));

      if(WIFEXITED(status))
      {
         ETG_TRACE_COMP(("execCommand: returned %d", WEXITSTATUS(status)));
      }

      return WEXITSTATUS(status);
   }
   else
   {
      if(execvpe(args[0], args, env)==-1)
      {
         ETG_TRACE_ERR(("execCommand: could not start command %s", Cmd));
         _Exit(127);
      }
      // Here are dragons!
      ETG_TRACE_FATAL(("execCommand: dragons found..."));
   }

   // Here are dragons!
   ETG_TRACE_FATAL(("execCommand: was left in the area with the dragons..."));
   for (int i = 0; env[i]; ++i)
      free(env[i]);
   for (int i = 0; args[i]; ++i) {
      free(args[i]);
      args[i] = 0;
   }
   free(args);
   args = 0;

   return 32002;
}


}
