/*
 * fcswupd_environment.h
 *
 *  Created on: May 5, 2014
 *      Author: efs1hi
 */

#ifndef SWU_ENVIRONMENT_H_
#define SWU_ENVIRONMENT_H_

#include <stdlib.h>
#include <errno.h>
#include "swu_configItem.hpp"
#include "swu_util.hpp"

#include "util/swu_trace.h"

namespace swu {

class EnvironmentItemTracer {
public:
   static void traceAction(const char *action, const std::string &key, const std::string &value, bool success);
   static void traceAction(const char *action, const std::string &key, tU32 value, bool success);

};

template<class VALTYPE>
class EnvironmentItemDescription: public ItemDescription<VALTYPE> {
public:
   EnvironmentItemDescription(const std::string &key) :
         _key(key) {
   }

   virtual ~EnvironmentItemDescription() {
   }

   bool readFromEnvironment(const std::string &key, std::string &value) {
      bool success=false;
      char *envValue = getenv(key.c_str());
      if (envValue) {
         value = envValue;
         success=true;
      }
      EnvironmentItemTracer::traceAction("readFromEnvironment", key, value, success);
      return success;
   }

   bool readFromEnvironment(const std::string &key, tU32 &value) {
      bool success=false;
      char *envValue = getenv(key.c_str());
      if (envValue) {
         value = atoi(envValue);
         success = true;
      }
      EnvironmentItemTracer::traceAction("readFromEnvironment", key, value, success);
      return success;
   }

   virtual bool read(VALTYPE &value) {
      return readFromEnvironment(_key, value);
   }



   bool writeToEnvironment(const std::string &key, std::string const &value) {
      bool success=true;
      int res = setenv(key.c_str(), value.c_str(), 1);
      if (res) {
         success=false;
      }
      EnvironmentItemTracer::traceAction("writeToEnvironment", key, value, success);

      return success;
   }

   bool writeToEnvironment(const std::string &key, tU32 const &value) {
      bool success=true;
      int res = setenv(key.c_str(), intToString(value).c_str(), 1);
      if (res) {
         success = false;
      }
      EnvironmentItemTracer::traceAction("writeToEnvironment", key, value, success);

      return success;
   }


   virtual bool write(VALTYPE const &value) {
      return writeToEnvironment(_key, value);
      return false;
   }

   virtual void sync() {
   }

   virtual void remove() {
   }
private:
   std::string _key;
};

} // namespace

#endif
