#ifndef SWU_DATASTORE_HPP
#define SWU_DATASTORE_HPP

#include "util/swu_singleton.hpp"
#include "util/swu_member.hpp"
#include "util/swu_kvstore.hpp"
#include "util/swu_configItem.hpp"

namespace swu {

class DataStoreItemDescriptionBase {
public:

   DataStoreItemDescriptionBase(std::string key);
   std::string _key;
};


class DataStore:
      public MemberSimple,
      public KVStore {
    

public:
   DataStore(std::string const &dataStoreFileName);

   virtual char const *getName() {
      return "DataStore";
   }

   virtual void traceState() {
      trace();
   }
     
   virtual tVoid vInit() {
      init();
   }
     
};




template<class VALTYPE>
struct DataStoreItemDescription: 
      public ItemDescription<VALTYPE>
{
public:

   DataStoreItemDescription(DataStore *dataStore, std::string key):
      _dataStore(dataStore),
      _description(key)
   {
      SWU_ASSERT_RETURN(_dataStore);
      SWU_ASSERT_RETURN(!key.empty());
   }
      
   virtual bool read(VALTYPE &value) {
      return _dataStore->read(_description._key, value);
   }

   virtual bool write(VALTYPE const &value) {
      bool res =_dataStore->write(_description._key, value);
      sync();
      return res;
   }

   virtual void sync() {
      _dataStore->sync();
   }

   virtual void remove() {
      _dataStore->removeKey(_description._key);
      _dataStore->sync();      
   }


   DataStoreItemDescriptionBase _description;
   DataStore * const _dataStore;
};

}
#endif
