#include "util/swu_cryptoFactory.hpp"

using namespace swu;

CryptoFactory::CryptoFactory()
   : _src_type(CertificateAndKeySourceNOR)
{}

CryptoFactory::CryptoFactory(tenCertificateAndKeySource src_type)
{
   _src_type = src_type;
}

CryptoFactory::~CryptoFactory()
{}

CTargetKeyIf* CryptoFactory::createTargetKey () const
{
   switch (_src_type) {
   case CertificateAndKeySourceNOR:
      return NORTargetKey::instance();
   case CertificateAndKeySourceSDC:
      return SdcTargetKey::instance();
   case CertificateAndKeySourceFile:
      return FileTargetKey::instance();
   }
   return 0;
}

CACertIf* CryptoFactory::createCaCert () const
{
   switch (_src_type) {
   case CertificateAndKeySourceNOR:
      return NORCaCert::instance();
   case CertificateAndKeySourceSDC:
      return SdcCaCert::instance();
   case CertificateAndKeySourceFile:
      return FileCaCert::instance();
   }
   return 0;
}

UinIf* CryptoFactory::createUin () const
{
   switch (_src_type) {
   case CertificateAndKeySourceNOR:
      return NORUin::instance();
   case CertificateAndKeySourceSDC:
      return SdcUin::instance();
   case CertificateAndKeySourceFile:
      return FileUin::instance();
   }
   return 0;
}

