/*
 * swu_constants.hpp
 *
 *  Created on: Feb 17, 2014
 *      Author: efs1hi
 */
#include <stdint.h>
#include <string>
#include <sys/types.h>

#ifndef SWU_CONSTANTS_HPP_
#define SWU_CONSTANTS_HPP_

namespace swu {
namespace Constants {

   struct Ascii {
      static uint8_t const CR;
      static uint8_t const LF;
   };

   struct XML {
      static const ::std::string update_decision__diff;
      static const ::std::string update_decision__force;
      static const ::std::string update_decision__skip;
      static const ::std::string update_decision__update;
      static const ::std::string update_decision__updateNewOrSame;
      static const ::std::string update_decision__invalid;

      static const ::std::string update_progress_state__pending;
      static const ::std::string update_progress_state__running;
      static const ::std::string update_progress_state__ok;
      static const ::std::string update_progress_state__failed;
      static const ::std::string update_progress_state__not_affected;

      static const char* TAG_FINALNAME;
      static const char* TAG_FINALNAME_CUSTOMER;
      static const char* TAG_BUILD_LABEL;
      static const char* TAG_CISSWVERSIONNAME;
   };

   struct Registry {
      static char const * REGISTRY_LABEL_ID; // e.g. AI_PRJ_RN_AIVI_16.0V05
      static char const * REGISTRY_VERSION_ID; // e.g. 0085_160123
      static char const * REGISTRY_TIMESTAMP_ID;
      static const std::string PATH_BASE;
      static const std::string PATH_CUSTOMER_VERSION_REG;
      static const std::string PATH_CUSTOMER_VERSION_CFG;
      static const mode_t MODE_BASE;
      static const mode_t MODE_CUSTOMER_VERSION_CFG;
      static const std::string PATH_OVERALL_CIS_SW_VERSION_REG;
   };
   
   struct User {
      static const uid_t root;
      static const uid_t eco_lcm;
      static const uid_t pj_nav;
   };

   struct Group {
      static const gid_t root;
      static const gid_t eco_osal;
      static const gid_t pj_nav_share;
   };

   struct Cert {
      static const std::string PEM_BEGIN_STR;

      static char const * PUBLIC_KEY_BEGIN_STR;
      static char const * PUBLIC_KEY_END_STR;
      static char const * CERTIFICATE_BEGIN_STR;
      static char const * CERTIFICATE_END_STR;
      static char const * DELIM_TERMINATING_STR;
      static char const * MD_BEGIN_DELIM_STR;
      static char const * MD_END_DELIM_STR;
      static char const * ENCRYPTED_MD_BEG_DELIM_STR;
      static char const * ENCRYPTED_MD_END_DELIM_STR;
      static char const * SIGNED_MD_BEG_DELIM_STR;
      static char const * SIGNED_MD_END_DELIM_STR;
      static char const * ENCRYPT_PARAM_BEGIN_STR;
      static char const * ENCRYPT_PARAM_END_STR;
      static const ::std::string MIME_STRING;
      static uint32_t const BUFFER_SIZE;
   };

   struct Manifest {
      static char const * MANIFEST_ID;
      static char const * SW_PN_ID;
   };

   struct Mmc {
      static char const * MMC_WHOLE_DEVICE_NAME;
      static char const * MTD0_DEVICE_NAME;
      static char const * MTD0_BLOCK_DEVICE_NAME;
      static uint32_t const MTD_ERASED_MASK;
      static uint32_t const MTD_ZEROED_MASK;
      static uint32_t const MTD_MAGIC_BUFFER_SIZE;
      static uint32_t const MTD_CERTIFICATE_BUFFER_SIZE;
      static uint32_t const MTD_KEY_BUFFER_SIZE;
      static uint32_t const MTD_UIN_BUFFER_SIZE;
      static uint32_t const MTD_MAGIC_CHAIN1_OFFSET;
      static uint32_t const MTD_MAGIC_CHAIN2_OFFSET;

      static uint32_t const MTD_RECOVERY_MAGIC_OFFSET;
      static uint32_t const MTD_RECOVERY_MAGIC_ACTIVE;
      static uint32_t const MTD_RECOVERY_MAGIC_INACTIVE;

      static uint32_t const MTD_CERTIFICATE1_OFFSET;
      static uint32_t const MTD_CERTIFICATE2_OFFSET;
      static uint32_t const MTD_TARGET_KEY1_OFFSET;
      static uint32_t const MTD_TARGET_KEY2_OFFSET;
      static uint32_t const MTD_TARGET_UIN1_OFFSET;
      static uint32_t const MTD_TARGET_UIN2_OFFSET;
      static uint32_t const VALID_MAGIC_VALUE;
      static uint32_t const USE_SECOND_BOOT_CHAIN;
      static uint32_t const SIZE_BOOT_CHAIN_REGISTRY;
      static uint32_t const OFFSET_BOOT_CHAIN1_REGISTRY;
      static uint32_t const OFFSET_BOOT_CHAIN2_REGISTRY;
   };

   struct RCAR {
      static char     const * MMC_WHOLE_DEVICE_NAME;
      static uint32_t const HYPERFLASH_ERASED_MASK;
      static uint32_t const HYPERFLASH_ZEROED_MASK;
      static uint32_t const HYPERFLASH_MAGIC_BUFFER_SIZE;
      static uint32_t const HYPERFLASH_CERTIFICATE_BUFFER_SIZE;
      static uint32_t const HYPERFLASH_KEY_BUFFER_SIZE;
      static uint32_t const HYPERFLASH_UIN_BUFFER_SIZE;
      
      static uint32_t const HYPERFLASH_MAGIC_CHAIN1_OFFSET;
      static uint32_t const HYPERFLASH_MAGIC_CHAIN1_COUNTER_ADDR;
      static uint32_t const HYPERFLASH_MAGIC_CHAIN1_STATUS_ADDR;
      static uint32_t const HYPERFLASH_MAGIC_CHAIN1_ETHERNET_ADDR;
      static uint32_t const HYPERFLASH_MAGIC_CHAIN1_ROOTFS_ADDR;
      static uint32_t const HYPERFLASH_MAGIC_CHAIN2_OFFSET;
      static uint32_t const HYPERFLASH_MAGIC_CHAIN2_COUNTER_ADDR;
      static uint32_t const HYPERFLASH_MAGIC_CHAIN2_STATUS_ADDR;
      static uint32_t const HYPERFLASH_MAGIC_CHAIN2_ETHERNET_ADDR;
      static uint32_t const HYPERFLASH_MAGIC_CHAIN2_ROOTFS_ADDR;
      
      static uint32_t const HYPERFLASH_RECOVERY_MAGIC_OFFSET;
      static uint32_t const HYPERFLASH_RECOVERY_MAGIC_ACTIVE;
      static uint32_t const HYPERFLASH_RECOVERY_MAGIC_INACTIVE;
      static uint32_t const HYPERFLASH_ROOTFS1_ACTIVE;
      static uint32_t const HYPERFLASH_ROOTFS2_ACTIVE;

      static uint32_t const HYPERFLASH_CERTIFICATE1_OFFSET;
      static uint32_t const HYPERFLASH_CERTIFICATE2_OFFSET;
      static uint32_t const HYPERFLASH_TARGET_KEY1_OFFSET;
      static uint32_t const HYPERFLASH_TARGET_KEY2_OFFSET;
      static uint32_t const HYPERFLASH_TARGET_UIN1_OFFSET;
      static uint32_t const HYPERFLASH_TARGET_UIN2_OFFSET;
      static uint32_t const VALID_MAGIC_VALUE;
      static uint32_t const INVALID_MAGIC_VALUE;
      static uint32_t const USE_SECOND_BOOT_CHAIN;
      static uint32_t const SIZE_BOOT_CHAIN_REGISTRY;
      static uint32_t const OFFSET_BOOT_CHAIN1_REGISTRY;
      static uint32_t const OFFSET_BOOT_CHAIN2_REGISTRY;
   };

   struct SDC {
      static char const* PATH_UIN;
      static char const* PATH_PRIVKEY;
      static char const* PATH_PUBKEY;
      static char const* PATH_BIKEY;  
      static char const* PATH_CACERT;

      static char const* PSA_PATH_PRIVKEY;
      static char const* PSA_PATH_PUBKEY;
      static char const* PSA_PATH_CACERT;
   };

} // ns Constants
} // ns swu

#endif
